#!/bin/bash
echo $1
echo $2
echo $3

inputFile=$1
outputFile=$2
outputDir=$3
dir="$(cd "$(dirname "$0")" && pwd)"
mkdir $3
Rscript --verbose $dir/RScript.r $inputFile $outputDir $outputDir 2>&1
echo "<html>" >> $2
echo "<img src='VPlot.png'/>" >> $2
echo "<img src='DPlot.png'/>" >> $2
echo "<img src='JPlot.png'/>" >> $2

samples=`cat $outputDir/samples.txt`
count=1
echo "<table border='1'>" >> $outputFile
for sample in $samples; do
	echo "<tr><td colspan='3' height='100'></td>" >> $outputFile
	echo "<tr><td colspan='3'><h1>$sample</h1></td></tr>" >> $outputFile
	echo "<tr><td><h2>V-D Heatmap:</h2></td><td><h2>V-J Heatmap:</h2></td><td><h2>D-J Heatmap:</h2></td></tr><tr>" >> $outputFile
	mv "$outputDir/HeatmapVD_$sample.png" "$outputDir/VD_$sample.png"
	echo "<td><img src='VD_$sample.png'/></td>" >> $outputFile
	mv "$outputDir/HeatmapVJ_$sample.png" "$outputDir/VJ_$sample.png"
	echo "<td><img src='VJ_$sample.png'/></td>" >> $outputFile
	mv "$outputDir/HeatmapDJ_$sample.png" "$outputDir/DJ_$sample.png"
	echo "<td><img src='DJ_$sample.png'/></td></tr>" >> $outputFile
	count=$((count+1))
done
echo "</table>" >> $outputFile

echo "</html>" >> $2

