#!/bin/bash

inputFile=$1
outputDir=$3
outputFile=$3/index.html #$2
clonalType=$4
dir="$(cd "$(dirname "$0")" && pwd)"
mkdir $3
Rscript --verbose $dir/RScript.r $inputFile $outputDir $outputDir $clonalType 2>&1
cp $dir/tabber.js $outputDir
cp $dir/style.css $outputDir
cp $dir/script.js $outputDir
cp $dir/jquery-1.11.0.min.js $outputDir
cp $dir/jquery.tablesorter.min.js $outputDir
cp $dir/asc.gif $outputDir
cp $dir/desc.gif $outputDir
cp $dir/bg.gif $outputDir
echo "<html><center><h1><a href='index.html'>Click here for the results</a></h1>Tip: Open it in a new tab (middle mouse button or right mouse button -> 'open in new tab' on the link above)</center></html>" > $2
echo "<html<head>" >> $outputFile
echo "<script type='text/javascript' src='jquery-1.11.0.min.js'></script>" >> $outputFile
echo "<script type='text/javascript' src='tabber.js'></script>" >> $outputFile
echo "<script type='text/javascript' src='script.js'></script>" >> $outputFile
echo "<script type='text/javascript' src='jquery.tablesorter.min.js'></script>" >> $outputFile
echo "<link rel='stylesheet' type='text/css' href='style.css'></head>" >> $outputFile
echo "<div class='tabber'><div class='tabbertab' title='Gene frequencies'>" >> $outputFile

echo "<img src='VFPlot.png'/>" >> $outputFile
echo "<img src='DFPlot.png'/>" >> $outputFile
echo "<img src='JFPlot.png'/>" >> $outputFile
echo "<img src='VPlot.png'/>" >> $outputFile
echo "<img src='DPlot.png'/>" >> $outputFile
echo "<img src='JPlot.png'/></div>" >> $outputFile

samples=`cat $outputDir/samples.txt`
count=1
echo "<div class='tabbertab' title='Heatmaps'><div class='tabber'>" >> $outputFile
for sample in $samples; do
	echo "<div class='tabbertab' title='$sample'><table border='1'><tr>" >> $outputFile
	echo "<td><img src='HeatmapVD_$sample.png'/></td>" >> $outputFile
	echo "<td><img src='HeatmapVJ_$sample.png'/></td>" >> $outputFile
	echo "<td><img src='HeatmapDJ_$sample.png'/></td></tr></table></div>" >> $outputFile
	count=$((count+1))
done
echo "</div></div>" >> $outputFile


hasReplicateColumn="$(if head -n 1 $inputFile | grep -q 'Replicate'; then echo 'Yes'; else echo 'No'; fi)"
echo "$hasReplicateColumn"
#if its a 'new' merged file with replicate info
if [[ "$hasReplicateColumn" == "Yes" ]] ; then
	echo "<div class='tabbertab' title='Clonality'><div class='tabber'>" >> $outputFile
	for sample in $samples; do
		clonalityScore="$(cat $outputDir/ClonalityScore_$sample.csv)"
		echo "<div class='tabbertab' title='$sample'><table border='1'>" >> $outputFile
		echo "<tr><td colspan='4'>Clonality Score: $clonalityScore</td></tr>" >> $outputFile

		#replicate,reads,squared
		echo "<tr><td>Replicate ID</td><td>Number of Reads</td><td>Reads Squared</td><td></td></tr>" >> $outputFile
		while IFS=, read replicate reads squared
		do
			
			echo "<tr><td>$replicate</td><td>$reads</td><td>$squared</td><td></td></tr>" >> $outputFile
		done < $outputDir/ReplicateReads_$sample.csv
		
		#sum of reads and reads squared
		while IFS=, read readsSum squaredSum
			do
				echo "<tr><td>Sum</td><td>$readsSum</td><td>$squaredSum</td></tr>" >> $outputFile
		done < $outputDir/ReplicateSumReads_$sample.csv
		
		#overview
		echo "<tr><td>Coincidence Type</td><td>Raw Coincidence Freq</td><td>Coincidence Weight</td><td>Coincidences, Weighted</td></tr>" >> $outputFile
		while IFS=, read type count weight weightedCount
		do
			echo "<tr><td>$type</td><td>$count</td><td>$weight</td><td>$weightedCount</td></tr>" >> $outputFile
		done < $outputDir/ClonalityOverView_$sample.csv
		echo "</table></div>" >> $outputFile
	done
	echo "</div></div>" >> $outputFile
fi

hasJunctionData="$(if head -n 1 $inputFile | grep -q '3V-REGION trimmed-nt nb'; then echo 'Yes'; else echo 'No'; fi)"

if [[ "$hasJunctionData" == "Yes" ]] ; then
	echo "<div class='tabbertab' title='Junction Analysis'><table border='1' id='junction_table'  class='tablesorter'><thead><tr><th>Sample</th><th>unique</th><th>VH.DEL</th><th>P1</th><th>N1</th><th>P2</th><th>DEL.DH</th><th>DH.DEL</th><th>P3</th><th>N2</th><th>P4</th><th>DEL.JH</th><th>Total.Del</th><th>Total.N</th><th>Total.P</th><thead></tr><tbody>" >> $outputFile
	while IFS=, read Sample unique VHDEL P1 N1 P2 DELDH DHDEL P3 N2 P4 DELJH TotalDel TotalN TotalP
	do
		echo "<tr><td>$Sample</td><td>$unique</td><td>$VHDEL</td><td>$P1</td><td>$N1</td><td>$P2</td><td>$DELDH</td><td>$DHDEL</td><td>$P3</td><td>$N2</td><td>$P4</td><td>$DELJH</td><td>$TotalDel</td><td>$TotalN</td><td>$TotalP</td></tr>" >> $outputFile
	done < $outputDir/junctionAnalysis.csv
	echo "</tbody></table></div>" >> $outputFile
fi

echo "<div class='tabbertab' title='Comparison'><table border='1'><tr><th>ID</th><th>Include</th></tr>" >> $outputFile
for sample in $samples; do
	echo "<tr><td>$sample</td><td><input type='checkbox' onchange=\"javascript:compareAdd('$sample')\" id='compare_checkbox_$sample'/></td></tr>" >> $outputFile
done
echo "</table><div name='comparisonarea'>" >> $outputFile
echo "<table><tr id='comparison_table_vd'></tr></table>" >> $outputFile
echo "<table><tr id='comparison_table_vj'></tr></table>" >> $outputFile
echo "<table><tr id='comparison_table_dj'></tr></table>" >> $outputFile
echo "</div></div>" >> $outputFile

echo "<div class='tabbertab' title='Downloads'>" >> $outputFile
echo "<table border='1'>" >> $outputFile
echo "<tr><th>Description</th><th>Link</th></tr>" >> $outputFile
echo "<tr><td>The dataset used to generate the frequency graphs and the heatmaps (Unique based on clonaltype, $clonalType)</td><td><a href='allUnique.csv'>Download</a></td></tr>" >> $outputFile
echo "<tr><td>The dataset used to calculate clonality score (Unique based on clonaltype, $clonalType)</td><td><a href='clonalityComplete.csv'>Download</a></td></tr>" >> $outputFile

echo "<tr><td>The dataset used to generate the V gene family frequency graph</td><td><a href='VFFrequency.csv'>Download</a></td></tr>" >> $outputFile
echo "<tr><td>The dataset used to generate the D gene family frequency graph</td><td><a href='DFFrequency.csv'>Download</a></td></tr>" >> $outputFile
echo "<tr><td>The dataset used to generate the J gene family frequency graph</td><td><a href='JFFrequency.csv'>Download</a></td></tr>" >> $outputFile

echo "<tr><td>The dataset used to generate the V gene frequency graph</td><td><a href='VFrequency.csv'>Download</a></td></tr>" >> $outputFile
echo "<tr><td>The dataset used to generate the D gene frequency graph</td><td><a href='DFrequency.csv'>Download</a></td></tr>" >> $outputFile
echo "<tr><td>The dataset used to generate the J gene frequency graph</td><td><a href='JFrequency.csv'>Download</a></td></tr>" >> $outputFile

for sample in $samples; do
	echo "<tr><td>The data used to generate the VD heatmap for $sample.</td><td><a href='HeatmapVD_$sample.csv'>Download</a></td></tr>" >> $outputFile
	echo "<tr><td>The data used to generate the VJ heatmap for $sample.</td><td><a href='HeatmapVJ_$sample.csv'>Download</a></td></tr>" >> $outputFile
	echo "<tr><td>The data used to generate the DJ heatmap for $sample.</td><td><a href='HeatmapDJ_$sample.csv'>Download</a></td></tr>" >> $outputFile
done

echo "</table>" >> $outputFile
echo "</div></html>" >> $outputFile
