#!/bin/bash
echo $1
echo $2
echo $3

inputFile=$1
outputFile=$2
outputDir=$3
clonalType=$4
dir="$(cd "$(dirname "$0")" && pwd)"
mkdir $3
Rscript --verbose $dir/RScript.r $inputFile $outputDir $outputDir $clonalType 2>&1
echo "<html>" >> $2
echo "<img src='VPlot.png'/>" >> $2
echo "<img src='DPlot.png'/>" >> $2
echo "<img src='JPlot.png'/>" >> $2

samples=`cat $outputDir/samples.txt`
count=1
echo "<table border='1'><caption><h3>$clonalType</h3></caption>" >> $outputFile
for sample in $samples; do
	clonalityScore="$(cat $outputDir/ClonalityScore_$sample.csv)"
	echo "<tr><td colspan='3' height='100'></td></tr>" >> $outputFile
	echo "<tr><td colspan='3'><h1>$sample</h1></td></tr>" >> $outputFile

	#if its a 'new' merged file with replicate info
	if head -n 1 $inputFile | grep -q "Replicate"
	then
		echo "<tr><td colspan='3'><h2>Clonality Score: $clonalityScore</h2></td></tr>" >> $outputFile
	
		#replicate,reads,squared
		echo "<tr><td colspan='3'><table border='1'><tr><th>Replicate ID</th><th>Number of Reads</th><th>Reads Squared</th></tr>" >> $outputFile
		while IFS=, read replicate reads squared
		do
			
			echo "<tr><td>$replicate</td><td>$reads</td><td>$squared</td></tr>" >> $outputFile
		done < $outputDir/ReplicateReads_$sample.csv
		
		#sum of reads and reads squared
		while IFS=, read readsSum squaredSum
			do
				echo "<tr><td>Sum</td><td>$readsSum</td><td>$squaredSum</td></tr>" >> $outputFile
		done < $outputDir/ReplicateSumReads_$sample.csv
		
		echo "</table></td></tr>" >> $outputFile
		
		#overview
		echo "<tr><td colspan='3'><table border='1'><tr><th>Coincidence Type</th><th>Raw Coincidence Freq</th><th>Coincidence Weight</th><th>Coincidences, Weighted</th></tr>" >> $outputFile
		while IFS=, read type count weight weightedCount
		do
			echo "<tr><td>$type</td><td>$count</td><td>$weight</td><td>$weightedCount</td></tr>" >> $outputFile
		done < $outputDir/ClonalityOverView_$sample.csv
		echo "</table></td></tr>" >> $outputFile
	fi
	
	echo "<tr><td><h2>V-D Heatmap:</h2></td><td><h2>V-J Heatmap:</h2></td><td><h2>D-J Heatmap:</h2></td></tr><tr>" >> $outputFile
	mv "$outputDir/HeatmapVD_$sample.png" "$outputDir/VD_$sample.png"
	echo "<td><img src='VD_$sample.png'/></td>" >> $outputFile
	mv "$outputDir/HeatmapVJ_$sample.png" "$outputDir/VJ_$sample.png"
	echo "<td><img src='VJ_$sample.png'/></td>" >> $outputFile
	mv "$outputDir/HeatmapDJ_$sample.png" "$outputDir/DJ_$sample.png"
	echo "<td><img src='DJ_$sample.png'/></td></tr>" >> $outputFile
	count=$((count+1))
done
echo "</table>" >> $outputFile

echo "</html>" >> $2

