#!/usr/bin/env bash
set -e

dir="$(cd "$(dirname "$0")" && pwd)"

input="$1"
omt1="$2"
omt2="$3"
omt3="$4"
omt4="$5"
omt5="$6"
inheritance="$7"
orderby="$8"
outdir="$9"
html="${10}"

echo "input: ${input}"
echo "omt1: ${omt1}"
echo "omt2: ${omt2}"
echo "omt3: ${omt3}"
echo "omt4: ${omt4}"
echo "omt5: ${omt5}"
echo "inheritance: ${inheritance}"
echo "orderby: ${orderby}"
echo "html: ${html}"
echo "outdir: ${outdir}"

mkdir "$outdir"



Rscript --verbose $dir/phenotype_gene_relations_plot.r "$input" "$omt1" "$omt2" "$omt3" "$omt4" "$omt5" "$inheritance" "$orderby" "$outdir" 2>&1

echo "<h2>CulaPhenAGen</h2><br />" > "$html"
echo "<div style='width: 10000px;'>" >> "$html"
echo "<img src='plot1_avg.png' /><br />" >> "$html"
echo "<img src='plot1.png' /><br />" >> "$html"
echo "</div>" >> "$html"
echo "<img src='plot2.png' /><br />" >> "$html"
echo "<img src='plot3.png' /><br />" >> "$html"

echo "<table border='1'>" >> $html
first="true"
while read diseaseId gene url
	do
		if [[ "$first" == "true" ]] ; then
			echo "<thead>" >> $html
			echo "<tr><th colspan='3'>Disease.gene/Group.name</th></tr>" >> $html
			echo "<tr><th>$diseaseId</th><th>$gene</th><th>$url</th></tr>" >> $html
			echo "</thead>" >> $html
			first="false"
			continue
		fi
		echo "<tr>" >> $html
		echo "<td>$diseaseId</td>" >> $html
		echo "<td>$gene</td>" >> $html
		echo "<td><a href='$url'>$url</a></td>" >> $html
		echo "</tr>" >> $html
done < "${outdir}/disease_gene_url_1.txt"

echo "<table border='1'>" >> $html
first="true"
while read diseaseId gene url
	do
		if [[ "$first" == "true" ]] ; then
			echo "<thead>" >> $html
			echo "<tr><th colspan='3'>OMT.5.name/Disease</th></tr>" >> $html
			echo "<tr><th>$diseaseId</th><th>$gene</th><th>$url</th></tr>" >> $html
			echo "</thead>" >> $html
			first="false"
			continue
		fi
		echo "<tr>" >> $html
		echo "<td>$diseaseId</td>" >> $html
		echo "<td>$gene</td>" >> $html
		echo "<td><a href='$url'>$url</a></td>" >> $html
		echo "</tr>" >> $html
done < "${outdir}/disease_gene_url_2.txt"

echo "</center>" >> $html
