args <- commandArgs(trailingOnly = TRUE)

imgt.dir = args[1]
merged.file = args[2]

merged = read.table(merged.file, header=T, sep="\t", fill=T, stringsAsFactors=F)

for(f in list.files(imgt.dir, pattern="*.txt$")){
	print(paste("filtering", f))
	path = paste(imgt.dir, f, sep="")
	dat = read.table(path, header=T, sep="\t", fill=T, quote="", stringsAsFactors=F)
	
	dat = dat[dat$Sequence.ID %in% merged$Sequence.ID,]
	
	if("FR1.IMGT" %in% colnames(dat)){
		dat$FR1.IMGT = ""
	}
	
	write.table(dat, path, quote=F, sep="\t", row.names=F, col.names=T)
}
