args <- commandArgs(trailingOnly = TRUE)


summaryfile = args[1]
mutationanalysisfile = args[2]
mutationstatsfile = args[3]
hotspotsfile = args[4]
gene_identification_file= args[5]
output = args[6]
unmatchedfile = args[7]
method=args[8]
functionality=args[9]
unique_type=args[10]

summ = read.table(summaryfile, header=T, sep="\t", fill=T, stringsAsFactors=F)
mutationanalysis = read.table(mutationanalysisfile, header=T, sep="\t", fill=T, stringsAsFactors=F)
mutationstats = read.table(mutationstatsfile, header=T, sep="\t", fill=T, stringsAsFactors=F)
hotspots = read.table(hotspotsfile, header=T, sep="\t", fill=T, stringsAsFactors=F)
gene_identification = read.table(gene_identification_file, header=T, sep="\t", fill=T, stringsAsFactors=F)

if(method == "blastn"){
	"qseqid\tsseqid\tpident\tlength\tmismatch\tgapopen\tqstart\tqend\tsstart\tsend\tevalue\tbitscore"
	gene_identification = gene_identification[!duplicated(gene_identification$qseqid),]
	ref_length = data.frame(sseqid=c("ca1", "ca2", "cg1", "cg2", "cg3", "cg4", "cm"), ref.length=c(81,81,141,141,141,141,52))
	gene_identification = merge(gene_identification, ref_length, by="sseqid", all.x=T)
	gene_identification$chunk_hit_percentage = (gene_identification$length / gene_identification$ref.length) * 100
	gene_identification = gene_identification[,c("qseqid", "chunk_hit_percentage", "pident", "qstart", "sseqid")]
	colnames(gene_identification) = c("Sequence.ID", "chunk_hit_percentage", "nt_hit_percentage", "start_locations", "best_match")
	
}

summ = merge(summ, gene_identification, by="Sequence.ID")

if(functionality == "no_results"){
	summ = summ[summ$Functionality != "No results",]
} else if (functionality == "no_result_unproductive"){
	summ = summ[summ$Functionality != "No results" | summ$Functionality != "unproductive",]
}

higher_than=(summ$chunk_hit_percentage >= 70 & summ$nt_hit_percentage >= 70)
unmatched = summ[!higher_than,]
unmatched = unmatched[,c("Sequence.ID", "chunk_hit_percentage", "nt_hit_percentage", "start_locations", "best_match")]
unmatched$best_match = paste("unmatched,", unmatched$best_match)
summ = summ[higher_than,]

if(length(summ$Sequence.ID) == 0){
	stop("No data remaining after filter")
}

result = merge(summ, mutationanalysis[,!(names(mutationanalysis) %in% names(summ)[-1])], by="Sequence.ID")
result = merge(result, mutationstats[,!(names(mutationstats) %in% names(result)[-1])], by="Sequence.ID")
result = merge(result, hotspots[,!(names(hotspots) %in% names(result)[-1])], by="Sequence.ID")

cleanup_columns = c("FR1.IMGT.Nb.of.mutations", 
                    "CDR1.IMGT.Nb.of.mutations", 
                    "FR2.IMGT.Nb.of.mutations", 
                    "CDR2.IMGT.Nb.of.mutations", 
                    "FR3.IMGT.Nb.of.mutations")

for(col in cleanup_columns){
  result[,col] = gsub("\\(.*\\)", "", result[,col])
  result[,col] = as.numeric(result[,col])
  result[is.na(result[,col]),] = 0
}

result$VGene = gsub("^Homsap ", "", result$V.GENE.and.allele)
result$VGene = gsub("[*].*", "", result$VGene)
result$JGene = gsub("^Homsap ", "", result$J.GENE.and.allele)
result$JGene = gsub("[*].*", "", result$JGene)

#result$past = paste(result$AA.JUNCTION, result$VGene, result$JGene, (result$FR1.IMGT.Nb.of.mutations + result$CDR1.IMGT.Nb.of.mutations + result$FR2.IMGT.Nb.of.mutations + result$CDR2.IMGT.Nb.of.mutations + result$FR3.IMGT.Nb.of.mutations), result$best_match)
if(unique_type == "AA.JUNCTION_V_subclass"){
	result$past = paste(result$AA.JUNCTION, result$VGene, result$best_match)
} else if (unique_type == "AA.JUNCTION_subclass"){
	result$past = paste(result$AA.JUNCTION, result$best_match)
} else if (unique_type == "V_subclass"){
	result$past = paste(result$VGene, result$best_match)
} else if (unique_type == "AA.JUNCTION_V"){
	result$past = paste(result$AA.JUNCTION, result$VGene)
} else if (unique_type == "AA.JUNCTION"){
	result$past = paste(result$AA.JUNCTION)
} else {
	result$past = 1:nrow(result)
}


result = result[!duplicated(result$past), ]

result = result[,!(names(result) %in% c("past"))]

print(paste("Number of rows in result:", nrow(result)))
print(paste("Number of rows in unmatched:", nrow(unmatched)))

write.table(x=result, file=output, sep="\t",quote=F,row.names=F,col.names=T)
write.table(x=unmatched, file=unmatchedfile, sep="\t",quote=F,row.names=F,col.names=T)
