args <- commandArgs(trailingOnly = TRUE)

naive.file = args[1]
shm.file = args[2]
output.file = args[3]

naive = read.table(naive.file, sep="\t", header=T, quote="", fill=T)
shm.merge = read.table(shm.file, sep="\t", header=T, quote="", fill=T)


final = merge(naive, shm.merge[,c("Sequence.ID", "best_match")], by.x="ID", by.y="Sequence.ID")
print(paste("nrow final:", nrow(final)))
names(final)[names(final) == "best_match"] = "Sample"
final.numeric = final[,sapply(final, is.numeric)]
final.numeric[is.na(final.numeric)] = 0
final[,sapply(final, is.numeric)] = final.numeric
print(paste("nrow final:", nrow(final)))
final2 = final
final2$Sample = gsub("[0-9]", "", final2$Sample)
final = rbind(final, final2)
final$Replicate = 1

write.table(final, output.file, quote=F, sep="\t", row.names=F, col.names=T)
