if (!("ggplot2" %in% rownames(installed.packages()))) {
	install.packages("ggplot2", repos="http://cran.xl-mirror.nl/") 
}
library(ggplot2)

args <- commandArgs(trailingOnly = TRUE)

vls = args[1]
lbls = args[2]
name = args[3]
output = args[4]

vls = as.numeric(unlist(strsplit(vls, ",")))
lbls = unlist(strsplit(lbls, ","))

pc = ggplot(data.frame(Type=lbls, vls=vls), aes(x = factor(1), y=vls, fill=Type))
pc = pc + geom_bar(width = 1, stat = "identity")
pc = pc + coord_polar(theta="y")
pc = pc + xlab(" ") + ylab(" ") + ggtitle(name)

png(filename=output)
#pie(vls, labels=lbls, col=rainbow(length(vls)), main=name)
pc
dev.off()
