import re
import argparse

parser = argparse.ArgumentParser()
parser.add_argument("--mutationfile", help="The '7_V-REGION-mutation-and-AA-change-table' file from the IMGT output")
parser.add_argument("--hotspotfile", help="The '10_V-REGION-mutation-hotspots' file from the IMGT output")
parser.add_argument("--output", help="Output file")

args = parser.parse_args()

mutationfile = args.mutationfile #"test_VH-Ca_Cg_25nt/7_V-REGION-mutation-and-AA-change-table_test_VH-Ca_Cg_25nt_241013.txt"
hotspotsfile = args.hotspotfile #"test_VH-Ca_Cg_25nt/10_V-REGION-mutation-hotspots_test_VH-Ca_Cg_25nt_241013.txt"
outfile = args.output #"out.txt"

mutationdic = dict()
mutationMatcher = re.compile("^(.)(\d+).(.),?(.)?(\d+)?.?(.)?(.?.?.?.?.?)?")
linecount = 0

with open(mutationfile, 'r') as i:
  for line in i.readlines()[1:]:
		linecount += 1
		linesplt = line.split("\t")
		if linesplt[2] != "productive":
			continue
		ID = linesplt[1]
		mutationdic[ID + "_FR1"] = [mutationMatcher.match(x).groups() for x in linesplt[5].split("|") if x]
		mutationdic[ID + "_CDR1"] = [mutationMatcher.match(x).groups() for x in linesplt[6].split("|") if x]
		mutationdic[ID + "_FR2"] = [mutationMatcher.match(x).groups() for x in linesplt[7].split("|") if x]
		mutationdic[ID + "_CDR2"] = [mutationMatcher.match(x).groups() for x in linesplt[8].split("|") if x]
		mutationdic[ID + "_FR2-CDR2"] = mutationdic[ID + "_FR2"] + mutationdic[ID + "_CDR2"]
		mutationdic[ID + "_FR3"] = [mutationMatcher.match(x).groups() for x in linesplt[9].split("|") if x]
    
if linecount == 0:
	print "No data, exiting"
	with open(outfile, 'w') as o:
		o.write("RGYW (%),0,0,NA\n")
		o.write("WRCY (%),0,0,NA\n")
		o.write("WA (%),0,0,NA\n")
		o.write("TW (%),0,0,NA\n")
	import sys
	sys.exit()

hotspotMatcher = re.compile("[actg]+,(\d+)-(\d+)\((.*)\)")
RGYWCount = 0
WRCYCount = 0
WACount = 0
TWCount = 0

with open(hotspotsfile, 'r') as i:
	for line in i.readlines()[1:]:
		linesplt = line.split("\t")
		if linesplt[2] != "productive":
			continue
		ID = linesplt[1]
		RGYW = [(int(x),int(y),z) for (x,y,z) in [hotspotMatcher.match(x).groups() for x in linesplt[6].split("|") if x]]
		WRCY = [(int(x),int(y),z) for (x,y,z) in [hotspotMatcher.match(x).groups() for x in linesplt[7].split("|") if x]]
		WA = [(int(x),int(y),z) for (x,y,z) in [hotspotMatcher.match(x).groups() for x in linesplt[4].split("|") if x]]
		TW = [(int(x),int(y),z) for (x,y,z) in [hotspotMatcher.match(x).groups() for x in linesplt[5].split("|") if x]]
		RGYWCount += sum([1 for (x,y,z) in RGYW if z != "CDR3" and any([(x <= int(where) <= y) for (frm, where, to, a,b,c,d) in mutationdic[ID + "_" + z]])])
		WRCYCount += sum([1 for (x,y,z) in WRCY if z != "CDR3" and any([(x <= int(where) <= y) for (frm, where, to, a,b,c,d) in mutationdic[ID + "_" + z]])])
		WACount += sum([1 for (x,y,z) in WA if z != "CDR3" and any([(x <= int(where) <= y) for (frm, where, to, a,b,c,d) in mutationdic[ID + "_" + z]])])
		TWCount += sum([1 for (x,y,z) in TW if z != "CDR3" and any([(x <= int(where) <= y) for (frm, where, to, a,b,c,d) in mutationdic[ID + "_" + z]])])

path = outfile[:outfile.rfind("/") + 1] + "mutations.txt"
value = 0;
with open(path, 'r') as f:
	value = f.readlines()[0].split(",")[1]
with open(outfile, 'w') as o:
	if value != "0":
		o.write("RGYW (%)," + str(RGYWCount) + "," + value + "," + str(round(RGYWCount / float(value) * 100, 1)) + "\n")
		o.write("WRCY (%)," + str(WRCYCount) + "," + value + "," + str(round(WRCYCount / float(value) * 100, 1)) + "\n")
		o.write("WA (%)," + str(WACount) + "," + value + "," + str(round(WACount / float(value) * 100, 1)) + "\n")
		o.write("TW (%)," + str(TWCount) + "," + value + "," + str(round(TWCount / float(value) * 100, 1)) + "\n")
	else:
		o.write("RGYW (%)," + str(RGYWCount) + ",0,NA\n")
		o.write("WRCY (%)," + str(WRCYCount) + ",0,NA\n")
		o.write("WA (%)," + str(WACount) + ",0,NA\n")
		o.write("TW (%)," + str(TWCount) + ",0,NA\n")


