library(ggplot2)

args <- commandArgs(trailingOnly = TRUE)

input = args[1]
outfile = args[2]

dat = read.table(input, header=F, sep=",")
dat=as.numeric(dat[1,])
dat_sum = sum(dat)

dat_freq = dat / dat_sum * 100
dat_dt = data.frame(i=1:length(dat_freq), freq=dat_freq)

m = ggplot(dat_dt, aes(x=i, y=freq)) + theme(axis.text.x = element_text(angle = 90, hjust = 1))
m = m + geom_histogram(stat="identity", colour = "black", fill = "darkgrey", alpha=0.8) + scale_x_continuous(breaks=1:length(dat_freq), labels=1:length(dat_freq))
m = m + annotate("segment", x = 0.5, y = -0.3, xend=26.5, yend=-0.3, colour="darkgreen", size=1) + annotate("text", x = 13, y = -0.2, label="FR1")
m = m + annotate("segment", x = 26.5, y = -0.4, xend=38.5, yend=-0.4, colour="darkblue", size=1) + annotate("text", x = 32.5, y = -0.3, label="CDR1")
m = m + annotate("segment", x = 38.5, y = -0.3, xend=55.5, yend=-0.3, colour="darkgreen", size=1) + annotate("text", x = 47, y = -0.2, label="FR2")
m = m + annotate("segment", x = 55.5, y = -0.4, xend=65.5, yend=-0.4, colour="darkblue", size=1) + annotate("text", x = 60.5, y = -0.3, label="CDR2")
m = m + annotate("segment", x = 65.5, y = -0.3, xend=104.5, yend=-0.3, colour="darkgreen", size=1) + annotate("text", x = 85, y = -0.2, label="FR3")
write.table(dat_dt, paste(dirname(outfile), "/aa_histogram.txt", sep=""), sep="\t",quote=F,row.names=F,col.names=T)

png(filename=outfile, width=1280, height=720)
print(m)
dev.off()
