from __future__ import division
from collections import defaultdict
import re
import argparse

parser = argparse.ArgumentParser()
parser.add_argument("--input",
					help="The '7_V-REGION-mutation-and-AA-change-table' and '10_V-REGION-mutation-hotspots' merged together, with an added 'best_match' annotation")
parser.add_argument("--genes", help="The genes available in the 'best_match' column")
parser.add_argument("--includefr1", help="Should the mutation/nucleotides in the FR1 region be included?")
parser.add_argument("--output", help="Output file")

args = parser.parse_args()

infile = args.input
genes = str(args.genes).split(",")
print "includefr1 =", args.includefr1
include_fr1 = True if args.includefr1 == "yes" else False
outfile = args.output

genedic = dict()

mutationdic = dict()
mutationMatcher = re.compile("^(.)(\d+).(.),?(.)?(\d+)?.?(.)?(.?.?.?.?.?)?")
linecount = 0

IDIndex = 0
best_matchIndex = 0
fr1Index = 0
cdr1Index = 0
fr2Index = 0
cdr2Index = 0
fr3Index = 0
first = True
IDlist = []
mutationList = []
mutationListByID = {}
cdr1LengthDic = {}
cdr2LengthDic = {}

with open(infile, 'r') as i:
	for line in i:
		if first:
			linesplt = line.split("\t")
			IDIndex = linesplt.index("Sequence.ID")
			best_matchIndex = linesplt.index("best_match")
			fr1Index = linesplt.index("FR1.IMGT")
			cdr1Index = linesplt.index("CDR1.IMGT")
			fr2Index = linesplt.index("FR2.IMGT")
			cdr2Index = linesplt.index("CDR2.IMGT")
			fr3Index = linesplt.index("FR3.IMGT")
			cdr1LengthIndex = linesplt.index("CDR1.IMGT.Nb.of.nucleotides")
			cdr2LengthIndex = linesplt.index("CDR2.IMGT.Nb.of.nucleotides")
			first = False
			continue
		linecount += 1
		linesplt = line.split("\t")
		ID = linesplt[IDIndex]
		genedic[ID] = linesplt[best_matchIndex]
		print line
		try:
			mutationdic[ID + "_FR1"] = [mutationMatcher.match(x).groups() for x in linesplt[fr1Index].split("|") if x] if include_fr1 else []
			mutationdic[ID + "_CDR1"] = [mutationMatcher.match(x).groups() for x in linesplt[cdr1Index].split("|") if x]
			mutationdic[ID + "_FR2"] = [mutationMatcher.match(x).groups() for x in linesplt[fr2Index].split("|") if x]
			mutationdic[ID + "_CDR2"] = [mutationMatcher.match(x).groups() for x in linesplt[cdr2Index].split("|") if x]
			mutationdic[ID + "_FR2-CDR2"] = mutationdic[ID + "_FR2"] + mutationdic[ID + "_CDR2"]
			mutationdic[ID + "_FR3"] = [mutationMatcher.match(x).groups() for x in linesplt[fr3Index].split("|") if x]
		except:
			print linesplt
			print linecount
		mutationList += mutationdic[ID + "_FR1"] + mutationdic[ID + "_CDR1"] + mutationdic[ID + "_FR2"] + mutationdic[ID + "_CDR2"] + mutationdic[ID + "_FR3"]
		mutationListByID[ID] = mutationdic[ID + "_FR1"] + mutationdic[ID + "_CDR1"] + mutationdic[ID + "_FR2"] + mutationdic[ID + "_CDR2"] + mutationdic[ID + "_FR3"]

		cdr1Length = linesplt[cdr1LengthIndex]
		cdr2Length = linesplt[cdr2LengthIndex]

		cdr1LengthDic[ID] = int(cdr1Length) / 3
		cdr2LengthDic[ID] = int(cdr2Length) / 3

		IDlist += [ID]

AALength = (int(max(mutationList, key=lambda i: int(i[4]) if i[4] else 0)[4]) + 1)  # [4] is the position of the AA mutation, None if silent

AA_mutation = [0] * AALength
AA_mutation_empty = AA_mutation[:]

aa_mutations_by_id_file = outfile[:outfile.rindex("/")] + "/aa_id_mutations.txt"
with open(aa_mutations_by_id_file, 'w') as o:
	for ID in mutationListByID.keys():
		AA_mutation_for_ID = AA_mutation_empty[:]
		for mutation in mutationListByID[ID]:
			if mutation[4]:
				AA_mutation[int(mutation[4])] += 1
				AA_mutation_for_ID[int(mutation[4])] += 1
		o.write(ID + "\t" + "\t".join([str(x) for x in AA_mutation_for_ID[1:]]) + "\n")



#absent AA stuff
absentAACDR1Dic = defaultdict(list)
absentAACDR1Dic[5] = range(29,36)
absentAACDR1Dic[6] = range(29,35)
absentAACDR1Dic[7] = range(30,35)
absentAACDR1Dic[8] = range(30,34)
absentAACDR1Dic[9] = range(31,34)
absentAACDR1Dic[10] = range(31,33)
absentAACDR1Dic[11] = [32]

absentAACDR2Dic = defaultdict(list)
absentAACDR2Dic[0] = range(55,65)
absentAACDR2Dic[1] = range(56,65)
absentAACDR2Dic[2] = range(56,64)
absentAACDR2Dic[3] = range(57,64)
absentAACDR2Dic[4] = range(57,63)
absentAACDR2Dic[5] = range(58,63)
absentAACDR2Dic[6] = range(58,62)
absentAACDR2Dic[7] = range(59,62)
absentAACDR2Dic[8] = range(59,61)
absentAACDR2Dic[9] = [60]

absentAA = [len(IDlist)] * (AALength-1)
for k, cdr1Length in cdr1LengthDic.iteritems():
	for c in absentAACDR1Dic[cdr1Length]:
		absentAA[c] -= 1

for k, cdr2Length in cdr2LengthDic.iteritems():
	for c in absentAACDR2Dic[cdr2Length]:
		absentAA[c] -= 1


aa_mutations_by_id_file = outfile[:outfile.rindex("/")] + "/absent_aa_id.txt"
with open(aa_mutations_by_id_file, 'w') as o:
	o.write("ID\tcdr1length\tcdr2length\t" + "\t".join([str(x) for x in range(1,AALength-1)]) + "\n")
	for ID in IDlist:
		absentAAbyID = [1] * (AALength-1)
		cdr1Length = cdr1LengthDic[ID]
		for c in absentAACDR1Dic[cdr1Length]:
			absentAAbyID[c] -= 1

		cdr2Length = cdr2LengthDic[ID]
		for c in absentAACDR2Dic[cdr2Length]:
			absentAAbyID[c] -= 1
		o.write(ID + "\t" + str(cdr1Length) + "\t" + str(cdr2Length) + "\t" + "\t".join([str(x) for x in absentAAbyID]) + "\n")



aa_mutations_file = outfile[:outfile.rindex("/")] + "/aa_mutations.txt"
with open(aa_mutations_file, 'w') as o:
	o.write("row.name\t" + "\t".join([str(x) for x in range(1, AALength-1)]) + "\n")
	o.write("mutations.at.position\t" + "\t".join([str(x) for x in AA_mutation[1:]]) + "\n")
	o.write("AA.at.position\t" + "\t".join([str(x) for x in absentAA]) + "\n")

if linecount == 0:
	print "No data, exiting"
	with open(outfile, 'w') as o:
		o.write("RGYW (%)," + ("0,0,0\n" * len(genes)))
		o.write("WRCY (%)," + ("0,0,0\n" * len(genes)))
		o.write("WA (%)," + ("0,0,0\n" * len(genes)))
		o.write("TW (%)," + ("0,0,0\n" * len(genes)))
	import sys

	sys.exit()

hotspotMatcher = re.compile("[actg]+,(\d+)-(\d+)\((.*)\)")
RGYWCount = {g: 0 for g in genes}
WRCYCount = {g: 0 for g in genes}
WACount = {g: 0 for g in genes}
TWCount = {g: 0 for g in genes}

IDIndex = 0
ataIndex = 0
tatIndex = 0
aggctatIndex = 0
atagcctIndex = 0
first = True
with open(infile, 'r') as i:
	for line in i:
		if first:
			linesplt = line.split("\t")
			ataIndex = linesplt.index("X.a.t.a")
			tatIndex = linesplt.index("t.a.t.")
			aggctatIndex = linesplt.index("X.a.g.g.c.t..a.t.")
			atagcctIndex = linesplt.index("X.a.t..a.g.c.c.t.")
			first = False
			continue
		linesplt = line.split("\t")
		gene = linesplt[best_matchIndex]
		ID = linesplt[IDIndex]
		RGYW = [(int(x), int(y), z) for (x, y, z) in
				[hotspotMatcher.match(x).groups() for x in linesplt[aggctatIndex].split("|") if x]]
		WRCY = [(int(x), int(y), z) for (x, y, z) in
				[hotspotMatcher.match(x).groups() for x in linesplt[atagcctIndex].split("|") if x]]
		WA = [(int(x), int(y), z) for (x, y, z) in
			  [hotspotMatcher.match(x).groups() for x in linesplt[ataIndex].split("|") if x]]
		TW = [(int(x), int(y), z) for (x, y, z) in
			  [hotspotMatcher.match(x).groups() for x in linesplt[tatIndex].split("|") if x]]
		RGYWCount[ID], WRCYCount[ID], WACount[ID], TWCount[ID] = 0, 0, 0, 0

		mutationList = (mutationdic[ID + "_FR1"] if include_fr1 else []) + mutationdic[ID + "_CDR1"] + mutationdic[
			ID + "_FR2"] + mutationdic[ID + "_CDR2"] + mutationdic[ID + "_FR3"]
		for mutation in mutationList:
			frm, where, to, AAfrm, AAwhere, AAto, junk = mutation
			mutation_in_RGYW = any([(start <= int(where) <= end) for (start, end, region) in RGYW])
			mutation_in_WRCY = any([(start <= int(where) <= end) for (start, end, region) in WRCY])
			mutation_in_WA = any([(start <= int(where) <= end) for (start, end, region) in WA])
			mutation_in_TW = any([(start <= int(where) <= end) for (start, end, region) in TW])

			in_how_many_motifs = sum([mutation_in_RGYW, mutation_in_WRCY, mutation_in_WA, mutation_in_TW])

			if in_how_many_motifs > 0:
				RGYWCount[ID] += (1.0 * int(mutation_in_RGYW)) / in_how_many_motifs
				WRCYCount[ID] += (1.0 * int(mutation_in_WRCY)) / in_how_many_motifs
				WACount[ID] += (1.0 * int(mutation_in_WA)) / in_how_many_motifs
				TWCount[ID] += (1.0 * int(mutation_in_TW)) / in_how_many_motifs


def mean(lst):
	return (float(sum(lst)) / len(lst)) if len(lst) > 0 else 0.0


def median(lst):
	lst = sorted(lst)
	l = len(lst)
	if l == 0:
		return 0
	if l == 1:
		return lst[0]
		
	l = int(l / 2)
	
	if len(lst) % 2 == 0:
		print "list length is", l
		return float(lst[l] + lst[(l - 1)]) / 2.0
	else:
		return lst[l]

funcs = {"mean": mean, "median": median, "sum": sum}

directory = outfile[:outfile.rfind("/") + 1]
value = 0
valuedic = dict()

for fname in funcs.keys():
	for gene in genes:
		with open(directory + gene + "_" + fname + "_value.txt", 'r') as v:
			valuedic[gene + "_" + fname] = float(v.readlines()[0].rstrip())
	with open(directory + "all_" + fname + "_value.txt", 'r') as v:
		valuedic["total_" + fname] = float(v.readlines()[0].rstrip())
	
print valuedic
	
def get_xyz(lst, gene, f, fname):
	x = int(round(f(lst)))
	y = valuedic[gene + "_" + fname]
	z = str(round(x / float(valuedic[gene + "_" + fname]) * 100, 1)) if valuedic[gene + "_" + fname] != 0 else "0"
	return (str(x), str(y), z)

dic = {"RGYW": RGYWCount, "WRCY": WRCYCount, "WA": WACount, "TW": TWCount}
arr = ["RGYW", "WRCY", "WA", "TW"]

for fname in funcs.keys():
	func = funcs[fname]
	foutfile = outfile[:outfile.rindex("/")] + "/hotspot_analysis_" + fname + ".txt"
	with open(foutfile, 'w') as o:
		for typ in arr:
			o.write(typ + " (%)")
			curr = dic[typ]
			for gene in genes:
				geneMatcher = re.compile(".*" + gene + ".*")
				if valuedic[gene + "_" + fname] is 0:
					o.write(",0,0,0")
				else:
					x, y, z = get_xyz([curr[x] for x in [y for y, z in genedic.iteritems() if geneMatcher.match(z)]], gene, func, fname)
					o.write("," + x + "," + y + "," + z)
			# for total
			x, y, z = get_xyz([y for x, y in curr.iteritems()], "total", func, fname)
			o.write("," + x + "," + y + "," + z + "\n")


# for testing
seq_motif_file = outfile[:outfile.rindex("/")] + "/motif_per_seq.txt"
with open(seq_motif_file, 'w') as o:
	o.write("ID\tRGYWC\tWRCY\tWA\tTW\n")
	for ID in IDlist:
		o.write(ID + "\t" + str(round(RGYWCount[ID], 2)) + "\t" + str(round(WRCYCount[ID], 2)) + "\t" + str(round(WACount[ID], 2)) + "\t" + str(round(TWCount[ID], 2)) + "\n")
