#!/bin/bash
dir="$(cd "$(dirname "$0")" && pwd)"
mkdir $PWD/files


#!/bin/bash
f=$(file $1)
zip7Type="7-zip archive"
tarType="tar archive"
bzip2Type="bzip2 compressed"
gzipType="gzip compressed"
zipType="Zip archive"
rarType="RAR archive"

if [[ "$f" == *"$zip7Type"* ]]; then
	echo "7-zip"
	echo "Trying: 7za e $1 -o$PWD/files/"
	7za e $1 -o$PWD/files/
fi

if [[ "$f" == *"$tarType"* ]]
then
	echo "tar archive"
	echo "Trying: tar xvf $1 -C $PWD/files/"
	tar xvf $1 -C $PWD/files/
fi

if [[ "$f" == *"$bzip2Type"* ]]
then
	echo "bzip2 compressed data"
	echo "Trying: tar jxf $1 -C $PWD/files/"
	tar jxf $1 -C $PWD/files/
fi

if [[ "$f" == *"$gzipType"* ]]
then
	echo "gzip compressed data"
	echo "Trying: tar xvzf $1 -C $PWD/files/"
	tar xvzf $1 -C $PWD/files/
fi

if [[ "$f" == *"$zipType"* ]]
then
	echo "Zip archive"
	echo "Trying: unzip $1 -d $PWD/files/"
	unzip $1 -d $PWD/files/
fi

if [[ "$f" == *"$rarType"* ]]
then
	echo "RAR archive"
	echo "Trying: unrar e $1 $PWD/files/"
	unrar e $1 $PWD/files/
fi
find $PWD/files/ -type f |  grep -v "1_Summary_\|5_AA-sequences_\|6_Junction_" | xargs rm -f
python $dir/imgtconvert.py --input $PWD/files --output $2

