import pandas as pd
import re
import argparse
import os

def stop_err( msg, ret=1 ):
    sys.stderr.write( msg )
    sys.exit( ret )

#docs.python.org/dev/library/argparse.html
parser = argparse.ArgumentParser()
parser.add_argument("--input", help="Input folder with files")
parser.add_argument("--output", help="Output file")

args = parser.parse_args()

old_summary_columns = [u'Sequence ID', u'JUNCTION frame', u'V-GENE and allele', u'D-GENE and allele', u'J-GENE and allele', u'CDR1-IMGT length', u'CDR2-IMGT length', u'CDR3-IMGT length', u'Orientation']
old_sequence_columns = [u'CDR1-IMGT', u'CDR2-IMGT', u'CDR3-IMGT']
old_junction_columns = [u'JUNCTION']

added_summary_columns = [u'Functionality', u'V-REGION identity %', u'V-REGION identity nt', u'D-REGION reading frame', u'AA JUNCTION', u'Functionality comment', u'Sequence']
added_sequence_columns = [u'FR1-IMGT', u'FR2-IMGT', u'FR3-IMGT', u'CDR3-IMGT', u'JUNCTION', u'J-REGION', u'FR4-IMGT']
added_junction_columns = [u"P3'V-nt nb", u'N1-REGION-nt nb', u"P5'D-nt nb", u"P3'D-nt nb", u'N2-REGION-nt nb', u"P5'J-nt nb", u"3'V-REGION trimmed-nt nb", u"5'D-REGION trimmed-nt nb", u"3'D-REGION trimmed-nt nb", u"5'J-REGION trimmed-nt nb"]

inputFolder = args.input

dirContents = os.listdir(inputFolder)
if len(dirContents) == 1:
    inputFolder = os.path.join(inputFolder, dirContents[0])
    if os.path.isdir(inputFolder):
        print "is dir"
        dirContents = os.listdir(inputFolder)
files = sorted([os.path.join(inputFolder, f) for f in dirContents])

if len(files) % 3 is not 0:
    stop_err("Files in zip not a multiple of 3, it should contain the all the 1_, 5_ and 6_ files for a sample")
    import sys
    sys.exit()

triplets = []
step = len(files) / 3
for i in range(0, step):
    triplets.append((files[i], files[i + step], files[i + step + step]))

outFile = args.output

fSummary = pd.read_csv(triplets[0][0], sep="\t")
fSequence = pd.read_csv(triplets[0][1], sep="\t")
fJunction = pd.read_csv(triplets[0][2], sep="\t")
tmp = fSummary[["Sequence ID", "JUNCTION frame", "V-GENE and allele", "D-GENE and allele", "J-GENE and allele"]]

tmp["CDR1 Seq"] = fSequence["CDR1-IMGT"]
tmp["CDR1 Length"] = fSummary["CDR1-IMGT length"]

tmp["CDR2 Seq"] = fSequence["CDR2-IMGT"]
tmp["CDR2 Length"] = fSummary["CDR2-IMGT length"]

tmp["CDR3 Seq"] = fSequence["CDR3-IMGT"]
tmp["CDR3 Length"] = fSummary["CDR3-IMGT length"]

tmp["CDR3 Seq DNA"] = fJunction["JUNCTION"]
tmp["CDR3 Length DNA"] = '1'
tmp["Strand"] = fSummary["Orientation"]
tmp["CDR3 Found How"] = 'a'

for col in added_summary_columns:
    tmp[col] = fSummary[col]

for col in added_sequence_columns:
    tmp[col] = fSequence[col]

for col in added_junction_columns:
    tmp[col] = fJunction[col]

outFrame = tmp

for triple in triplets[1:]:
    fSummary = pd.read_csv(triple[0], sep="\t")
    fSequence = pd.read_csv(triple[1], sep="\t")
    fJunction = pd.read_csv(triple[2], sep="\t")

    tmp = fSummary[["Sequence ID", "JUNCTION frame", "V-GENE and allele", "D-GENE and allele", "J-GENE and allele"]]

    tmp["CDR1 Seq"] = fSequence["CDR1-IMGT"]
    tmp["CDR1 Length"] = fSummary["CDR1-IMGT length"]

    tmp["CDR2 Seq"] = fSequence["CDR2-IMGT"]
    tmp["CDR2 Length"] = fSummary["CDR2-IMGT length"]

    tmp["CDR3 Seq"] = fSequence["CDR3-IMGT"]
    tmp["CDR3 Length"] = fSummary["CDR3-IMGT length"]

    tmp["CDR3 Seq DNA"] = fJunction["JUNCTION"]
    tmp["CDR3 Length DNA"] = '1'
    tmp["Strand"] = fSummary["Orientation"]
    tmp["CDR3 Found How"] = 'a'

    for col in added_summary_columns:
        tmp[col] = fSummary[col]

    for col in added_sequence_columns:
        tmp[col] = fSequence[col]

    for col in added_junction_columns:
        tmp[col] = fJunction[col]

    outFrame = outFrame.append(tmp)

outFrame.columns = [u'ID', u'VDJ Frame', u'Top V Gene', u'Top D Gene', u'Top J Gene', u'CDR1 Seq', u'CDR1 Length', u'CDR2 Seq', u'CDR2 Length', u'CDR3 Seq', u'CDR3 Length', u'CDR3 Seq DNA', u'CDR3 Length DNA', u'Strand', u'CDR3 Found How', u'Functionality', 'V-REGION identity %', 'V-REGION identity nt', 'D-REGION reading frame', 'AA JUNCTION', 'Functionality comment', 'Sequence', 'FR1-IMGT', 'FR2-IMGT', 'FR3-IMGT', 'CDR3-IMGT', 'JUNCTION', 'J-REGION', 'FR4-IMGT', 'P3V-nt nb', 'N1-REGION-nt nb', 'P5D-nt nb', 'P3D-nt nb', 'N2-REGION-nt nb', 'P5J-nt nb', '3V-REGION trimmed-nt nb', '5D-REGION trimmed-nt nb', '3D-REGION trimmed-nt nb', '5J-REGION trimmed-nt nb']

vPattern = re.compile(r"IGHV[1-9]-[0-9ab]+-?[1-9]?")
dPattern = re.compile(r"IGHD[1-9]-[0-9ab]+")
jPattern = re.compile(r"IGHJ[1-9]")

def filterGenes(s, pattern):
    if type(s) is not str:
        return "NA"
    res = pattern.search(s)
    if res:
        return res.group(0)
    return "NA"


outFrame["Top V Gene"] = outFrame["Top V Gene"].apply(lambda x: filterGenes(x, vPattern))
outFrame["Top D Gene"] = outFrame["Top D Gene"].apply(lambda x: filterGenes(x, dPattern))
outFrame["Top J Gene"] = outFrame["Top J Gene"].apply(lambda x: filterGenes(x, jPattern))



tmp = outFrame["VDJ Frame"]
tmp = tmp.replace("in-frame", "In-frame")
tmp = tmp.replace("null", "Out-of-frame")
tmp = tmp.replace("out-of-frame", "Out-of-frame")
outFrame["VDJ Frame"] = tmp
outFrame["CDR3 Length DNA"] = outFrame["CDR3 Seq DNA"].map(str).map(len)
safeLength = lambda x: len(x) if type(x) == str else 0
outFrame = outFrame[(outFrame["CDR3 Seq DNA"].map(safeLength) > 0) & (outFrame["Top V Gene"] != "NA") & (outFrame["Top D Gene"] != "NA") & (outFrame["Top J Gene"] != "NA")] #filter out weird rows?
outFrame.to_csv(outFile, sep="\t", index=False, index_label="index")