args <- commandArgs(trailingOnly = TRUE)

inFile = args[1]
outDir = args[2]
logfile = args[3]
min_freq = as.numeric(args[4])
min_cells = as.numeric(args[5])

cat("<html><table><tr><td>Starting analysis</td></tr>", file=logfile, append=F)

library(ggplot2)
library(reshape2)
library(data.table)
library(grid)
library(parallel)
#require(xtable)
cat("<tr><td>Reading input</td></tr>", file=logfile, append=T)
dat = read.csv(inFile, sep="\t")
#dat = data.frame(fread(inFile)) #faster but with a dep
setwd(outDir)
cat("<tr><td>Selecting first V/J Genes</td></tr>", file=logfile, append=T)
dat$V_Segment_Major_Gene = as.factor(as.character(lapply(strsplit(as.character(dat$V_Segment_Major_Gene), "; "), "[[", 1)))
dat$J_Segment_Major_Gene = as.factor(as.character(lapply(strsplit(as.character(dat$J_Segment_Major_Gene), "; "), "[[", 1)))

cat("<tr><td>Calculating Frequency</td></tr>", file=logfile, append=T)
dat$Frequency = ((10^dat$Log10_Frequency)*100)

dat = dat[dat$Frequency >= min_freq,]

cat("<tr><td>Normalizing cell count to 1.000.000</td></tr>", file=logfile, append=T)
dat$normalized_read_count = round(dat$Clone_Molecule_Count_From_Spikes / dat$Cell_Count * 1000000 / 2)
dat = dat[dat$normalized_read_count >= min_cells,]
dat$paste = paste(dat$Sample, dat$V_Segment_Major_Gene, dat$J_Segment_Major_Gene, dat$CDR3_Sense_Sequence)
cat("<tr><td>Removing duplicates</td></tr>", file=logfile, append=T)
dat = dat[!duplicated(dat$paste),]
patients = split(dat, dat$Patient, drop=T)
rm(dat)
patients = patients[1:5]
intervalReads = rev(c(0,10,25,50,100,1000,10000))
intervalFreq = rev(c(0,0.01,0.1,0.5,1,5))
V_Segments = c(".*", "IGHV", "IGHD", "IGKV", "IGKV", "IgKINTR", "TRGV", "TRDV", "TRDD" , "TRBV")
J_Segments = c(".*", ".*", ".*", "IGKJ", "KDE", ".*", ".*", ".*", ".*", ".*")
Titles = c("Total", "IGH-Vh-Jh", "IGH-Dh-Jh", "Vk-Jk", "Vk-Kde" , "Intron-Kde", "TCRG", "TCRD-Vd-Dd", "TCRD-Dd-Dd", "TCRB-Vb-Jb")
Titles = factor(Titles, levels=Titles)
TitlesOrder = data.frame("Title"=Titles, "TitlesOrder"=1:length(Titles))

patientCountOnColumn <- function(x, product, interval, on, appendtxt=F){
  x$Sample = factor(x$Sample, levels=unique(x$Sample))
  onShort = "reads"
  if(on == "Frequency"){
    onShort = "freq"
  }
  splt = split(x, x$Sample, drop=T)
  type="pair"
  if(length(splt) == 1){
    print(paste(paste(x[1,which(colnames(x) == "Patient")]), "has one sample"))
    splt[[2]] = data.frame("Patient" = character(0), "Receptor" = character(0), "Sample" = character(0), "Cell_Count" = numeric(0), "Clone_Molecule_Count_From_Spikes" = numeric(0), "Log10_Frequency" = numeric(0), "Total_Read_Count" = numeric(0), "dsMol_per_1e6_cells" = numeric(0), "J_Segment_Major_Gene" = character(0), "V_Segment_Major_Gene" = character(0), "Clone_Sequence" = character(0), "CDR3_Sense_Sequence" = character(0), "Related_to_leukemia_clone" = logical(0), "Frequency"= numeric(0), "normalized_read_count" = numeric(0), "paste" = character(0))
    type="single"
  }
  patient1 = splt[[1]]
  patient2 = splt[[2]]
  
  threshholdIndex = which(colnames(product) == "interval")
  V_SegmentIndex = which(colnames(product) == "V_Segments")
  J_SegmentIndex = which(colnames(product) == "J_Segments")
  titleIndex = which(colnames(product) == "Titles")
  sampleIndex = which(colnames(x) == "Sample")
  patientIndex = which(colnames(x) == "Patient")
  oneSample = paste(patient1[1,sampleIndex], sep="")
  twoSample = paste(patient2[1,sampleIndex], sep="")
  patient = paste(x[1,patientIndex])

  switched = F
  if(length(grep(".*_Right$", twoSample)) == 1 || length(grep(".*_Dx_BM$", twoSample)) == 1 || length(grep(".*_Dx$", twoSample)) == 1 ){
    tmp = twoSample
    twoSample = oneSample
    oneSample = tmp
    tmp = patient1
    patient1 = patient2
    patient2 = tmp
    switched = T
  }
  if(appendtxt){
    cat(paste(patient, oneSample, twoSample, type, sep="\t"), file="patients.txt", append=T, sep="", fill=3)
  }
  cat(paste("<tr><td>", patient, "</td></tr>", sep=""), file=logfile, append=T)
  patientMerge = merge(patient1, patient2, by="Clone_Sequence")
  res1 = vector()
  res2 = vector()
  resBoth = vector()
  read1Count = vector()
  read2Count = vector()
  locussum1 = vector()
  locussum2 = vector()
  
  print(patient)
  #for(iter in 1){
  for(iter in 1:length(product[,1])){
    threshhold = product[iter,threshholdIndex]
    V_Segment = paste(".*", as.character(product[iter,V_SegmentIndex]), ".*", sep="")
    J_Segment = paste(".*", as.character(product[iter,J_SegmentIndex]), ".*", sep="")
    both = (grepl(V_Segment, patientMerge$V_Segment_Major_Gene.x) & grepl(J_Segment, patientMerge$J_Segment_Major_Gene.x) & patientMerge[,paste(on, ".x", sep="")] > threshhold & patientMerge[,paste(on, ".y", sep="")] > threshhold)
    one = (grepl(V_Segment, patient1$V_Segment_Major_Gene) & grepl(J_Segment, patient1$J_Segment_Major_Gene) & patient1[,on] > threshhold & !(patient1$Clone_Sequence %in% patientMerge[both,]$Clone_Sequence))
    two = (grepl(V_Segment, patient2$V_Segment_Major_Gene) & grepl(J_Segment, patient2$J_Segment_Major_Gene) & patient2[,on] > threshhold & !(patient2$Clone_Sequence %in% patientMerge[both,]$Clone_Sequence))
    read1Count = append(read1Count, sum(patient1[one,]$normalized_read_count) + sum(patientMerge[both,]$normalized_read_count.x))
    read2Count = append(read2Count, sum(patient2[two,]$normalized_read_count) + sum(patientMerge[both,]$normalized_read_count.y))
    res1 = append(res1, sum(one))
    res2 = append(res2, sum(two))
    resBoth = append(resBoth, sum(both))
    locussum1 = append(locussum1, sum(patient1[(grepl(V_Segment, patient1$V_Segment_Major_Gene) & grepl(J_Segment, patient1$J_Segment_Major_Gene)),]$normalized_read_count))
    locussum2 = append(locussum2, sum(patient2[(grepl(V_Segment, patient2$V_Segment_Major_Gene) & grepl(J_Segment, patient2$J_Segment_Major_Gene)),]$normalized_read_count))
    #threshhold = 0
    if(threshhold != 0){
      if(sum(one) > 0){
        dfOne = patient1[one,c("V_Segment_Major_Gene", "J_Segment_Major_Gene", "normalized_read_count", "Frequency", "Clone_Sequence", "Related_to_leukemia_clone")]
        colnames(dfOne) = c("Proximal segment", "Distal segment", "normalized_read_count", "Frequency", "Sequence", "Related_to_leukemia_clone")
        filenameOne = paste(oneSample, "_", product[iter, titleIndex], "_", threshhold, sep="")
        write.table(dfOne, file=paste(filenameOne, ".txt", sep=""), quote=F, sep="\t", dec=",", row.names=F, col.names=T)
      }
      if(sum(two) > 0){
        dfTwo = patient2[two,c("V_Segment_Major_Gene", "J_Segment_Major_Gene", "normalized_read_count", "Frequency", "Clone_Sequence", "Related_to_leukemia_clone")]
        colnames(dfTwo) = c("Proximal segment", "Distal segment", "normalized_read_count", "Frequency", "Sequence", "Related_to_leukemia_clone")
        filenameTwo = paste(twoSample, "_", product[iter, titleIndex], "_", threshhold, sep="")
        write.table(dfTwo, file=paste(filenameTwo, ".txt", sep=""), quote=F, sep="\t", dec=",", row.names=F, col.names=T)
      }
    }
    if(sum(both) > 0){
      dfBoth = patientMerge[both,c("V_Segment_Major_Gene.x", "J_Segment_Major_Gene.x", "normalized_read_count.x", "Frequency.x", "Related_to_leukemia_clone.x", "Clone_Sequence", "V_Segment_Major_Gene.y", "J_Segment_Major_Gene.y", "normalized_read_count.y", "Frequency.y", "Related_to_leukemia_clone.y")]
      colnames(dfBoth) = c(paste("Proximal segment", oneSample), paste("Distal segment", oneSample), paste("Normalized_Read_Count", oneSample), paste("Frequency", oneSample), paste("Related_to_leukemia_clone", oneSample),"Sequence", paste("Proximal segment", twoSample), paste("Distal segment", twoSample), paste("Normalized_Read_Count", twoSample), paste("Frequency", twoSample), paste("Related_to_leukemia_clone", twoSample))
      filenameBoth = paste(oneSample, "_", twoSample, "_", product[iter, titleIndex], "_", threshhold, sep="")
      write.table(dfBoth, file=paste(filenameBoth, ".txt", sep=""), quote=F, sep="\t", dec=",", row.names=F, col.names=T)
    }
  }
  patientResult = data.frame("Locus"=product$Titles, "J_Segment"=product$J_Segments, "V_Segment"=product$V_Segments, "cut_off_value"=paste(">", product$interval, sep=""), "Both"=resBoth, "tmp1"=res1, "read_count1" = round(read1Count), "tmp2"=res2, "read_count2"= round(read2Count), "Sum"=res1 + res2 + resBoth, "percentage" = round((resBoth/(res1 + res2 + resBoth)) * 100, digits=2), "Locus_sum1"=locussum1, "Locus_sum2"=locussum2)
  if(sum(is.na(patientResult$percentage)) > 0){
    patientResult[is.na(patientResult$percentage),]$percentage = 0
  }
  colnames(patientResult)[6] = oneSample
  colnames(patientResult)[8] = twoSample
  colnamesBak = colnames(patientResult)
  colnames(patientResult) = c("Ig/TCR gene rearrangement type", "Distal Gene segment", "Proximal gene segment", "cut_off_value", paste("Number of sequences ", patient, "_Both", sep=""), paste("Number of sequences", oneSample, sep=""), paste("Normalized Read Count", oneSample), paste("Number of sequences", twoSample, sep=""), paste("Normalized Read Count", twoSample), paste("Sum number of sequences", patient), paste("Percentage of sequences ", patient, "_Both", sep=""), paste("Locus Sum", oneSample), paste("Locus Sum", twoSample))
  write.table(patientResult, file=paste(patient, "_", onShort, ".txt", sep=""), quote=F, sep="\t", dec=",", row.names=F, col.names=T)
  colnames(patientResult) = colnamesBak
  
  patientResult$Locus = factor(patientResult$Locus, Titles)
  patientResult$cut_off_value = factor(patientResult$cut_off_value, paste(">", interval, sep=""))
  
  plt = ggplot(patientResult[,c("Locus", "cut_off_value", "Both")])
  plt = plt + geom_bar( aes( x=factor(cut_off_value), y=Both), stat='identity', position="dodge", fill="#79c36a")
  plt = plt + facet_grid(.~Locus) + theme(axis.text.x = element_text(angle = 45, hjust = 1))
  plt = plt + geom_text(aes(ymax=max(Both), x=cut_off_value,y=Both,label=Both), angle=90, hjust=0)
  plt = plt + xlab("Reads per locus") + ylab("Count") + ggtitle("Number of clones in both")
  plt = plt + theme(plot.margin = unit(c(1,8.8,0.5,1.5), "lines"))
  png(paste(patient, "_", onShort, ".png", sep=""), width=1920, height=1080)
  print(plt)
  dev.off()
  #(t,r,b,l)
  plt = ggplot(patientResult[,c("Locus", "cut_off_value", "percentage")])
  plt = plt + geom_bar( aes( x=factor(cut_off_value), y=percentage), stat='identity', position="dodge", fill="#79c36a")
  plt = plt + facet_grid(.~Locus) + theme(axis.text.x = element_text(angle = 45, hjust = 1))
  plt = plt + geom_text(aes(ymax=max(percentage), x=cut_off_value,y=percentage,label=percentage), angle=90, hjust=0)
  plt = plt + xlab("Reads per locus") + ylab("Count") + ggtitle("% clones in both left and right")
  plt = plt + theme(plot.margin = unit(c(1,8.8,0.5,1.5), "lines"))
  png(paste(patient, "_percent_", onShort, ".png", sep=""), width=1920, height=1080)
  print(plt)
  dev.off()
  
  patientResult = melt(patientResult[,c('Locus','cut_off_value', oneSample, twoSample)] ,id.vars=1:2)
  patientResult$relativeValue = patientResult$value * 10
  patientResult[patientResult$relativeValue == 0,]$relativeValue = 1
  plt = ggplot(patientResult)
  plt = plt + geom_bar( aes( x=factor(cut_off_value), y=relativeValue, fill=variable), stat='identity', position="dodge")
  plt = plt + facet_grid(.~Locus) + theme(axis.text.x = element_text(angle = 45, hjust = 1))
  plt = plt + scale_y_continuous(trans="log", breaks=10^c(0:10), labels=c(0, 10^c(0:9)))
  plt = plt + geom_text(data=patientResult[patientResult$variable == oneSample,], aes(ymax=max(value), x=cut_off_value,y=relativeValue,label=value), angle=90, position=position_dodge(width=0.9), hjust=0, vjust=-0.2)
  plt = plt + geom_text(data=patientResult[patientResult$variable == twoSample,], aes(ymax=max(value), x=cut_off_value,y=relativeValue,label=value), angle=90, position=position_dodge(width=0.9), hjust=0, vjust=0.8)
  plt = plt + xlab("Reads per locus") + ylab("Count") + ggtitle(paste("Number of clones in only ", oneSample, " and only ", twoSample, sep=""))
  png(paste(patient, "_", onShort, "_both.png", sep=""), width=1920, height=1080)
  print(plt)
  dev.off()
}

cat("<tr><td>Starting Frequency analysis</td></tr>", file=logfile, append=T)

interval = intervalFreq
intervalOrder = data.frame("interval"=paste(">", interval, sep=""), "intervalOrder"=1:length(interval))
product = data.frame("Titles"=rep(Titles, each=length(interval)), "interval"=rep(interval, times=10), "V_Segments"=rep(V_Segments, each=length(interval)), "J_Segments"=rep(J_Segments, each=length(interval)))
#patientFrequencyCount(patient1)
#lapply(patients[c(5,6,10)], FUN=patientFrequencyCount)
#lapply(patients[c(5,6,7,8,13)], FUN=patientCountOnColumn, product = product, interval=interval, on="Frequency", appendtxt=T)
#lapply(patients[c(6,7,8)], FUN=patientCountOnColumn, product = product, interval=interval, on="Frequency", appendtxt=T)
#lapply(patients[c(6)], FUN=patientCountOnColumn, product = product, interval=interval, on="Frequency", appendtxt=T)
mclapply(patients, FUN=patientCountOnColumn, product = product, interval=interval, on="Frequency", appendtxt=T)

cat("<tr><td>Starting Cell Count analysis</td></tr>", file=logfile, append=T)

interval = intervalReads
intervalOrder = data.frame("interval"=paste(">", interval, sep=""), "intervalOrder"=1:length(interval))
product = data.frame("Titles"=rep(Titles, each=length(interval)), "interval"=rep(interval, times=10), "V_Segments"=rep(V_Segments, each=length(interval)), "J_Segments"=rep(J_Segments, each=length(interval)))
#patientResult = patientReadCount(patient1)
#lapply(patients[c(5,6,10)], FUN=patientReadCount)
#lapply(patients[c(5,6,7,8,13)], FUN=patientCountOnColumn, product = product, interval=interval, on="Clone_Molecule_Count_From_Spikes")
#lapply(patients[c(6)], FUN=patientCountOnColumn, product = product, interval=interval, on="Clone_Molecule_Count_From_Spikes")
mclapply(patients, FUN=patientCountOnColumn, product = product, interval=interval, on="Clone_Molecule_Count_From_Spikes")

cat("</table></html>", file=logfile, append=T)

