#!/bin/bash
dir="$(cd "$(dirname "$0")" && pwd)"

testID=$1
species=$2
substitutionModel=$3
mutabilityModel=$4
clonal=$5
fixIndels=$6
region=$7
inputs=$8
inputs=($inputs)
IDs=$9
IDs=($IDs)
ref=${10}
output=${11}
outID="result"

echo "testID = $testID"
echo "species = $species"
echo "substitutionModel = $substitutionModel"
echo "mutabilityModel = $mutabilityModel"
echo "clonal = $clonal"
echo "fixIndels = $fixIndels"
echo "region = $region"
echo "inputs = ${inputs[@]}"
echo "IDs = ${IDs[@]}"
echo "ref = $ref"
echo "output = $output"
echo "outID = $outID"

fasta="$PWD/baseline.fasta"


count=0
for current in ${inputs[@]}
do
	f=$(file $current)
	zipType="Zip archive"
	if [[ "$f" == *"$zipType"* ]]
	then
		id=${IDs[$count]}
		echo "id=$id"
		unzip $current -d $PWD/$id/ >> $PWD/unziplog.log
		filename="$PWD/gappednt_${id}.txt"
		cat $PWD/$id/*/2_* | cut -f2,4,7 > $filename
		python $dir/script_imgt.py --input $filename --ref $ref --output $fasta --id $id
	else
		python $dir/script_xlsx.py --input $current --ref $ref --output $fasta
	fi
	count=$((count+1))
done
workdir="$PWD"
cd $dir
Rscript --verbose $dir/Baseline_Main.r $testID $species $substitutionModel $mutabilityModel $clonal $fixIndels $region $fasta $workdir/ $outID 2>&1

echo "$workdir/${outID}.txt"

rows=`tail -n +2 $workdir/${outID}.txt | grep -n 'Group' | grep -Eoh '^[0-9]+' | tr '\n' ' '`
rows=($rows)
unset rows[${#rows[@]}-1]

cd $dir
Rscript --verbose $dir/comparePDFs.r $workdir/${outID}.RData $output ${rows[@]} 2>&1





