args = commandArgs(trailingOnly=TRUE)

library("amap")
library("labdsv")

data <- read.table("plink.raw",header=T)
rownames(data) <- data[,2]
distances <- Dist(data[,7:dim(data)[2]], method = "euclidean", nbproc = as.integer(args[2]))
pco_results <- pco(distances,k=10)
#Variance explained by first three PCOs
pco_results$eig[1]/sum(pco_results$eig[pco_results$eig>0])
#[1] 0.2565937
pco_results$eig[2]/sum(pco_results$eig[pco_results$eig>0])
#[1] 0.06878127
pco_results$eig[3]/sum(pco_results$eig[pco_results$eig>0])
#[1] 0.04340111
write.csv(pco_results$points,file=args[1])

