/*
 * Decompiled with CFR 0.152.
 */
package scri.commons.gui.matisse;

import java.awt.Dimension;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class HistoryComboBox
extends JComboBox<String>
implements PopupMenuListener {
    private LinkedList<String> history = new LinkedList();
    private int listSize = 10;
    private static int height = new JComboBox<E>().getPreferredSize().height;

    public HistoryComboBox() {
        this.setEditable(true);
        this.setPrototypeDisplayValue("");
        this.addPopupMenuListener(this);
    }

    public HistoryComboBox(String recentItems) {
        this();
        StringTokenizer st = new StringTokenizer(recentItems, "\t");
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            this.addItem(path);
            this.history.add(path);
        }
    }

    public void updateComboBox(String value) {
        if (value != null) {
            this.history.remove(value);
            this.history.addFirst(value);
        }
        while (this.history.size() > this.listSize) {
            this.history.removeLast();
        }
        this.removeAllItems();
        for (String entry : this.history) {
            this.addItem(entry);
        }
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(1, height);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(1, height);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(1, height);
    }

    public String getHistory() {
        this.updateComboBox(this.getText());
        String historyString = "";
        for (String entry : this.history) {
            historyString = historyString + entry + "\t";
        }
        return historyString;
    }

    public void setHistory(String newHistory) {
        String[] tokens;
        this.history.clear();
        this.removeAllItems();
        for (String path : tokens = newHistory.split("\t", -1)) {
            if (path.isEmpty() && this.history.size() > 0) continue;
            this.addItem(path);
            this.history.add(path);
        }
    }

    public int getListSize() {
        return this.listSize;
    }

    public void setListSize(int listSize) {
        this.listSize = listSize;
    }

    public String getText() {
        if (this.getSelectedItem() == null) {
            return "";
        }
        return this.getSelectedItem().toString();
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.updateComboBox(this.getText());
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        this.updateComboBox(this.getText());
    }
}

