/*
 * Decompiled with CFR 0.152.
 */
package scri.commons.gui;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Properties;

public abstract class XMLPreferences {
    private Properties p = new Properties();

    private void loadProperties(File file) throws Exception {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            this.p.loadFromXML(in);
            in.close();
            return;
        }
        catch (Throwable throwable) {
            in = new BufferedInputStream(new FileInputStream(file));
            this.p = new Properties();
            this.p.load(in);
            in.close();
            return;
        }
    }

    private void saveProperties(File file) throws Exception {
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(file));
            this.p.storeToXML(os, null);
            os.close();
            return;
        }
        catch (Throwable throwable) {
            os = new BufferedOutputStream(new FileOutputStream(file));
            this.p.store(os, null);
            os.close();
            return;
        }
    }

    public void loadPreferences(File file, Class obj) {
        try {
            this.loadProperties(file);
            for (Field field : obj.getFields()) {
                String[] value = null;
                if (field.getType() == Integer.TYPE) {
                    value = this.getInt(field.getName(), field.getInt(obj));
                } else if (field.getType() == Float.TYPE) {
                    value = Float.valueOf(this.getFloat(field.getName(), field.getFloat(obj)));
                } else if (field.getType() == Double.TYPE) {
                    value = this.getDouble(field.getName(), field.getDouble(obj));
                } else if (field.getType() == Boolean.TYPE) {
                    value = this.getBool(field.getName(), field.getBoolean(obj));
                } else if (field.getType() == String.class) {
                    value = this.getStr(field.getName(), (String)field.get(obj));
                } else if (field.getType() == Color.class) {
                    value = this.getColor(field.getName(), (Color)field.get(obj));
                } else if (field.getType() == String[].class) {
                    value = this.getStringArray(field.getName(), (String[])field.get(obj));
                }
                field.set(obj, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void savePreferences(File file, Class obj) {
        this.p = new Properties();
        try {
            for (Field field : obj.getFields()) {
                Object value = field.get(obj);
                if (field.getType() == String.class) {
                    if (value == null || ((String)value).length() <= 0) continue;
                    this.p.setProperty(field.getName(), "" + value);
                    continue;
                }
                if (field.getType() == Color.class) {
                    Color c = (Color)value;
                    this.p.setProperty(field.getName(), c.getRed() + "," + c.getGreen() + "," + c.getBlue());
                    continue;
                }
                if (field.getType() == String[].class) {
                    StringBuilder property = new StringBuilder();
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        if (Array.get(value, i) != null) {
                            property.append(Array.get(value, i) + "\t");
                            continue;
                        }
                        property.append(" \t");
                    }
                    this.p.setProperty(field.getName(), property.toString());
                    continue;
                }
                this.p.setProperty(field.getName(), "" + value);
            }
            this.saveProperties(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getInt(String name, int defaultValue) {
        try {
            return Integer.parseInt(this.p.getProperty(name));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private float getFloat(String name, float defaultValue) {
        try {
            return Float.parseFloat(this.p.getProperty(name));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private double getDouble(String name, double defaultValue) {
        try {
            return Double.parseDouble(this.p.getProperty(name));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private boolean getBool(String name, boolean defaultValue) {
        try {
            return this.p.getProperty(name).equalsIgnoreCase("true");
        }
        catch (NullPointerException e) {
            return defaultValue;
        }
    }

    private String getStr(String name, String defaultValue) {
        return this.p.getProperty(name) == null ? defaultValue : this.p.getProperty(name);
    }

    private Color getColor(String name, Color defaultValue) {
        try {
            String[] s = this.p.getProperty(name).split(",");
            return new Color(Integer.parseInt(s[0]), Integer.parseInt(s[1]), Integer.parseInt(s[2]));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private String[] getStringArray(String name, String[] defaultValue) {
        try {
            return this.p.getProperty(name).split("\t");
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

