/*
 * Decompiled with CFR 0.152.
 */
package scri.commons;

import java.util.ArrayList;
import scri.commons.IntervalNode;

public class IntervalTree<Type> {
    protected IntervalNode<Type> root;
    protected static byte RED = IntervalNode.RED;
    protected static byte BLACK = IntervalNode.BLACK;

    public void add(Type node, int low, int high) {
        this.intervalInsert(new IntervalNode<Type>(low, high, node));
    }

    public void intervalInsert(IntervalNode<Type> node) {
        this.insert(node);
        while (node != this.root && node.parent.colour == RED) {
            IntervalNode y;
            if (node.parent == node.parent.parent.left) {
                y = node.parent.parent.right;
                if (y != null && y.colour == RED) {
                    node.parent.colour = BLACK;
                    y.colour = BLACK;
                    node.parent.parent.colour = RED;
                    node = node.parent.parent;
                    continue;
                }
                if (node == node.parent.right) {
                    node = node.parent;
                    this.rotateLeft(node);
                }
                node.parent.colour = BLACK;
                node.parent.parent.colour = RED;
                this.rotateRight(node.parent.parent);
                continue;
            }
            y = node.parent.parent.left;
            if (y != null && y.colour == RED) {
                node.parent.colour = BLACK;
                y.colour = BLACK;
                node.parent.parent.colour = RED;
                node = node.parent.parent;
                continue;
            }
            if (node == node.parent.left) {
                node = node.parent;
                this.rotateRight(node);
            }
            node.parent.colour = BLACK;
            node.parent.parent.colour = RED;
            this.rotateLeft(node.parent.parent);
        }
        this.root.colour = BLACK;
    }

    protected void insert(IntervalNode<Type> node) {
        IntervalNode<Type> y = null;
        IntervalNode<Type> x = this.root;
        while (x != null) {
            y = x;
            if (node.max > y.max) {
                y.max = node.max;
            }
            if (node.compareTo(x) < 0) {
                x = x.left;
                continue;
            }
            x = x.right;
        }
        node.parent = y;
        if (y == null) {
            this.root = node;
        } else if (node.compareTo(y) < 0) {
            y.left = node;
        } else {
            y.right = node;
        }
    }

    protected void rotateLeft(IntervalNode<Type> x) {
        IntervalNode y = x.right;
        x.right = y.left;
        if (y.left != null) {
            y.left.parent = x;
        }
        y.parent = x.parent;
        if (x.parent == null) {
            this.root = y;
        } else if (x == x.parent.left) {
            x.parent.left = y;
        } else {
            x.parent.right = y;
        }
        y.left = x;
        x.parent = y;
        x.max = Math.max(Math.max(x.high, x.left != null ? x.left.max : 0), x.right != null ? x.right.max : 0);
    }

    protected void rotateRight(IntervalNode<Type> y) {
        IntervalNode<Type> x = y;
        y.left = x.right;
        if (x.right != null) {
            x.right.parent = y;
        }
        x.parent = y.parent;
        if (y.parent == null) {
            this.root = x;
        } else if (y == y.parent.right) {
            y.parent.right = x;
        } else {
            y.parent.left = y;
        }
        x.right = y;
        y.parent = x;
        y.max = Math.max(Math.max(y.high, y.left != null ? y.left.max : 0), y.right != null ? y.right.max : 0);
    }

    public ArrayList<Type> intervalSearch(int low, int high) {
        return this.intervalSearch(low, high, this.root, new ArrayList());
    }

    private ArrayList<Type> intervalSearch(int low, int high, IntervalNode<Type> node, ArrayList<Type> results) {
        if (node == null) {
            return results;
        }
        if (node.max < low) {
            return results;
        }
        if (node.left != null) {
            results = this.intervalSearch(low, high, node.left, results);
        }
        if (node.high >= low && node.low <= high) {
            results.add(node.data);
        }
        if (node.low > high) {
            return results;
        }
        if (node.right != null) {
            results = this.intervalSearch(low, high, node.right, results);
        }
        return results;
    }

    public void replace(int low, int high, Type data) {
        this.replaceNode(new IntervalNode<Type>(low, high, data));
    }

    private void replaceNode(IntervalNode<Type> node) {
        IntervalNode<Type> y = null;
        IntervalNode<Type> x = this.root;
        while (x != null) {
            y = x;
            if (node.max > y.max) {
                y.max = node.max;
            }
            if (node.compareTo(x) < 0) {
                x = x.left;
                continue;
            }
            if (node.compareTo(x) > 0) {
                x = x.right;
                continue;
            }
            node.parent = x.parent;
            node.left = x.left;
            node.right = x.right;
            node.max = x.max;
            x.left.parent = node;
            x.right.parent = node;
            x.parent = null;
            x.left = null;
            x.right = null;
            break;
        }
    }

    public ArrayList<Type> toArrayList() {
        return this.toArrayList(this.root, new ArrayList());
    }

    private ArrayList<Type> toArrayList(IntervalNode<Type> node, ArrayList<Type> arrayList) {
        if (node == null) {
            return arrayList;
        }
        arrayList = this.toArrayList(node.left, arrayList);
        arrayList.add(node.data);
        arrayList = this.toArrayList(node.right, arrayList);
        return arrayList;
    }

    private void verifyProperties() {
        this.rootIsBlack();
        this.leavesAreBlack(this.root);
        this.blackHeightsEqual(this.root);
    }

    private void rootIsBlack() {
        assert (this.root.colour == BLACK);
    }

    private void leavesAreBlack(IntervalNode<Type> n) {
        if (n == null) {
            return;
        }
        if (this.colourOf(n) == RED) {
            assert (this.colourOf(n.left) == BLACK);
            assert (this.colourOf(n.right) == BLACK);
            assert (this.colourOf(n.parent) == BLACK);
        }
        this.leavesAreBlack(n.left);
        this.leavesAreBlack(n.right);
    }

    private void blackHeightsEqual(IntervalNode<Type> root) {
        this.blackHeightsEqual(root, 0, -1);
    }

    private int blackHeightsEqual(IntervalNode<Type> n, int blackCount, int pathBlackCount) {
        if (this.colourOf(n) == BLACK) {
            ++blackCount;
        }
        if (n == null) {
            if (pathBlackCount == -1) {
                pathBlackCount = blackCount;
            } else assert (blackCount == pathBlackCount);
            return pathBlackCount;
        }
        pathBlackCount = this.blackHeightsEqual(n.left, blackCount, pathBlackCount);
        pathBlackCount = this.blackHeightsEqual(n.right, blackCount, pathBlackCount);
        return pathBlackCount;
    }

    private byte colourOf(IntervalNode<Type> p) {
        return p == null ? BLACK : p.colour;
    }
}

