/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.binning;

import java.util.ArrayList;
import jhi.flapjack.io.binning.IBinner;

class SplitBinner
implements IBinner {
    private Float min = Float.valueOf(0.0f);
    private Float max = Float.valueOf(1.0f);
    private int lBinCount;
    private int rBinCount;
    private float lBinSize;
    private float rBinSize;
    private float split;

    SplitBinner(int lBinCount, float split, int rBinCount) {
        this.lBinCount = lBinCount;
        this.rBinCount = rBinCount;
        this.split = split;
        this.lBinSize = (split - this.min.floatValue()) / (float)lBinCount;
        this.rBinSize = (this.max.floatValue() - split) / (float)rBinCount;
    }

    float getSplit() {
        return this.split;
    }

    @Override
    public int bin(float value) {
        if (value <= this.split) {
            int bin = (int)((value - this.min.floatValue()) / this.lBinSize);
            if (bin == this.lBinCount) {
                bin = this.lBinCount - 1;
            }
            return bin;
        }
        int bin = (int)((value - this.split) / this.rBinSize);
        if (bin == this.rBinCount) {
            bin = this.rBinCount - 1;
        }
        return bin += this.lBinCount;
    }

    @Override
    public ArrayList<float[]> getBinSummary() {
        float f2;
        float f1;
        int i;
        ArrayList<float[]> list = new ArrayList<float[]>();
        for (i = 0; i < this.lBinCount; ++i) {
            f1 = (float)i * this.lBinSize;
            f2 = (float)i * this.lBinSize + this.lBinSize;
            list.add(new float[]{f1, f2});
        }
        for (i = 0; i < this.rBinCount; ++i) {
            f1 = this.split + (float)i * this.rBinSize;
            f2 = this.split + (float)i * this.rBinSize + this.rBinSize;
            list.add(new float[]{f1, f2});
        }
        return list;
    }
}

