/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.Trait;
import jhi.flapjack.data.TraitValue;
import jhi.flapjack.io.DataFormatException;
import scri.commons.gui.RB;
import scri.commons.gui.SimpleJob;
import scri.commons.io.ProgressInputStream;

public class TraitImporter
extends SimpleJob {
    private ProgressInputStream is;
    private File file;
    private DataSet dataSet;
    private ArrayList<Trait> traits = new ArrayList();
    private HashMap<String, ArrayList<TraitValue>> hashtable;
    private int traitsCount;
    private int traitsRead;

    public TraitImporter(File file, DataSet dataSet) {
        this.file = file;
        this.dataSet = dataSet;
        this.hashtable = new HashMap();
        this.maximum = 5555;
    }

    public void runJob(int index) throws IOException, DataFormatException {
        this.is = new ProgressInputStream((InputStream)new FileInputStream(this.file));
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)this.is, "UTF-8"));
        String str = in.readLine();
        while (str != null && str.startsWith("#")) {
            str = in.readLine();
        }
        String[] traitNames = str.split("\t");
        for (int i = 1; i < traitNames.length; ++i) {
            this.traits.add(new Trait(traitNames[i]));
        }
        int line = 2;
        while ((str = in.readLine()) != null && this.okToRun) {
            String[] tokens = str.split("\t", -1);
            if (line == 2 && str.length() > 0 && tokens[0].length() == 0) {
                for (int i = 1; i < tokens.length; ++i) {
                    this.traits.get(i - 1).setExperiment(tokens[i]);
                }
            } else if (str.length() != 0) {
                if (tokens.length != this.traits.size() + 1) {
                    throw new DataFormatException(RB.format((String)"io.DataFormatException.traitColumnError", (Object[])new Object[]{line}));
                }
                String lineName = tokens[0];
                ArrayList<TraitValue> values = new ArrayList<TraitValue>();
                for (int i = 1; i < tokens.length; ++i) {
                    Trait trait = this.traits.get(i - 1);
                    if (tokens[i].length() == 0) {
                        values.add(new TraitValue(trait));
                        continue;
                    }
                    try {
                        float value = trait.computeValue(tokens[i]);
                        values.add(new TraitValue(trait, value));
                        continue;
                    }
                    catch (Exception e) {
                        if (!e.getMessage().equals("NumericalReadError")) continue;
                        throw new DataFormatException(RB.format((String)"io.DataFormatException.traitNumCatError", (Object[])new Object[]{line, trait.getName()}));
                    }
                }
                this.hashtable.put(lineName, values);
            }
            ++line;
        }
        in.close();
        if (!this.okToRun) {
            return;
        }
        this.sortCategoricalValues();
        this.applyToDataSet();
    }

    private void sortCategoricalValues() {
        for (int i = 0; i < this.traits.size(); ++i) {
            Trait trait = this.traits.get(i);
            if (trait.traitIsNumerical()) continue;
            ArrayList<String> categories = trait.getCategories();
            String[] oldCats = categories.toArray(new String[0]);
            Collections.sort(categories);
            Set<String> e = this.hashtable.keySet();
            for (String traitString : e) {
                TraitValue tv = this.hashtable.get(traitString).get(i);
                float newVal = categories.indexOf(oldCats[(int)tv.getValue()]);
                tv.setValue(newVal);
            }
        }
    }

    private void applyToDataSet() {
        for (Trait trait : this.traits) {
            this.dataSet.getTraits().add(trait);
            ++this.traitsCount;
        }
        for (Line line : this.dataSet.getLines()) {
            ArrayList<TraitValue> traitValues = this.hashtable.get(line.getName());
            if (traitValues != null) {
                for (TraitValue tv : traitValues) {
                    tv.computeNormal();
                    line.getTraitValues().add(tv);
                    ++this.traitsRead;
                }
                continue;
            }
            for (int i = 0; i < this.traits.size(); ++i) {
                Trait trait = this.traits.get(i);
                line.getTraitValues().add(new TraitValue(trait));
            }
        }
    }

    public int getValue() {
        if (this.is == null) {
            return 0;
        }
        return Math.round((float)this.is.getBytesRead() / (float)this.file.length() * 5555.0f);
    }

    public int getTraitsCount() {
        return this.traitsCount;
    }

    public int getTraitsRead() {
        return this.traitsRead;
    }
}

