/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization.undo;

import java.util.ArrayList;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.IUndoState;

public class SelectedMarkersState
implements IUndoState {
    private GTViewSet viewSet;
    private GTView view;
    private String menuStr;
    private ArrayList<boolean[]> undoMarkers;
    private ArrayList<boolean[]> redoMarkers;

    public SelectedMarkersState(GTView view) {
        this.view = view;
        this.viewSet = view.getViewSet();
    }

    public SelectedMarkersState(GTView view, String menuStr) {
        this(view);
        this.menuStr = menuStr;
    }

    @Override
    public String getMenuString() {
        return this.menuStr;
    }

    public void setMenuString(String menuStr) {
        this.menuStr = menuStr;
    }

    @Override
    public GTView getView() {
        return this.view;
    }

    @Override
    public void createUndoState() {
        this.undoMarkers = new ArrayList(this.viewSet.chromosomeCount());
        for (GTView view : this.viewSet.getViews()) {
            boolean[] states = new boolean[view.markerCount()];
            for (int i = 0; i < states.length; ++i) {
                states[i] = view.isMarkerSelected(i);
            }
            this.undoMarkers.add(states);
        }
    }

    @Override
    public void applyUndoState() {
        for (int v = 0; v < this.viewSet.chromosomeCount(); ++v) {
            GTView view = this.viewSet.getViews().get(v);
            boolean[] states = this.undoMarkers.get(v);
            for (int i = 0; i < states.length; ++i) {
                view.setMarkerState(i, states[i]);
            }
        }
    }

    @Override
    public void createRedoState() {
        this.redoMarkers = new ArrayList(this.viewSet.chromosomeCount());
        for (GTView view : this.viewSet.getViews()) {
            boolean[] states = new boolean[view.markerCount()];
            for (int i = 0; i < states.length; ++i) {
                states[i] = view.isMarkerSelected(i);
            }
            this.redoMarkers.add(states);
        }
    }

    @Override
    public void applyRedoState() {
        for (int v = 0; v < this.viewSet.chromosomeCount(); ++v) {
            GTView view = this.viewSet.getViews().get(v);
            boolean[] states = this.redoMarkers.get(v);
            for (int i = 0; i < states.length; ++i) {
                view.setMarkerState(i, states[i]);
            }
        }
    }
}

