/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization.colors;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import jhi.flapjack.data.AlleleState;
import jhi.flapjack.data.GTView;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.colors.ColorScheme;
import jhi.flapjack.gui.visualization.colors.ColorState;
import jhi.flapjack.gui.visualization.colors.HomozygousColorState;
import jhi.flapjack.gui.visualization.colors.SimpleColorState;
import scri.commons.gui.RB;

public class ABHDataColorScheme
extends ColorScheme {
    protected ArrayList<ColorState> states = new ArrayList();

    public ABHDataColorScheme() {
    }

    public ABHDataColorScheme(GTView view, int w, int h) {
        super(view);
        for (int i = 0; i < this.stateTable.size(); ++i) {
            AlleleState state = this.stateTable.getAlleleState(i);
            ColorState c = null;
            if (state.isUnknown()) {
                c = new SimpleColorState(state, Prefs.visColorBackground, w, h);
            } else if (state.isHomozygous()) {
                c = state.homzAllele().equals("A") ? new HomozygousColorState(state, Prefs.visColorABH_A, w, h) : (state.homzAllele().equals("B") ? new HomozygousColorState(state, Prefs.visColorABH_B, w, h) : (state.homzAllele().equals("H") ? new HomozygousColorState(state, Prefs.visColorABH_H, w, h) : new HomozygousColorState(state, Prefs.visColorABH_Other, w, h)));
            }
            this.states.add(c);
        }
    }

    @Override
    public BufferedImage getSelectedImage(int line, int marker, boolean underQTL) {
        int state = this.view.getState(line, marker);
        return this.states.get(state).getImage(underQTL);
    }

    @Override
    public BufferedImage getUnselectedImage(int line, int marker, boolean underQTL) {
        int state = this.view.getState(line, marker);
        return this.states.get(state).getUnselectedImage(underQTL);
    }

    @Override
    public Color getColor(int line, int marker) {
        int state = this.view.getState(line, marker);
        return this.states.get(state).getColor();
    }

    @Override
    public int getModel() {
        return 8;
    }

    public String toString() {
        return RB.getString((String)"gui.Actions.vizColorABHData");
    }

    @Override
    public String getDescription() {
        return RB.getString((String)"gui.visualization.colors.ABHColorScheme");
    }

    @Override
    public ArrayList<ColorScheme.ColorSummary> getColorSummaries() {
        ArrayList<ColorScheme.ColorSummary> colors = new ArrayList<ColorScheme.ColorSummary>();
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorABH_A, RB.getString((String)"gui.visualization.colors.ABHColorScheme.a")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorABH_B, RB.getString((String)"gui.visualization.colors.ABHColorScheme.b")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorABH_H, RB.getString((String)"gui.visualization.colors.ABHColorScheme.h")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorABH_C, RB.getString((String)"gui.visualization.colors.ABHColorScheme.c")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorABH_D, RB.getString((String)"gui.visualization.colors.ABHColorScheme.d")));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorABH_Other, RB.getString((String)"gui.visualization.colors.ABHColorScheme.other")));
        return colors;
    }

    @Override
    public void setColorSummaries(ArrayList<ColorScheme.ColorSummary> colors) {
        Prefs.visColorABH_A = colors.get((int)0).color;
        Prefs.visColorABH_B = colors.get((int)1).color;
        Prefs.visColorABH_H = colors.get((int)2).color;
        Prefs.visColorABH_C = colors.get((int)3).color;
        Prefs.visColorABH_D = colors.get((int)4).color;
        Prefs.visColorABH_Other = colors.get((int)5).color;
    }
}

