/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.TraitValue;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.GenotypeCanvas;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.TraitCanvasML;

class TraitCanvas
extends JPanel {
    private GenotypePanel gPanel;
    private GenotypeCanvas canvas;
    private Canvas2D traitCanvas;
    private int boxW = 10;
    private int w = 0;

    TraitCanvas(GenotypePanel gPanel, GenotypeCanvas canvas) {
        this.gPanel = gPanel;
        this.canvas = canvas;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(1, 5, 0, 5));
        this.traitCanvas = new Canvas2D();
        this.add(this.traitCanvas);
    }

    int getPanelWidth() {
        return this.isVisible() ? this.getWidth() : 0;
    }

    void determineVisibility() {
        int traitCount = 0;
        if (this.canvas.viewSet != null) {
            traitCount = this.canvas.viewSet.getTraits().length;
        }
        int oldW = this.w;
        this.w = this.boxW * traitCount;
        if (oldW != this.w) {
            this.traitCanvas.setSize(this.w, 0);
        }
        this.setVisible(traitCount > 0 && Prefs.visShowTraitCanvas);
    }

    private void render(Graphics2D g, int yS, int yE) {
        int[] tIndex = this.canvas.viewSet.getTraits();
        int boxH = this.canvas.boxH;
        for (int i = 0; i < tIndex.length; ++i) {
            if (tIndex[i] == -1) continue;
            Color prev = null;
            int yIndex = yS;
            int y = 0;
            while (yIndex <= yE) {
                Line line = this.canvas.view.getLine(yIndex);
                if (this.canvas.view.isDummyLine(yIndex) || this.canvas.view.isSplitter(yIndex)) {
                    prev = null;
                } else {
                    TraitValue tv = line.getTraitValues().get(tIndex[i]);
                    if (!tv.isDefined()) {
                        prev = null;
                    } else {
                        Color c = tv.displayColor();
                        g.setColor(c);
                        g.fillRect(i * this.boxW, y, this.boxW, boxH);
                        if (!tv.getTrait().traitIsNumerical() && Prefs.visShowCatBoundaries && !c.equals(prev)) {
                            g.setColor(new Color(128, 128, 128));
                            g.drawLine(i * this.boxW, y, i * this.boxW + this.boxW, y);
                        }
                        prev = c;
                    }
                }
                ++yIndex;
                y += boxH;
            }
        }
    }

    BufferedImage createSavableImage(boolean createFull) {
        try {
            int yS = this.canvas.pY1 / this.canvas.boxH;
            int yE = this.canvas.pY2 / this.canvas.boxH;
            int h = this.canvas.pY2 - this.canvas.pY1 + 1;
            if (createFull) {
                yS = 0;
                yE = this.canvas.view.lineCount() - 1;
                h = this.canvas.canvasH;
            }
            BufferedImage buffer = (BufferedImage)this.createImage(this.w, h);
            Graphics2D g = buffer.createGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, this.w, h);
            if (!createFull) {
                g.translate(0, -this.canvas.pY1 % this.canvas.boxH);
            }
            this.render(g, yS, yE);
            g.dispose();
            return buffer;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private class Canvas2D
    extends JPanel {
        Canvas2D() {
            TraitCanvasML mt = new TraitCanvasML(TraitCanvas.this.gPanel, TraitCanvas.this.canvas, TraitCanvas.this.boxW);
            this.addMouseListener(mt);
            this.addMouseMotionListener(mt);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(TraitCanvas.this.w, 0);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D g = (Graphics2D)graphics;
            int jiggle = ((TraitCanvas)TraitCanvas.this).canvas.pY1 % ((TraitCanvas)TraitCanvas.this).canvas.boxH;
            g.translate(0, -jiggle);
            g.setClip(0, jiggle, TraitCanvas.this.w, ((TraitCanvas)TraitCanvas.this).canvas.pY2 - ((TraitCanvas)TraitCanvas.this).canvas.pY1 + 1);
            int yS = ((TraitCanvas)TraitCanvas.this).canvas.pY1 / ((TraitCanvas)TraitCanvas.this).canvas.boxH;
            int yE = ((TraitCanvas)TraitCanvas.this).canvas.pY2 / ((TraitCanvas)TraitCanvas.this).canvas.boxH;
            TraitCanvas.this.render(g, yS, yE);
        }
    }
}

