/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import jhi.flapjack.gui.visualization.GenotypeCanvas;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.IOverlayRenderer;

public class LMHighlighter
extends Thread
implements IOverlayRenderer {
    private GenotypeCanvas canvas;
    private int alphaEffect = 0;
    private int index = 0;
    private int method = 0;
    private ArrayList<Integer> indices = new ArrayList();

    public LMHighlighter(GenotypePanel gPanel, int index, LMHighlighter previous, int method) {
        this.index = index;
        this.method = method;
        this.canvas = gPanel.canvas;
        if (previous != null) {
            previous.interrupt();
            this.canvas.overlays.remove(previous);
        }
        this.start();
    }

    public LMHighlighter(GenotypePanel gPanel, ArrayList<Integer> indices, LMHighlighter previous) {
        this.indices = indices;
        this.method = 2;
        this.canvas = gPanel.canvas;
        if (previous != null) {
            previous.interrupt();
            this.canvas.overlays.remove(previous);
        }
        this.start();
    }

    @Override
    public void run() {
        this.canvas.overlays.add(this);
        this.alphaEffect = 200;
        this.canvas.repaint();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        for (int i = 1; i <= 40 && !this.isInterrupted(); ++i) {
            this.alphaEffect = 200 - i * 5;
            this.canvas.repaint();
            try {
                Thread.sleep(25L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.canvas.overlays.remove(this);
    }

    @Override
    public void render(Graphics2D g) {
        if (this.method == 0) {
            this.renderForLines(g);
        } else if (this.method == 1) {
            this.renderForMarkers(g);
        } else {
            this.renderForMultipleLines(g);
        }
    }

    private void renderForLines(Graphics2D g) {
        g.setPaint(new Color(20, 20, 20, this.alphaEffect));
        int y1 = this.index * this.canvas.boxH;
        int y2 = y1 + this.canvas.boxH;
        g.fillRect(0, 0, this.canvas.canvasW, y1);
        g.fillRect(0, y2, this.canvas.canvasW, this.canvas.canvasH - y2);
    }

    private void renderForMultipleLines(Graphics2D g) {
        g.setPaint(new Color(20, 20, 20, this.alphaEffect));
        int prevY = 0;
        for (int i = 0; i < this.indices.size(); ++i) {
            int y1 = this.indices.get(i) * this.canvas.boxH;
            g.fillRect(0, prevY, this.canvas.canvasW, y1 - prevY);
            prevY = y1 + this.canvas.boxH;
        }
        g.fillRect(0, prevY, this.canvas.canvasW, this.canvas.canvasH - prevY);
    }

    private void renderForMarkers(Graphics2D g) {
        g.setPaint(new Color(20, 20, 20, this.alphaEffect));
        int x1 = this.index * this.canvas.boxW;
        int x2 = x1 + this.canvas.boxW;
        g.fillRect(0, 0, x1, this.canvas.canvasH);
        g.fillRect(x2, 0, this.canvas.canvasW - x2, this.canvas.canvasH);
    }
}

