/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog.analysis;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.dialog.analysis.SortLinesByTraitTableModel;
import jhi.flapjack.gui.visualization.GenotypePanel;
import scri.commons.gui.RB;

class SortLinesByTraitPanelNB
extends JPanel
implements ActionListener,
ListSelectionListener {
    SortLinesByTraitTableModel model;
    private JButton bAdd;
    private JButton bDelete;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private JCheckBox checkAssign;
    private JScrollPane jScrollPane1;
    private JTable table;

    public SortLinesByTraitPanelNB(GenotypePanel gPanel) {
        this.initComponents();
        this.setBackground((Color)UIManager.get("fjDialogBG"));
        RB.setText((AbstractButton)this.bAdd, (String)"gui.dialog.analysis.NBSortLinesByTraitPanel.bAdd");
        RB.setText((AbstractButton)this.bDelete, (String)"gui.dialog.analysis.NBSortLinesByTraitPanel.bDelete");
        RB.setText((AbstractButton)this.checkAssign, (String)"gui.dialog.analysis.NBSortLinesByTraitPanel.checkAssign");
        this.bAdd.addActionListener(this);
        this.bDelete.addActionListener(this);
        this.checkAssign.setSelected(Prefs.guiAssignTraits);
        this.updateModel(gPanel.getViewSet().getDataSet());
        this.checkButtonStates();
    }

    public void updateModel(DataSet dataSet) {
        this.model = new SortLinesByTraitTableModel(dataSet);
        this.table.setModel(this.model);
        this.table.setSelectionMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getSelectionModel().addListSelectionListener(this);
        TableColumn c0 = this.table.getColumnModel().getColumn(0);
        c0.setCellEditor(new DefaultCellEditor(this.model.getTraitComboBox()));
        TableColumn c1 = this.table.getColumnModel().getColumn(1);
        c1.setPreferredWidth(60);
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    boolean isOK() {
        Prefs.guiAssignTraits = this.checkAssign.isSelected();
        return true;
    }

    private void checkButtonStates() {
        this.bAdd.setEnabled(this.model.getRowCount() > 0);
        if (this.model.getRowCount() > 1 && this.table.getSelectedRow() != -1) {
            this.bDelete.setEnabled(true);
        } else {
            this.bDelete.setEnabled(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.checkButtonStates();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bAdd) {
            this.model.addRow();
        } else if (e.getSource() == this.bDelete) {
            this.model.deleteRow(this.table.getSelectedRow());
        }
        this.checkButtonStates();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.checkAssign = new JCheckBox();
        this.bAdd = new JButton();
        this.bDelete = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.checkAssign.setText("Auto assign these traits to the traits heatmap once the sort is completed");
        this.bAdd.setText("Add sort level");
        this.bDelete.setText("Delete sort level");
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.table.setAutoResizeMode(4);
        this.table.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.table);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 439, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkAssign).addGroup(layout.createSequentialGroup().addComponent(this.bAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bDelete))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bAdd).addComponent(this.bDelete)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 152, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkAssign).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

