/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.Prefs;
import scri.commons.gui.RB;
import scri.commons.gui.SwingUtils;
import scri.commons.gui.SystemUtils;
import scri.commons.gui.TaskDialog;
import scri.commons.io.FileUtils;

public class FlapjackUtils {
    public static Cursor HAND_CURSOR = new Cursor(12);
    private static final String INSTANCE_ID = SystemUtils.createGUID((int)8);
    private static File cacheDir;
    private static File instanceDir;

    public static void setHelp(JButton button, String topic) {
        final String html = "http://flapjack.hutton.ac.uk/en/latest/" + topic;
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlapjackUtils.visitURL(html);
            }
        });
        AbstractAction helpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlapjackUtils.visitURL(html);
            }
        };
        KeyStroke ks = KeyStroke.getKeyStroke(112, 0);
        button.getInputMap(2).put(ks, "help");
        button.getActionMap().put("help", helpAction);
    }

    public static void visitURL(String html) {
        try {
            Desktop desktop = Desktop.getDesktop();
            URI uri = new URI(html);
            desktop.browse(uri);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void sendFeedback() {
        try {
            Desktop desktop = Desktop.getDesktop();
            desktop.mail(new URI("mailto:flapjack@hutton.ac.uk?subject=Flapjack%20Feedback"));
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static String getSaveFilename(String title, File file, FileNameExtensionFilter filter) {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(title);
        fc.setCurrentDirectory(new File(Prefs.guiCurrentDir));
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(filter);
        if (file != null) {
            fc.setSelectedFile(file);
        }
        while (fc.showSaveDialog(Flapjack.winMain) == 0) {
            file = fc.getSelectedFile();
            if (!file.exists() && file.getName().indexOf(".") == -1) {
                file = new File(file.getPath() + "." + filter.getExtensions()[0]);
            }
            if (file.exists()) {
                String[] options;
                String msg = RB.format((String)"gui.FlapjackUtils.getSaveFilename.confirm", (Object[])new Object[]{file});
                int response = TaskDialog.show((String)msg, (int)2, (int)1, (String[])(options = new String[]{RB.getString((String)"gui.FlapjackUtils.getSaveFilename.overwrite"), RB.getString((String)"gui.FlapjackUtils.getSaveFilename.rename"), RB.getString((String)"gui.text.cancel")}));
                if (response == 1) continue;
                if (response == -1 || response == 2) {
                    return null;
                }
            }
            Prefs.guiCurrentDir = fc.getCurrentDirectory().getPath();
            return file.getPath();
        }
        return null;
    }

    public static File getCacheDir() {
        if (instanceDir == null) {
            cacheDir = FileUtils.getTempUserDirectory((String)"jhi-flapjack");
            cacheDir.deleteOnExit();
            instanceDir = new File(cacheDir, INSTANCE_ID);
            instanceDir.deleteOnExit();
            instanceDir.mkdirs();
        }
        return instanceDir;
    }

    public static void initialiseSqlite() {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static File getLogFile() {
        try {
            File root = new File(System.getProperty("user.home"));
            File folder = new File(root, ".scri-bioinf");
            File logFile = new File(folder, "flapjack.log");
            return logFile;
        }
        catch (Throwable e) {
            return new File("");
        }
    }

    public static void initPanel(Container ... array) {
        Color color = (Color)UIManager.get("fjDialogBG");
        for (Container container : array) {
            container.setBackground(color);
        }
    }

    public static void initDialog(JDialog dialog, JButton bDefault, JButton bClose, boolean visible, Container ... array) {
        Color color = (Color)UIManager.get("fjDialogBG");
        for (Container container : array) {
            container.setBackground(color);
        }
        dialog.getRootPane().setDefaultButton(bDefault);
        SwingUtils.addCloseHandler((Window)dialog, (JComponent)bClose);
        dialog.pack();
        dialog.setLocationRelativeTo(Flapjack.winMain);
        dialog.setResizable(false);
        dialog.setVisible(visible);
    }
}

