/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.analysis;

import java.util.HashSet;
import jhi.flapjack.analysis.AnalysisSet;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.MarkerInfo;
import scri.commons.gui.SimpleJob;

public class FilterMonomorphicMarkers
extends SimpleJob {
    private GTViewSet viewSet;
    private boolean[] selectedChromosomes;
    private int count;

    public FilterMonomorphicMarkers(GTViewSet viewSet, boolean[] selectedChromosomes) {
        this.viewSet = viewSet;
        this.selectedChromosomes = selectedChromosomes;
    }

    public int getCount() {
        return this.count;
    }

    public void runJob(int index) throws Exception {
        AnalysisSet as = new AnalysisSet(this.viewSet).withViews(this.selectedChromosomes).withSelectedLines().withSelectedMarkers();
        for (int i = 0; i < as.viewCount(); ++i) {
            this.maximum += as.markerCount(i);
        }
        for (int view = 0; view < as.viewCount(); ++view) {
            boolean isSpecialChromosome = as.getGTView(view).getChromosomeMap().isSpecialChromosome();
            for (int marker = as.markerCount(view) - 1; marker >= 0 && this.okToRun; --marker) {
                HashSet<Integer> foundStates = new HashSet<Integer>();
                for (int line = 0; line < as.lineCount(); ++line) {
                    int state = as.getState(view, line, marker);
                    if (state != 0) {
                        foundStates.add(state);
                    }
                    if (foundStates.size() > 1) break;
                }
                if (foundStates.isEmpty() || foundStates.size() == 1) {
                    MarkerInfo mi = as.getMarker(view, marker);
                    as.getGTView(view).hideMarker(mi);
                    if (!isSpecialChromosome) {
                        ++this.count;
                    }
                }
                ++this.progress;
            }
        }
    }
}

