/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDAbstractArray;
import ch.systemsx.cisd.hdf5.CharacterEncoding;
import ch.systemsx.cisd.hdf5.HDF5AbstractStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5CommonInformation;
import ch.systemsx.cisd.hdf5.HDF5CompoundType;
import ch.systemsx.cisd.hdf5.HDF5DataSetInformation;
import ch.systemsx.cisd.hdf5.HDF5LinkInformation;
import ch.systemsx.cisd.hdf5.HDF5ObjectInformation;
import ch.systemsx.cisd.hdf5.HDF5ObjectType;
import ch.systemsx.cisd.hdf5.HDF5StorageLayout;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5WriterConfigurator;
import ch.systemsx.cisd.hdf5.cleanup.CleanUpCallable;
import ch.systemsx.cisd.hdf5.cleanup.CleanUpRegistry;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.hdf5lib.H5A;
import ch.systemsx.cisd.hdf5.hdf5lib.H5D;
import ch.systemsx.cisd.hdf5.hdf5lib.H5F;
import ch.systemsx.cisd.hdf5.hdf5lib.H5GLO;
import ch.systemsx.cisd.hdf5.hdf5lib.H5P;
import ch.systemsx.cisd.hdf5.hdf5lib.H5RI;
import ch.systemsx.cisd.hdf5.hdf5lib.H5S;
import ch.systemsx.cisd.hdf5.hdf5lib.H5T;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import ch.systemsx.cisd.hdf5.hdf5lib.HDFNativeData;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;

class HDF5 {
    private static final int MAX_PATH_LENGTH = 16384;
    private final CleanUpCallable runner;
    private final int dataSetCreationPropertyListCompactStorageLayoutFileTimeAlloc;
    private final int dataSetCreationPropertyListFillTimeAlloc;
    private final int numericConversionXferPropertyListID;
    private final int lcplCreateIntermediateGroups;
    private final boolean useUTF8CharEncoding;
    private final boolean autoDereference;

    public HDF5(CleanUpRegistry fileRegistry, CleanUpCallable runner, boolean performNumericConversions, boolean useUTF8CharEncoding, boolean autoDereference) {
        this.runner = runner;
        this.useUTF8CharEncoding = useUTF8CharEncoding;
        this.autoDereference = autoDereference;
        this.dataSetCreationPropertyListCompactStorageLayoutFileTimeAlloc = this.createDataSetCreationPropertyList(fileRegistry);
        H5P.H5Pset_layout(this.dataSetCreationPropertyListCompactStorageLayoutFileTimeAlloc, HDF5Constants.H5D_COMPACT);
        this.dataSetCreationPropertyListFillTimeAlloc = this.createDataSetCreationPropertyList(fileRegistry);
        this.numericConversionXferPropertyListID = performNumericConversions ? this.createDataSetXferPropertyListAbortOverflow(fileRegistry) : this.createDataSetXferPropertyListAbort(fileRegistry);
        this.lcplCreateIntermediateGroups = this.createLinkCreationPropertyList(true, fileRegistry);
    }

    private static void checkMaxLength(String path) throws HDF5JavaException {
        if (path.length() > 16384) {
            throw new HDF5JavaException("Path too long (length=" + path.length() + ")");
        }
    }

    public int createFile(String fileName, boolean useLatestFormat, ICleanUpRegistry registry) {
        int fileAccessPropertyListId = this.createFileAccessPropertyListId(useLatestFormat, registry);
        final int fileId = H5F.H5Fcreate(fileName, HDF5Constants.H5F_ACC_TRUNC, HDF5Constants.H5P_DEFAULT, fileAccessPropertyListId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5F.H5Fclose(fileId);
            }
        });
        return fileId;
    }

    private int createFileAccessPropertyListId(boolean enforce_1_8, ICleanUpRegistry registry) {
        int fileAccessPropertyListId = HDF5Constants.H5P_DEFAULT;
        if (enforce_1_8) {
            final int fapl = H5P.H5Pcreate(HDF5Constants.H5P_FILE_ACCESS);
            registry.registerCleanUp(new Runnable(){

                @Override
                public void run() {
                    H5P.H5Pclose(fapl);
                }
            });
            H5P.H5Pset_libver_bounds(fapl, HDF5Constants.H5F_LIBVER_LATEST, HDF5Constants.H5F_LIBVER_LATEST);
            fileAccessPropertyListId = fapl;
        }
        return fileAccessPropertyListId;
    }

    public int openFileReadOnly(String fileName, ICleanUpRegistry registry) {
        final int fileId = H5F.H5Fopen(fileName, HDF5Constants.H5F_ACC_RDONLY, HDF5Constants.H5P_DEFAULT);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5F.H5Fclose(fileId);
            }
        });
        return fileId;
    }

    public int openFileReadWrite(String fileName, boolean enforce_1_8, ICleanUpRegistry registry) {
        int fileAccessPropertyListId = this.createFileAccessPropertyListId(enforce_1_8, registry);
        File f = new File(fileName);
        if (f.exists() && !f.isFile()) {
            throw new HDF5Exception("An entry with name '" + fileName + "' exists but is not a file.");
        }
        final int fileId = H5F.H5Fopen(fileName, HDF5Constants.H5F_ACC_RDWR, fileAccessPropertyListId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5F.H5Fclose(fileId);
            }
        });
        return fileId;
    }

    public void flushFile(int fileId) {
        H5F.H5Fflush(fileId, HDF5Constants.H5F_SCOPE_GLOBAL);
    }

    public int openObject(int fileId, String path, ICleanUpRegistry registry) {
        HDF5.checkMaxLength(path);
        final int objectId = this.isReference(path) ? H5RI.H5Rdereference(fileId, Long.parseLong(path.substring(1))) : H5GLO.H5Oopen(fileId, path, HDF5Constants.H5P_DEFAULT);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5GLO.H5Oclose(objectId);
            }
        });
        return objectId;
    }

    public int deleteObject(int fileId, String path) {
        HDF5.checkMaxLength(path);
        int success = H5GLO.H5Gunlink(fileId, path);
        return success;
    }

    public int copyObject(int srcFileId, String srcPath, int dstFileId, String dstPath) {
        HDF5.checkMaxLength(srcPath);
        HDF5.checkMaxLength(dstPath);
        int success = H5GLO.H5Ocopy(srcFileId, srcPath, dstFileId, dstPath, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
        return success;
    }

    public int moveLink(int fileId, String srcLinkPath, String dstLinkPath) {
        HDF5.checkMaxLength(srcLinkPath);
        HDF5.checkMaxLength(dstLinkPath);
        int success = H5GLO.H5Lmove(fileId, srcLinkPath, fileId, dstLinkPath, this.lcplCreateIntermediateGroups, HDF5Constants.H5P_DEFAULT);
        return success;
    }

    public void createGroup(int fileId, String groupName) {
        HDF5.checkMaxLength(groupName);
        int groupId = H5GLO.H5Gcreate(fileId, groupName, this.lcplCreateIntermediateGroups, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
        H5GLO.H5Gclose(groupId);
    }

    public void createOldStyleGroup(int fileId, String groupName, int sizeHint, ICleanUpRegistry registry) {
        HDF5.checkMaxLength(groupName);
        final int gcplId = H5P.H5Pcreate(HDF5Constants.H5P_GROUP_CREATE);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5P.H5Pclose(gcplId);
            }
        });
        H5P.H5Pset_local_heap_size_hint(gcplId, sizeHint);
        int groupId = H5GLO.H5Gcreate(fileId, groupName, this.lcplCreateIntermediateGroups, gcplId, HDF5Constants.H5P_DEFAULT);
        H5GLO.H5Gclose(groupId);
    }

    public void createNewStyleGroup(int fileId, String groupName, int maxCompact, int minDense, ICleanUpRegistry registry) {
        HDF5.checkMaxLength(groupName);
        final int gcplId = H5P.H5Pcreate(HDF5Constants.H5P_GROUP_CREATE);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5P.H5Pclose(gcplId);
            }
        });
        H5P.H5Pset_link_phase_change(gcplId, maxCompact, minDense);
        int groupId = H5GLO.H5Gcreate(fileId, groupName, this.lcplCreateIntermediateGroups, gcplId, HDF5Constants.H5P_DEFAULT);
        H5GLO.H5Gclose(groupId);
    }

    public int openGroup(int fileId, String path, ICleanUpRegistry registry) {
        HDF5.checkMaxLength(path);
        final int groupId = this.isReference(path) ? H5RI.H5Rdereference(fileId, Long.parseLong(path.substring(1))) : H5GLO.H5Gopen(fileId, path, HDF5Constants.H5P_DEFAULT);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5GLO.H5Gclose(groupId);
            }
        });
        return groupId;
    }

    public long getNumberOfGroupMembers(int fileId, String path, ICleanUpRegistry registry) {
        HDF5.checkMaxLength(path);
        final int groupId = H5GLO.H5Gopen(fileId, path, HDF5Constants.H5P_DEFAULT);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5GLO.H5Gclose(groupId);
            }
        });
        return H5GLO.H5Gget_nlinks(groupId);
    }

    public boolean existsAttribute(int objectId, String attributeName) {
        HDF5.checkMaxLength(attributeName);
        return H5A.H5Aexists(objectId, attributeName);
    }

    public boolean exists(int fileId, String linkName) {
        HDF5.checkMaxLength(linkName);
        return H5GLO.H5Lexists(fileId, linkName);
    }

    public HDF5LinkInformation getLinkInfo(int fileId, String objectName, boolean exceptionIfNonExistent) {
        HDF5.checkMaxLength(objectName);
        if ("/".equals(objectName)) {
            return HDF5LinkInformation.ROOT_LINK_INFO;
        }
        String[] lname = new String[1];
        int typeId = H5GLO.H5Lget_link_info(fileId, objectName, lname, exceptionIfNonExistent);
        return HDF5LinkInformation.create(objectName, typeId, lname[0]);
    }

    public HDF5ObjectType getLinkTypeInfo(int fileId, String objectName, boolean exceptionWhenNonExistent) {
        HDF5.checkMaxLength(objectName);
        if ("/".equals(objectName)) {
            return HDF5ObjectType.GROUP;
        }
        int typeId = H5GLO.H5Lget_link_info(fileId, objectName, null, exceptionWhenNonExistent);
        return HDF5CommonInformation.objectTypeIdToObjectType(typeId);
    }

    public HDF5ObjectInformation getObjectInfo(int fileId, String objectName, boolean exceptionWhenNonExistent) {
        HDF5.checkMaxLength(objectName);
        long[] info = new long[5];
        int typeId = H5GLO.H5Oget_info_by_name(fileId, objectName, info, exceptionWhenNonExistent);
        return new HDF5ObjectInformation(objectName, HDF5CommonInformation.objectTypeIdToObjectType(typeId), info);
    }

    public int getObjectTypeId(int fileId, String objectName, boolean exceptionWhenNonExistent) {
        HDF5.checkMaxLength(objectName);
        if ("/".equals(objectName)) {
            return HDF5Constants.H5O_TYPE_GROUP;
        }
        return H5GLO.H5Oget_info_by_name(fileId, objectName, null, exceptionWhenNonExistent);
    }

    public HDF5ObjectType getObjectTypeInfo(int fileId, String objectName, boolean exceptionWhenNonExistent) {
        return HDF5CommonInformation.objectTypeIdToObjectType(this.getObjectTypeId(fileId, objectName, exceptionWhenNonExistent));
    }

    public String[] getGroupMembers(final int fileId, final String groupName) {
        HDF5.checkMaxLength(groupName);
        ICallableWithCleanUp<String[]> dataDimensionRunnable = new ICallableWithCleanUp<String[]>(){

            @Override
            public String[] call(ICleanUpRegistry registry) {
                int groupId = HDF5.this.openGroup(fileId, groupName, registry);
                long nLong = H5GLO.H5Gget_nlinks(groupId);
                int n = (int)nLong;
                if ((long)n != nLong) {
                    throw new HDF5JavaException("Number of group members is too large (n=" + nLong + ")");
                }
                String[] names = new String[n];
                H5GLO.H5Lget_link_names_all(groupId, ".", names);
                return names;
            }
        };
        return this.runner.call(dataDimensionRunnable);
    }

    public List<HDF5LinkInformation> getGroupMemberLinkInfo(final int fileId, final String groupName, final boolean includeInternal, final String houseKeepingNameSuffix) {
        HDF5.checkMaxLength(groupName);
        ICallableWithCleanUp<List<HDF5LinkInformation>> dataDimensionRunnable = new ICallableWithCleanUp<List<HDF5LinkInformation>>(){

            @Override
            public List<HDF5LinkInformation> call(ICleanUpRegistry registry) {
                int groupId = HDF5.this.openGroup(fileId, groupName, registry);
                long nLong = H5GLO.H5Gget_nlinks(groupId);
                int n = (int)nLong;
                if ((long)n != nLong) {
                    throw new HDF5JavaException("Number of group members is too large (n=" + nLong + ")");
                }
                String[] names = new String[n];
                String[] linkNames = new String[n];
                int[] types = new int[n];
                H5GLO.H5Lget_link_info_all(groupId, ".", names, types, linkNames);
                String superGroupName = groupName.equals("/") ? "/" : String.valueOf(groupName) + "/";
                LinkedList<HDF5LinkInformation> info = new LinkedList<HDF5LinkInformation>();
                int i = 0;
                while (i < n) {
                    if (includeInternal || !HDF5Utils.isInternalName(names[i], houseKeepingNameSuffix)) {
                        info.add(HDF5LinkInformation.create(String.valueOf(superGroupName) + names[i], types[i], linkNames[i]));
                    }
                    ++i;
                }
                return info;
            }
        };
        return this.runner.call(dataDimensionRunnable);
    }

    public List<HDF5LinkInformation> getGroupMemberTypeInfo(final int fileId, final String groupName, final boolean includeInternal, final String houseKeepingNameSuffix) {
        HDF5.checkMaxLength(groupName);
        ICallableWithCleanUp<List<HDF5LinkInformation>> dataDimensionRunnable = new ICallableWithCleanUp<List<HDF5LinkInformation>>(){

            @Override
            public List<HDF5LinkInformation> call(ICleanUpRegistry registry) {
                int groupId = HDF5.this.openGroup(fileId, groupName, registry);
                long nLong = H5GLO.H5Gget_nlinks(groupId);
                int n = (int)nLong;
                if ((long)n != nLong) {
                    throw new HDF5JavaException("Number of group members is too large (n=" + nLong + ")");
                }
                String[] names = new String[n];
                int[] types = new int[n];
                H5GLO.H5Lget_link_info_all(groupId, ".", names, types, null);
                String superGroupName = groupName.equals("/") ? "/" : String.valueOf(groupName) + "/";
                LinkedList<HDF5LinkInformation> info = new LinkedList<HDF5LinkInformation>();
                int i = 0;
                while (i < n) {
                    if (includeInternal || !HDF5Utils.isInternalName(names[i], houseKeepingNameSuffix)) {
                        info.add(HDF5LinkInformation.create(String.valueOf(superGroupName) + names[i], types[i], null));
                    }
                    ++i;
                }
                return info;
            }
        };
        return this.runner.call(dataDimensionRunnable);
    }

    public void createHardLink(int fileId, String objectName, String linkName) {
        HDF5.checkMaxLength(objectName);
        HDF5.checkMaxLength(linkName);
        H5GLO.H5Lcreate_hard(fileId, objectName, fileId, linkName, this.lcplCreateIntermediateGroups, HDF5Constants.H5P_DEFAULT);
    }

    public void createSoftLink(int fileId, String linkName, String targetPath) {
        HDF5.checkMaxLength(linkName);
        HDF5.checkMaxLength(targetPath);
        H5GLO.H5Lcreate_soft(targetPath, fileId, linkName, this.lcplCreateIntermediateGroups, HDF5Constants.H5P_DEFAULT);
    }

    public void createExternalLink(int fileId, String linkName, String targetFileName, String targetPath) {
        HDF5.checkMaxLength(linkName);
        HDF5.checkMaxLength(targetFileName);
        HDF5.checkMaxLength(targetPath);
        H5GLO.H5Lcreate_external(targetFileName, targetPath, fileId, linkName, this.lcplCreateIntermediateGroups, HDF5Constants.H5P_DEFAULT);
    }

    public void writeStringVL(int dataSetId, int dataTypeId, String[] value) {
        H5D.H5DwriteString(dataSetId, dataTypeId, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, value);
    }

    public void writeStringVL(int dataSetId, int dataTypeId, int memorySpaceId, int fileSpaceId, String[] value) {
        H5D.H5DwriteString(dataSetId, dataTypeId, memorySpaceId, fileSpaceId, HDF5Constants.H5P_DEFAULT, value);
    }

    public int createDataSet(int fileId, long[] dimensions, long[] chunkSizeOrNull, int dataTypeId, HDF5AbstractStorageFeatures compression, String dataSetName, HDF5StorageLayout layout, IHDF5WriterConfigurator.FileFormat fileFormat, ICleanUpRegistry registry) {
        int dataSetCreationPropertyListId;
        HDF5.checkMaxLength(dataSetName);
        final int dataSpaceId = H5S.H5Screate_simple(dimensions.length, dimensions, HDF5.createMaxDimensions(dimensions, layout == HDF5StorageLayout.CHUNKED));
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5S.H5Sclose(dataSpaceId);
            }
        });
        if (layout == HDF5StorageLayout.CHUNKED && chunkSizeOrNull != null) {
            dataSetCreationPropertyListId = this.createDataSetCreationPropertyList(registry);
            this.setChunkedLayout(dataSetCreationPropertyListId, chunkSizeOrNull);
            if (compression.isScaling()) {
                compression.checkScalingOK(fileFormat);
                int classTypeId = this.getClassType(dataTypeId);
                assert (compression.isCompatibleWithDataClass(classTypeId));
                if (classTypeId == HDF5Constants.H5T_INTEGER) {
                    H5P.H5Pset_scaleoffset(dataSetCreationPropertyListId, HDF5Constants.H5Z_SO_INT, compression.getScalingFactor());
                } else if (classTypeId == HDF5Constants.H5T_FLOAT) {
                    H5P.H5Pset_scaleoffset(dataSetCreationPropertyListId, HDF5Constants.H5Z_SO_FLOAT_DSCALE, compression.getScalingFactor());
                }
            }
            if (compression.isShuffleBeforeDeflate()) {
                this.setShuffle(dataSetCreationPropertyListId);
            }
            if (compression.isDeflating()) {
                this.setDeflate(dataSetCreationPropertyListId, compression.getDeflateLevel());
            }
        } else {
            dataSetCreationPropertyListId = layout == HDF5StorageLayout.COMPACT ? this.dataSetCreationPropertyListCompactStorageLayoutFileTimeAlloc : this.dataSetCreationPropertyListFillTimeAlloc;
        }
        final int dataSetId = H5D.H5Dcreate(fileId, dataSetName, dataTypeId, dataSpaceId, this.lcplCreateIntermediateGroups, dataSetCreationPropertyListId, HDF5Constants.H5P_DEFAULT);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5D.H5Dclose(dataSetId);
            }
        });
        return dataSetId;
    }

    private int createDataSetCreationPropertyList(ICleanUpRegistry registry) {
        final int dataSetCreationPropertyListId = H5P.H5Pcreate(HDF5Constants.H5P_DATASET_CREATE);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5P.H5Pclose(dataSetCreationPropertyListId);
            }
        });
        H5P.H5Pset_fill_time(dataSetCreationPropertyListId, HDF5Constants.H5D_FILL_TIME_ALLOC);
        return dataSetCreationPropertyListId;
    }

    public HDF5StorageLayout getLayout(int dataSetId, ICleanUpRegistry registry) {
        int dataSetCreationPropertyListId = this.getCreationPropertyList(dataSetId, registry);
        int layoutId = H5P.H5Pget_layout(dataSetCreationPropertyListId);
        if (layoutId == HDF5Constants.H5D_COMPACT) {
            return HDF5StorageLayout.COMPACT;
        }
        if (layoutId == HDF5Constants.H5D_CHUNKED) {
            return HDF5StorageLayout.CHUNKED;
        }
        return HDF5StorageLayout.CONTIGUOUS;
    }

    private int getCreationPropertyList(int dataSetId, ICleanUpRegistry registry) {
        final int dataSetCreationPropertyListId = H5D.H5Dget_create_plist(dataSetId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5P.H5Pclose(dataSetCreationPropertyListId);
            }
        });
        return dataSetCreationPropertyListId;
    }

    private static final long[] createMaxDimensions(long[] dimensions, boolean unlimited) {
        if (!unlimited) {
            return dimensions;
        }
        long[] maxDimensions = new long[dimensions.length];
        Arrays.fill(maxDimensions, (long)HDF5Constants.H5S_UNLIMITED);
        return maxDimensions;
    }

    private void setChunkedLayout(int dscpId, long[] chunkSize) {
        assert (dscpId >= 0);
        H5P.H5Pset_layout(dscpId, HDF5Constants.H5D_CHUNKED);
        H5P.H5Pset_chunk(dscpId, chunkSize.length, chunkSize);
    }

    private void setShuffle(int dscpId) {
        assert (dscpId >= 0);
        H5P.H5Pset_shuffle(dscpId);
    }

    private void setDeflate(int dscpId, int deflateLevel) {
        assert (dscpId >= 0);
        assert (deflateLevel >= 0);
        H5P.H5Pset_deflate(dscpId, deflateLevel);
    }

    public int createScalarDataSet(int fileId, int dataTypeId, String dataSetName, boolean compactLayout, ICleanUpRegistry registry) {
        HDF5.checkMaxLength(dataSetName);
        final int dataSpaceId = H5S.H5Screate(HDF5Constants.H5S_SCALAR);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5S.H5Sclose(dataSpaceId);
            }
        });
        final int dataSetId = H5D.H5Dcreate(fileId, dataSetName, dataTypeId, dataSpaceId, this.lcplCreateIntermediateGroups, compactLayout ? this.dataSetCreationPropertyListCompactStorageLayoutFileTimeAlloc : this.dataSetCreationPropertyListFillTimeAlloc, HDF5Constants.H5P_DEFAULT);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5D.H5Dclose(dataSetId);
            }
        });
        return dataSetId;
    }

    public int openDataSet(int fileId, String path, ICleanUpRegistry registry) {
        HDF5.checkMaxLength(path);
        final int dataSetId = this.isReference(path) ? H5RI.H5Rdereference(fileId, Long.parseLong(path.substring(1))) : H5D.H5Dopen(fileId, path, HDF5Constants.H5P_DEFAULT);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5D.H5Dclose(dataSetId);
            }
        });
        return dataSetId;
    }

    boolean isReference(String path) {
        return this.autoDereference && path.charAt(0) == '\u0000';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int openAndExtendDataSet(int fileId, String path, IHDF5WriterConfigurator.FileFormat fileFormat, long[] dimensions, int storageDataTypeId, ICleanUpRegistry registry) throws HDF5JavaException {
        HDF5.checkMaxLength(path);
        boolean overwriteMode = storageDataTypeId > -1;
        final int dataSetId = this.isReference(path) ? H5RI.H5Rdereference(fileId, Long.parseLong(path.substring(1))) : H5D.H5Dopen(fileId, path, HDF5Constants.H5P_DEFAULT);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5D.H5Dclose(dataSetId);
            }
        });
        long[] oldDimensions = this.getDataDimensions(dataSetId, registry);
        if (Arrays.equals(oldDimensions, dimensions)) return dataSetId;
        HDF5StorageLayout layout = this.getLayout(dataSetId, registry);
        if (layout == HDF5StorageLayout.CHUNKED) {
            if (!this.areDimensionsInBounds(dataSetId, dimensions, registry)) throw new HDF5JavaException("New data set dimensions are out of bounds.");
            long[] newDimensions = this.computeNewDimensions(oldDimensions, dimensions, overwriteMode);
            this.setDataSetExtentChunked(dataSetId, newDimensions);
            return dataSetId;
        } else {
            if (overwriteMode) {
                throw new HDF5JavaException("Cannot change dimensions on non-extendable data set.");
            }
            int dataTypeId = this.getDataTypeForDataSet(dataSetId, registry);
            if (this.getClassType(dataTypeId) == HDF5Constants.H5T_ARRAY) {
                throw new HDF5JavaException("Cannot partially overwrite array type.");
            }
            if (HDF5Utils.isInBounds(oldDimensions, dimensions)) return dataSetId;
            throw new HDF5JavaException("New data set dimensions are out of bounds.");
        }
    }

    private long[] computeNewDimensions(long[] oldDimensions, long[] newDimensions, boolean cutDownExtendIfNecessary) {
        if (cutDownExtendIfNecessary) {
            return newDimensions;
        }
        long[] newUncutDimensions = new long[oldDimensions.length];
        int i = 0;
        while (i < newUncutDimensions.length) {
            newUncutDimensions[i] = Math.max(oldDimensions[i], newDimensions[i]);
            ++i;
        }
        return newUncutDimensions;
    }

    private boolean areDimensionsInBounds(int dataSetId, long[] dimensions, ICleanUpRegistry registry) {
        long[] maxDimensions = this.getDataMaxDimensions(dataSetId, registry);
        if (dimensions.length != maxDimensions.length) {
            return false;
        }
        int i = 0;
        while (i < dimensions.length) {
            if (maxDimensions[i] != (long)HDF5Constants.H5S_UNLIMITED && dimensions[i] > maxDimensions[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setDataSetExtentChunked(int dataSetId, long[] dimensions) {
        assert (dataSetId >= 0);
        assert (dimensions != null);
        H5D.H5Dset_extent(dataSetId, dimensions);
    }

    public void readDataSetNonNumeric(int dataSetId, int nativeDataTypeId, byte[] data) {
        H5D.H5Dread(dataSetId, nativeDataTypeId, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data);
    }

    public void readDataSetNonNumeric(int dataSetId, int nativeDataTypeId, int memorySpaceId, int fileSpaceId, byte[] data) {
        H5D.H5Dread(dataSetId, nativeDataTypeId, memorySpaceId, fileSpaceId, HDF5Constants.H5P_DEFAULT, data);
    }

    public void readDataSetString(int dataSetId, int nativeDataTypeId, String[] data) {
        H5D.H5Dread_string(dataSetId, nativeDataTypeId, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data);
    }

    public void readDataSetString(int dataSetId, int nativeDataTypeId, int memorySpaceId, int fileSpaceId, String[] data) {
        H5D.H5Dread_string(dataSetId, nativeDataTypeId, memorySpaceId, fileSpaceId, HDF5Constants.H5P_DEFAULT, data);
    }

    public void readDataSet(int dataSetId, int nativeDataTypeId, byte[] data) {
        H5D.H5Dread(dataSetId, nativeDataTypeId, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, this.numericConversionXferPropertyListID, data);
    }

    public void readDataSet(int dataSetId, int nativeDataTypeId, short[] data) {
        H5D.H5Dread(dataSetId, nativeDataTypeId, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, this.numericConversionXferPropertyListID, data);
    }

    public void readDataSet(int dataSetId, int nativeDataTypeId, int[] data) {
        H5D.H5Dread(dataSetId, nativeDataTypeId, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, this.numericConversionXferPropertyListID, data);
    }

    public void readDataSet(int dataSetId, int nativeDataTypeId, long[] data) {
        H5D.H5Dread(dataSetId, nativeDataTypeId, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, this.numericConversionXferPropertyListID, data);
    }

    public void readDataSet(int dataSetId, int nativeDataTypeId, float[] data) {
        H5D.H5Dread(dataSetId, nativeDataTypeId, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, this.numericConversionXferPropertyListID, data);
    }

    public void readDataSet(int dataSetId, int nativeDataTypeId, double[] data) {
        H5D.H5Dread(dataSetId, nativeDataTypeId, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, this.numericConversionXferPropertyListID, data);
    }

    public void readDataSet(int dataSetId, int nativeDataTypeId, int memorySpaceId, int fileSpaceId, byte[] data) {
        H5D.H5Dread(dataSetId, nativeDataTypeId, memorySpaceId, fileSpaceId, this.numericConversionXferPropertyListID, data);
    }

    public void readDataSet(int dataSetId, int nativeDataTypeId, int memorySpaceId, int fileSpaceId, short[] data) {
        H5D.H5Dread(dataSetId, nativeDataTypeId, memorySpaceId, fileSpaceId, this.numericConversionXferPropertyListID, data);
    }

    public void readDataSet(int dataSetId, int nativeDataTypeId, int memorySpaceId, int fileSpaceId, int[] data) {
        H5D.H5Dread(dataSetId, nativeDataTypeId, memorySpaceId, fileSpaceId, this.numericConversionXferPropertyListID, data);
    }

    public void readDataSet(int dataSetId, int nativeDataTypeId, int memorySpaceId, int fileSpaceId, long[] data) {
        H5D.H5Dread(dataSetId, nativeDataTypeId, memorySpaceId, fileSpaceId, this.numericConversionXferPropertyListID, data);
    }

    public void readDataSet(int dataSetId, int nativeDataTypeId, int memorySpaceId, int fileSpaceId, float[] data) {
        H5D.H5Dread(dataSetId, nativeDataTypeId, memorySpaceId, fileSpaceId, this.numericConversionXferPropertyListID, data);
    }

    public void readDataSet(int dataSetId, int nativeDataTypeId, int memorySpaceId, int fileSpaceId, double[] data) {
        H5D.H5Dread(dataSetId, nativeDataTypeId, memorySpaceId, fileSpaceId, this.numericConversionXferPropertyListID, data);
    }

    public void readDataSetVL(int dataSetId, int dataTypeId, String[] data) {
        H5D.H5DreadVL(dataSetId, dataTypeId, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data);
        this.replaceNullWithEmptyString(data);
    }

    public void readDataSetVL(int dataSetId, int dataTypeId, int memorySpaceId, int fileSpaceId, String[] data) {
        H5D.H5DreadVL(dataSetId, dataTypeId, memorySpaceId, fileSpaceId, HDF5Constants.H5P_DEFAULT, data);
        this.replaceNullWithEmptyString(data);
    }

    private void replaceNullWithEmptyString(String[] data) {
        int i = 0;
        while (i < data.length) {
            if (data[i] == null) {
                data[i] = "";
            }
            ++i;
        }
    }

    public int createAttribute(int locationId, String attributeName, int dataTypeId, int dataSpaceIdOrMinusOne, ICleanUpRegistry registry) {
        int attCreationPlistId;
        int dataSpaceId;
        HDF5.checkMaxLength(attributeName);
        int n = dataSpaceId = dataSpaceIdOrMinusOne == -1 ? H5S.H5Screate(HDF5Constants.H5S_SCALAR) : dataSpaceIdOrMinusOne;
        if (dataSpaceIdOrMinusOne == -1) {
            registry.registerCleanUp(new Runnable(){

                @Override
                public void run() {
                    H5S.H5Sclose(dataSpaceId);
                }
            });
        }
        if (this.useUTF8CharEncoding) {
            attCreationPlistId = H5P.H5Pcreate(HDF5Constants.H5P_ATTRIBUTE_CREATE);
            this.setCharacterEncodingCreationPropertyList(attCreationPlistId, CharacterEncoding.UTF8);
        } else {
            attCreationPlistId = HDF5Constants.H5P_DEFAULT;
        }
        final int attributeId = H5A.H5Acreate(locationId, attributeName, dataTypeId, dataSpaceId, attCreationPlistId, HDF5Constants.H5P_DEFAULT);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5A.H5Aclose(attributeId);
            }
        });
        return attributeId;
    }

    public int deleteAttribute(int locationId, String attributeName) {
        HDF5.checkMaxLength(attributeName);
        int success = H5A.H5Adelete(locationId, attributeName);
        return success;
    }

    public int openAttribute(int locationId, String attributeName, ICleanUpRegistry registry) {
        HDF5.checkMaxLength(attributeName);
        final int attributeId = H5A.H5Aopen_name(locationId, attributeName);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5A.H5Aclose(attributeId);
            }
        });
        return attributeId;
    }

    public List<String> getAttributeNames(int locationId, ICleanUpRegistry registry) {
        int numberOfAttributes = H5A.H5Aget_num_attrs(locationId);
        LinkedList<String> attributeNames = new LinkedList<String>();
        int i = 0;
        while (i < numberOfAttributes) {
            final int attributeId = H5A.H5Aopen_idx(locationId, i);
            registry.registerCleanUp(new Runnable(){

                @Override
                public void run() {
                    H5A.H5Aclose(attributeId);
                }
            });
            String[] nameContainer = new String[1];
            long nameLength = H5A.H5Aget_name(attributeId, 0L, null);
            long nameLengthRead = H5A.H5Aget_name(attributeId, nameLength + 1L, nameContainer);
            if (nameLengthRead != nameLength) {
                throw new HDF5JavaException(String.format("Error reading attribute name [wrong name length when reading attribute %d, expected: %d, found: %d]", i, nameLength, nameLengthRead));
            }
            attributeNames.add(nameContainer[0]);
            ++i;
        }
        return attributeNames;
    }

    public byte[] readAttributeAsByteArray(int attributeId, int dataTypeId, int length) {
        byte[] data = new byte[length];
        H5A.H5Aread(attributeId, dataTypeId, data);
        return data;
    }

    public short[] readAttributeAsShortArray(int attributeId, int dataTypeId, int length) {
        short[] data = new short[length];
        H5A.H5Aread(attributeId, dataTypeId, data);
        return data;
    }

    public int[] readAttributeAsIntArray(int attributeId, int dataTypeId, int length) {
        int[] data = new int[length];
        H5A.H5Aread(attributeId, dataTypeId, data);
        return data;
    }

    public long[] readAttributeAsLongArray(int attributeId, int dataTypeId, int length) {
        long[] data = new long[length];
        H5A.H5Aread(attributeId, dataTypeId, data);
        return data;
    }

    public float[] readAttributeAsFloatArray(int attributeId, int dataTypeId, int length) {
        float[] data = new float[length];
        H5A.H5Aread(attributeId, dataTypeId, data);
        return data;
    }

    public double[] readAttributeAsDoubleArray(int attributeId, int dataTypeId, int length) {
        double[] data = new double[length];
        H5A.H5Aread(attributeId, dataTypeId, data);
        return data;
    }

    public void readAttributeVL(int attributeId, int dataTypeId, String[] data) {
        H5A.H5AreadVL(attributeId, dataTypeId, data);
    }

    public void writeAttribute(int attributeId, int dataTypeId, byte[] value) {
        H5A.H5Awrite(attributeId, dataTypeId, value);
    }

    public void writeAttribute(int attributeId, int dataTypeId, short[] value) {
        H5A.H5Awrite(attributeId, dataTypeId, value);
    }

    public void writeAttribute(int attributeId, int dataTypeId, int[] value) {
        H5A.H5Awrite(attributeId, dataTypeId, value);
    }

    public void writeAttribute(int attributeId, int dataTypeId, long[] value) {
        H5A.H5Awrite(attributeId, dataTypeId, value);
    }

    public void writeAttribute(int attributeId, int dataTypeId, float[] value) {
        H5A.H5Awrite(attributeId, dataTypeId, value);
    }

    public void writeAttribute(int attributeId, int dataTypeId, double[] value) {
        H5A.H5Awrite(attributeId, dataTypeId, value);
    }

    public void writeAttributeStringVL(int attributeId, int dataTypeId, String[] value) {
        H5A.H5AwriteString(attributeId, dataTypeId, value);
    }

    public int copyDataType(int dataTypeId, ICleanUpRegistry registry) {
        final int copiedDataTypeId = H5T.H5Tcopy(dataTypeId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5T.H5Tclose(copiedDataTypeId);
            }
        });
        return copiedDataTypeId;
    }

    public int createDataTypeVariableString(ICleanUpRegistry registry) {
        final int dataTypeId = this.createDataTypeStringVariableLength();
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5T.H5Tclose(dataTypeId);
            }
        });
        if (this.useUTF8CharEncoding) {
            this.setCharacterEncodingDataType(dataTypeId, CharacterEncoding.UTF8);
        }
        return dataTypeId;
    }

    private int createDataTypeStringVariableLength() {
        int dataTypeId = H5T.H5Tcopy(HDF5Constants.H5T_C_S1);
        H5T.H5Tset_size(dataTypeId, HDF5Constants.H5T_VARIABLE);
        return dataTypeId;
    }

    public int createDataTypeString(int length, ICleanUpRegistry registry) {
        assert (length > 0);
        final int dataTypeId = H5T.H5Tcopy(HDF5Constants.H5T_C_S1);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5T.H5Tclose(dataTypeId);
            }
        });
        H5T.H5Tset_size(dataTypeId, length);
        H5T.H5Tset_strpad(dataTypeId, HDF5Constants.H5T_STR_NULLPAD);
        if (this.useUTF8CharEncoding) {
            this.setCharacterEncodingDataType(dataTypeId, CharacterEncoding.UTF8);
        }
        return dataTypeId;
    }

    private void setCharacterEncodingDataType(int dataTypeId, CharacterEncoding encoding) {
        H5T.H5Tset_cset(dataTypeId, encoding.getCValue());
    }

    public int createArrayType(int baseTypeId, int length, ICleanUpRegistry registry) {
        final int dataTypeId = H5T.H5Tarray_create(baseTypeId, 1, new int[]{length});
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5T.H5Tclose(dataTypeId);
            }
        });
        return dataTypeId;
    }

    public int createArrayType(int baseTypeId, int[] dimensions, ICleanUpRegistry registry) {
        final int dataTypeId = H5T.H5Tarray_create(baseTypeId, dimensions.length, dimensions);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5T.H5Tclose(dataTypeId);
            }
        });
        return dataTypeId;
    }

    public int createDataTypeEnum(String[] names, ICleanUpRegistry registry) {
        int baseDataTypeId;
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            HDF5.checkMaxLength(name);
            ++n2;
        }
        EnumSize size = names.length < 127 ? EnumSize.BYTE8 : (names.length < Short.MAX_VALUE ? EnumSize.SHORT16 : EnumSize.INT32);
        switch (size) {
            case BYTE8: {
                baseDataTypeId = HDF5Constants.H5T_STD_I8LE;
                break;
            }
            case SHORT16: {
                baseDataTypeId = HDF5Constants.H5T_STD_I16LE;
                break;
            }
            case INT32: {
                baseDataTypeId = HDF5Constants.H5T_STD_I32LE;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        final int dataTypeId = H5T.H5Tenum_create(baseDataTypeId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5T.H5Tclose(dataTypeId);
            }
        });
        switch (size) {
            case BYTE8: {
                byte i = 0;
                while (i < names.length) {
                    this.insertMemberEnum(dataTypeId, names[i], i);
                    i = (byte)(i + 1);
                }
                break;
            }
            case SHORT16: {
                Object[] values = this.getLittleEndianSuccessiveShortValues(names);
                int i = 0;
                while (i < names.length) {
                    this.insertMemberEnum(dataTypeId, names[i], values[i]);
                    i = (short)(i + 1);
                }
                break;
            }
            case INT32: {
                Object[] values = this.getLittleEndianSuccessiveIntValues(names);
                int i = 0;
                while (i < names.length) {
                    this.insertMemberEnum(dataTypeId, names[i], (int)values[i]);
                    ++i;
                }
                break;
            }
        }
        return dataTypeId;
    }

    private short[] getLittleEndianSuccessiveShortValues(String[] names) {
        short[] values = new short[names.length];
        int i = 0;
        while (i < names.length) {
            values[i] = i;
            i = (short)(i + 1);
        }
        H5T.H5Tconvert_to_little_endian(values);
        return values;
    }

    private int[] getLittleEndianSuccessiveIntValues(String[] names) {
        int[] values = new int[names.length];
        int i = 0;
        while (i < names.length) {
            values[i] = i;
            ++i;
        }
        H5T.H5Tconvert_to_little_endian(values);
        return values;
    }

    private void insertMemberEnum(int dataTypeId, String name, byte value) {
        assert (dataTypeId >= 0);
        assert (name != null);
        H5T.H5Tenum_insert(dataTypeId, name, value);
    }

    private void insertMemberEnum(int dataTypeId, String name, short value) {
        assert (dataTypeId >= 0);
        assert (name != null);
        H5T.H5Tenum_insert(dataTypeId, name, value);
    }

    private void insertMemberEnum(int dataTypeId, String name, int value) {
        assert (dataTypeId >= 0);
        assert (name != null);
        H5T.H5Tenum_insert(dataTypeId, name, value);
    }

    public int getNumberOfMembers(int dataTypeId) {
        return H5T.H5Tget_nmembers(dataTypeId);
    }

    public String getNameForEnumOrCompoundMemberIndex(int dataTypeId, int index) {
        return H5T.H5Tget_member_name(dataTypeId, index);
    }

    public int getOffsetForCompoundMemberIndex(int dataTypeId, int index) {
        return (int)H5T.H5Tget_member_offset(dataTypeId, index);
    }

    public String[] getNamesForEnumOrCompoundMembers(int dataTypeId) {
        int len = this.getNumberOfMembers(dataTypeId);
        String[] values = new String[len];
        int i = 0;
        while (i < len) {
            values[i] = H5T.H5Tget_member_name(dataTypeId, i);
            ++i;
        }
        return values;
    }

    public int getIndexForMemberName(int dataTypeId, String name) {
        HDF5.checkMaxLength(name);
        return H5T.H5Tget_member_index(dataTypeId, name);
    }

    public int getDataTypeForIndex(int compoundDataTypeId, int index, ICleanUpRegistry registry) {
        final int memberTypeId = H5T.H5Tget_member_type(compoundDataTypeId, index);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5T.H5Tclose(memberTypeId);
            }
        });
        return memberTypeId;
    }

    public int getDataTypeForMemberName(int compoundDataTypeId, String memberName) {
        HDF5.checkMaxLength(memberName);
        int index = H5T.H5Tget_member_index(compoundDataTypeId, memberName);
        return H5T.H5Tget_member_type(compoundDataTypeId, index);
    }

    public Boolean tryGetBooleanValue(int dataTypeId, int intValue) {
        if (this.getClassType(dataTypeId) != HDF5Constants.H5T_ENUM) {
            return null;
        }
        String value = this.getNameForEnumOrCompoundMemberIndex(dataTypeId, intValue);
        if ("TRUE".equalsIgnoreCase(value)) {
            return true;
        }
        if ("FALSE".equalsIgnoreCase(value)) {
            return false;
        }
        return null;
    }

    public int createDataTypeCompound(int lengthInBytes, ICleanUpRegistry registry) {
        final int dataTypeId = H5T.H5Tcreate(HDF5Constants.H5T_COMPOUND, lengthInBytes);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5T.H5Tclose(dataTypeId);
            }
        });
        return dataTypeId;
    }

    public int createDataTypeOpaque(int lengthInBytes, String tag, ICleanUpRegistry registry) {
        HDF5.checkMaxLength(tag);
        final int dataTypeId = H5T.H5Tcreate(HDF5Constants.H5T_OPAQUE, lengthInBytes);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5T.H5Tclose(dataTypeId);
            }
        });
        H5T.H5Tset_tag(dataTypeId, tag.length() > HDF5Constants.H5T_OPAQUE_TAG_MAX ? tag.substring(0, HDF5Constants.H5T_OPAQUE_TAG_MAX) : tag);
        return dataTypeId;
    }

    public void commitDataType(int fileId, String name, int dataTypeId) {
        HDF5.checkMaxLength(name);
        H5T.H5Tcommit(fileId, name, dataTypeId, this.lcplCreateIntermediateGroups, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
    }

    public int openDataType(int fileId, String name, ICleanUpRegistry registry) {
        HDF5.checkMaxLength(name);
        final int dataTypeId = this.isReference(name) ? H5RI.H5Rdereference(fileId, Long.parseLong(name.substring(1))) : H5T.H5Topen(fileId, name, HDF5Constants.H5P_DEFAULT);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5T.H5Tclose(dataTypeId);
            }
        });
        return dataTypeId;
    }

    public boolean dataTypesAreEqual(int dataTypeId1, int dataTypeId2) {
        return H5T.H5Tequal(dataTypeId1, dataTypeId2);
    }

    public int getDataTypeForDataSet(int dataSetId, ICleanUpRegistry registry) {
        final int dataTypeId = H5D.H5Dget_type(dataSetId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5T.H5Tclose(dataTypeId);
            }
        });
        return dataTypeId;
    }

    public int getDataTypeForAttribute(int attributeId, ICleanUpRegistry registry) {
        final int dataTypeId = H5A.H5Aget_type(attributeId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5T.H5Tclose(dataTypeId);
            }
        });
        return dataTypeId;
    }

    public String tryGetOpaqueTag(int dataTypeId) {
        return H5T.H5Tget_tag(dataTypeId);
    }

    public int getNativeDataType(int dataTypeId, ICleanUpRegistry registry) {
        final int nativeDataTypeId = H5T.H5Tget_native_type(dataTypeId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5T.H5Tclose(nativeDataTypeId);
            }
        });
        return nativeDataTypeId;
    }

    public int getNativeDataTypeForDataSet(int dataSetId, ICleanUpRegistry registry) {
        final int dataTypeId = H5D.H5Dget_type(dataSetId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5T.H5Tclose(dataTypeId);
            }
        });
        return this.getNativeDataType(dataTypeId, registry);
    }

    public int getNativeDataTypeForAttribute(int attributeId, ICleanUpRegistry registry) {
        final int dataTypeId = H5A.H5Aget_type(attributeId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5T.H5Tclose(dataTypeId);
            }
        });
        return this.getNativeDataType(dataTypeId, registry);
    }

    public int getDataTypeSize(int dataTypeId) {
        return H5T.H5Tget_size(dataTypeId);
    }

    public long getDataTypeSizeLong(int dataTypeId) throws HDF5JavaException {
        return H5T.H5Tget_size_long(dataTypeId);
    }

    public boolean isVariableLengthString(int dataTypeId) {
        return H5T.H5Tis_variable_str(dataTypeId);
    }

    public int getClassType(int dataTypeId) {
        return H5T.H5Tget_class(dataTypeId);
    }

    public CharacterEncoding getCharacterEncoding(int dataTypeId) {
        int cValue = H5T.H5Tget_cset(dataTypeId);
        if (cValue == CharacterEncoding.ASCII.getCValue()) {
            return CharacterEncoding.ASCII;
        }
        if (cValue == CharacterEncoding.UTF8.getCValue()) {
            return CharacterEncoding.UTF8;
        }
        throw new HDF5JavaException("Unknown character encoding cValue " + cValue);
    }

    public boolean hasClassType(int dataTypeId, int classTypeId) {
        return H5T.H5Tdetect_class(dataTypeId, classTypeId);
    }

    public int getBaseDataType(int dataTypeId, ICleanUpRegistry registry) {
        final int baseDataTypeId = H5T.H5Tget_super(dataTypeId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5T.H5Tclose(baseDataTypeId);
            }
        });
        return baseDataTypeId;
    }

    public boolean getSigned(int dataTypeId) {
        return H5T.H5Tget_sign(dataTypeId) != HDF5Constants.H5T_SGN_NONE;
    }

    public String tryGetDataTypePath(int dataTypeId) {
        if (dataTypeId < 0 || !H5T.H5Tcommitted(dataTypeId)) {
            return null;
        }
        String[] result = new String[1];
        long len = H5RI.H5Iget_name(dataTypeId, result, 64L);
        if (len >= (long)result[0].length()) {
            H5RI.H5Iget_name(dataTypeId, result, len + 1L);
        }
        return result[0];
    }

    public void reclaimCompoundVL(HDF5CompoundType<?> type, byte[] buf) {
        int[] vlMemberIndices = type.getObjectByteifyer().getVLMemberIndices();
        if (vlMemberIndices.length > 0) {
            HDFNativeData.freeCompoundVLStr(buf, type.getRecordSizeInMemory(), vlMemberIndices);
        }
    }

    public int getDataSpaceForDataSet(int dataSetId, ICleanUpRegistry registry) {
        final int dataTypeId = H5D.H5Dget_space(dataSetId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5S.H5Sclose(dataTypeId);
            }
        });
        return dataTypeId;
    }

    public long[] getDataDimensionsForAttribute(int attributeId, ICleanUpRegistry registry) {
        final int dataSpaceId = H5A.H5Aget_space(attributeId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5S.H5Sclose(dataSpaceId);
            }
        });
        long[] dimensions = this.getDataSpaceDimensions(dataSpaceId);
        return dimensions;
    }

    public long[] getDataDimensions(int dataSetId, ICleanUpRegistry registry) {
        final int dataSpaceId = H5D.H5Dget_space(dataSetId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5S.H5Sclose(dataSpaceId);
            }
        });
        long[] dimensions = this.getDataSpaceDimensions(dataSpaceId);
        if (HDF5Utils.mightBeEmptyInStorage(dimensions) && this.existsAttribute(dataSetId, "__EMPTY__")) {
            dimensions = new long[dimensions.length];
        }
        return dimensions;
    }

    public long[] getDataMaxDimensions(final int dataSetId) {
        ICallableWithCleanUp<long[]> dataDimensionRunnable = new ICallableWithCleanUp<long[]>(){

            @Override
            public long[] call(ICleanUpRegistry registry) {
                return HDF5.this.getDataMaxDimensions(dataSetId, registry);
            }
        };
        return this.runner.call(dataDimensionRunnable);
    }

    private long[] getDataMaxDimensions(int dataSetId, ICleanUpRegistry registry) {
        final int dataSpaceId = H5D.H5Dget_space(dataSetId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5S.H5Sclose(dataSpaceId);
            }
        });
        long[] dimensions = this.getDataSpaceMaxDimensions(dataSpaceId);
        return dimensions;
    }

    public int getDataSpaceRank(int dataSpaceId) {
        return H5S.H5Sget_simple_extent_ndims(dataSpaceId);
    }

    public long[] getDataSpaceDimensions(int dataSpaceId) {
        int rank = H5S.H5Sget_simple_extent_ndims(dataSpaceId);
        return this.getDataSpaceDimensions(dataSpaceId, rank);
    }

    public long[] getDataSpaceDimensions(int dataSpaceId, int rank) {
        assert (dataSpaceId >= 0);
        assert (rank >= 0);
        long[] dimensions = new long[rank];
        H5S.H5Sget_simple_extent_dims(dataSpaceId, dimensions, null);
        return dimensions;
    }

    public long[] getDataSpaceMaxDimensions(int dataSpaceId) {
        int rank = H5S.H5Sget_simple_extent_ndims(dataSpaceId);
        return this.getDataSpaceMaxDimensions(dataSpaceId, rank);
    }

    public long[] getDataSpaceMaxDimensions(int dataSpaceId, int rank) {
        assert (dataSpaceId >= 0);
        assert (rank >= 0);
        long[] maxDimensions = new long[rank];
        H5S.H5Sget_simple_extent_dims(dataSpaceId, null, maxDimensions);
        return maxDimensions;
    }

    public int getRank(int dataSetOrAttributeId, boolean isAttribute, ICleanUpRegistry registry) {
        final int dataSpaceId = isAttribute ? H5A.H5Aget_space(dataSetOrAttributeId) : H5D.H5Dget_space(dataSetOrAttributeId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5S.H5Sclose(dataSpaceId);
            }
        });
        return H5S.H5Sget_simple_extent_ndims(dataSpaceId);
    }

    public long[] getDimensions(int dataSetOrAttributeId, boolean isAttribute, ICleanUpRegistry registry) {
        final int dataSpaceId = isAttribute ? H5A.H5Aget_space(dataSetOrAttributeId) : H5D.H5Dget_space(dataSetOrAttributeId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5S.H5Sclose(dataSpaceId);
            }
        });
        long[] dimensions = new long[HDF5Constants.H5S_MAX_RANK];
        int rank = H5S.H5Sget_simple_extent_dims(dataSpaceId, dimensions, null);
        long[] realDimensions = new long[rank];
        System.arraycopy(dimensions, 0, realDimensions, 0, rank);
        return realDimensions;
    }

    public void fillDataDimensions(int dataSetOrAttributeId, boolean isAttribute, HDF5DataSetInformation dataSetInfo, ICleanUpRegistry registry) {
        final int dataSpaceId = isAttribute ? H5A.H5Aget_space(dataSetOrAttributeId) : H5D.H5Dget_space(dataSetOrAttributeId);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5S.H5Sclose(dataSpaceId);
            }
        });
        long[] dimensions = new long[HDF5Constants.H5S_MAX_RANK];
        long[] maxDimensions = new long[HDF5Constants.H5S_MAX_RANK];
        int rank = H5S.H5Sget_simple_extent_dims(dataSpaceId, dimensions, maxDimensions);
        long[] realDimensions = new long[rank];
        System.arraycopy(dimensions, 0, realDimensions, 0, rank);
        long[] realMaxDimensions = new long[rank];
        System.arraycopy(maxDimensions, 0, realMaxDimensions, 0, rank);
        dataSetInfo.setDimensions(realDimensions);
        dataSetInfo.setMaxDimensions(realMaxDimensions);
        if (!isAttribute) {
            long[] chunkSizes = new long[rank];
            int creationPropertyList = this.getCreationPropertyList(dataSetOrAttributeId, registry);
            HDF5StorageLayout layout = HDF5StorageLayout.fromId(H5P.H5Pget_layout(creationPropertyList));
            dataSetInfo.setStorageLayout(layout);
            if (layout == HDF5StorageLayout.CHUNKED) {
                H5P.H5Pget_chunk(creationPropertyList, rank, chunkSizes);
                dataSetInfo.setChunkSizes(MDAbstractArray.toInt(chunkSizes));
            }
        }
    }

    public int[] getArrayDimensions(int arrayTypeId) {
        int rank = H5T.H5Tget_array_ndims(arrayTypeId);
        int[] dims = new int[rank];
        H5T.H5Tget_array_dims(arrayTypeId, dims);
        return dims;
    }

    public int createScalarDataSpace() {
        return H5S.H5Screate(HDF5Constants.H5S_SCALAR);
    }

    public int createSimpleDataSpace(long[] dimensions, ICleanUpRegistry registry) {
        final int dataSpaceId = H5S.H5Screate_simple(dimensions.length, dimensions, null);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5S.H5Sclose(dataSpaceId);
            }
        });
        return dataSpaceId;
    }

    public void setHyperslabBlock(int dataSpaceId, long[] start, long[] count) {
        assert (dataSpaceId >= 0);
        assert (start != null);
        assert (count != null);
        H5S.H5Sselect_hyperslab(dataSpaceId, HDF5Constants.H5S_SELECT_SET, start, null, count, null);
    }

    private int createLinkCreationPropertyList(boolean createIntermediateGroups, ICleanUpRegistry registry) {
        final int linkCreationPropertyList = H5P.H5Pcreate(HDF5Constants.H5P_LINK_CREATE);
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5P.H5Pclose(linkCreationPropertyList);
            }
        });
        if (createIntermediateGroups) {
            H5P.H5Pset_create_intermediate_group(linkCreationPropertyList, true);
        }
        if (this.useUTF8CharEncoding) {
            this.setCharacterEncodingCreationPropertyList(linkCreationPropertyList, CharacterEncoding.UTF8);
        }
        return linkCreationPropertyList;
    }

    private void setCharacterEncodingCreationPropertyList(int creationPropertyList, CharacterEncoding encoding) {
        H5P.H5Pset_char_encoding(creationPropertyList, encoding.getCValue());
    }

    private int createDataSetXferPropertyListAbortOverflow(ICleanUpRegistry registry) {
        final int datasetXferPropertyList = H5P.H5Pcreate_xfer_abort_overflow();
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5P.H5Pclose(datasetXferPropertyList);
            }
        });
        return datasetXferPropertyList;
    }

    private int createDataSetXferPropertyListAbort(ICleanUpRegistry registry) {
        final int datasetXferPropertyList = H5P.H5Pcreate_xfer_abort();
        registry.registerCleanUp(new Runnable(){

            @Override
            public void run() {
                H5P.H5Pclose(datasetXferPropertyList);
            }
        });
        return datasetXferPropertyList;
    }

    String getReferencedObjectName(int objectId, byte[] reference) {
        return H5RI.H5Rget_name(objectId, HDF5Constants.H5R_OBJECT, reference);
    }

    String getReferencedObjectName(int objectId, long reference) {
        return H5RI.H5Rget_name(objectId, reference);
    }

    String[] getReferencedObjectNames(int objectId, long[] reference) {
        return H5RI.H5Rget_name(objectId, reference);
    }

    String getReferencedObjectName(int objectId, byte[] references, int ofs) {
        byte[] reference = new byte[8];
        System.arraycopy(references, ofs, reference, 0, 8);
        return H5RI.H5Rget_name(objectId, HDF5Constants.H5R_OBJECT, reference);
    }

    byte[] createObjectReference(int fileId, String objectPath) {
        return H5RI.H5Rcreate(fileId, objectPath, HDF5Constants.H5R_OBJECT, -1);
    }

    long[] createObjectReferences(int fileId, String[] objectPaths) {
        return H5RI.H5Rcreate(fileId, objectPaths);
    }

    private static enum EnumSize {
        BYTE8,
        SHORT16,
        INT32;

    }
}

