/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.args4j;

import ch.systemsx.cisd.args4j.Argument;
import ch.systemsx.cisd.args4j.CmdLineException;
import ch.systemsx.cisd.args4j.CmdLineOptionPrinter;
import ch.systemsx.cisd.args4j.CmdLineOptions;
import ch.systemsx.cisd.args4j.CmdLineParameters;
import ch.systemsx.cisd.args4j.ExampleMode;
import ch.systemsx.cisd.args4j.FieldSetter;
import ch.systemsx.cisd.args4j.IllegalAnnotationError;
import ch.systemsx.cisd.args4j.Messages;
import ch.systemsx.cisd.args4j.MethodSetter;
import ch.systemsx.cisd.args4j.MultiValueFieldSetter;
import ch.systemsx.cisd.args4j.Option;
import ch.systemsx.cisd.args4j.spi.OptionHandler;
import ch.systemsx.cisd.args4j.spi.Setter;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdLineParser {
    private final Object bean;
    private final CmdLineOptions options = new CmdLineOptions();
    private final CmdLineOptionPrinter optionPrinter = new CmdLineOptionPrinter(this.options);
    private Setter<String> argumentSetter;

    public CmdLineParser(Object bean) {
        this.bean = bean;
        this.addOptionsForBean();
    }

    private void addOptionsForBean() {
        Class<?> c = this.bean.getClass();
        while (c != null) {
            Argument a;
            Option o;
            AccessibleObject[] accessibleObjectArray = c.getDeclaredMethods();
            int n = accessibleObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = accessibleObjectArray[n2];
                o = m.getAnnotation(Option.class);
                if (o != null) {
                    this.options.addOption(new MethodSetter(this.bean, m), o);
                }
                if ((a = m.getAnnotation(Argument.class)) != null) {
                    this.addArgument(new MethodSetter<String>(this.bean, m));
                }
                ++n2;
            }
            accessibleObjectArray = c.getDeclaredFields();
            n = accessibleObjectArray.length;
            n2 = 0;
            while (n2 < n) {
                AccessibleObject f = accessibleObjectArray[n2];
                o = ((Field)f).getAnnotation(Option.class);
                if (o != null) {
                    this.options.addOption(this.createFieldSetter((Field)f), o);
                }
                if ((a = ((Field)f).getAnnotation(Argument.class)) != null) {
                    this.addArgument(this.createFieldSetter((Field)f));
                }
                ++n2;
            }
            c = c.getSuperclass();
        }
    }

    private Setter createFieldSetter(Field f) {
        if (List.class.isAssignableFrom(f.getType())) {
            return new MultiValueFieldSetter(this.bean, f);
        }
        return new FieldSetter(this.bean, f);
    }

    private void addArgument(Setter<String> setter) {
        if (this.argumentSetter != null) {
            throw new IllegalAnnotationError("@Argument is used more than once");
        }
        this.argumentSetter = setter;
    }

    public void printHelp(String programCall, String genericOptions, String genericArgs, ExampleMode mode) {
        this.optionPrinter.printHelp(programCall, genericOptions, genericArgs, mode);
    }

    public String printExample(ExampleMode mode) {
        return this.optionPrinter.getExampleString(mode);
    }

    public String printExample(ExampleMode mode, ResourceBundle rb) {
        return this.optionPrinter.getExampleString(mode, rb);
    }

    public void printUsage(OutputStream out) {
        this.optionPrinter.printUsage(out);
    }

    public void printUsage(Writer out, ResourceBundle rb) {
        this.optionPrinter.printUsage(out, rb);
    }

    public void parseArgument(String ... args) throws CmdLineException {
        CmdLineParameters cmdLine = new CmdLineParameters(args);
        HashSet<OptionHandler> present = new HashSet<OptionHandler>();
        boolean endOfOptionMarkerFound = false;
        block0: while (cmdLine.hasMore()) {
            String arg = cmdLine.getOptionName();
            if (!endOfOptionMarkerFound && this.isOption(arg)) {
                OptionHandler handler;
                endOfOptionMarkerFound = this.isEndOfOptionMarker(arg);
                if (endOfOptionMarkerFound) {
                    cmdLine.proceed(1);
                    continue;
                }
                int eqIdx = arg.indexOf(61);
                if (eqIdx == -1) {
                    handler = this.options.getHandlerForOption(arg);
                    if (handler != null) {
                        int diff = handler.parseArguments(cmdLine);
                        cmdLine.proceed(diff + 1);
                        present.add(handler);
                        continue;
                    }
                    if (!this.isLongOption(arg)) {
                        int len = arg.length();
                        while (--len > 0) {
                            String optionOnTrial = arg.substring(0, len);
                            handler = this.options.getHandlerForOption(optionOnTrial);
                            if (handler == null) continue;
                            handler.set(arg.substring(len));
                            cmdLine.proceed(1);
                            present.add(handler);
                            continue block0;
                        }
                    }
                } else {
                    handler = this.options.getHandlerForOption(arg.substring(0, eqIdx));
                    if (handler != null) {
                        handler.set(arg.substring(eqIdx + 1));
                        cmdLine.proceed(1);
                        present.add(handler);
                        continue;
                    }
                }
                throw new CmdLineException(Messages.UNDEFINED_OPTION.format(arg));
            }
            if (this.argumentSetter == null) {
                throw new CmdLineException(Messages.NO_ARGUMENT_ALLOWED.format(arg));
            }
            this.argumentSetter.addValue(arg);
            cmdLine.proceed(1);
        }
        this.options.checkRequiredOptionsPresent(present);
    }

    private boolean isOption(String arg) {
        return arg.startsWith("-");
    }

    private boolean isLongOption(String arg) {
        return arg.startsWith("--");
    }

    private boolean isEndOfOptionMarker(String arg) {
        return "--".equals(arg);
    }

    public void setUsageWidth(int usageWidth) {
        this.optionPrinter.setTerminalWidth(usageWidth);
    }
}

