/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.servlet.pcoa;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.text.NumberFormat;
import jhi.flapjack.data.results.PCoAResult;
import jhi.flapjack.data.results.SimMatrix;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.io.SimMatrixExporter;
import jhi.flapjack.servlet.pcoa.PCoAService;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class PCoAClient {
    private final String baseURL = "https://ics.hutton.ac.uk/flapjack-services-20170726/";
    private String taskId;
    private Retrofit retrofit;
    private PCoAService service;
    private final SimMatrix matrix;
    private final String noDimensions;
    private boolean okToRun = true;
    private Thread runnerThread;

    public PCoAClient(SimMatrix matrix, String noDimensions) {
        this.matrix = matrix;
        this.noDimensions = noDimensions;
        this.retrofit = new Retrofit.Builder().baseUrl("https://ics.hutton.ac.uk/flapjack-services-20170726/").addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build();
        this.service = (PCoAService)this.retrofit.create(PCoAService.class);
    }

    public PCoAResult generatePco() throws Exception {
        this.runnerThread = Thread.currentThread();
        this.taskId = this.postSimMatrix();
        if (this.okToRun) {
            String pcoaText;
            Response response = this.service.getPcoa(this.taskId).execute();
            while (this.okToRun && (!response.isSuccessful() || response.isSuccessful() && response.body() == null)) {
                System.out.println("Waiting for result...");
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.okToRun) continue;
                response = this.service.getPcoa(this.taskId).execute();
            }
            if (this.okToRun && response.isSuccessful() && response.body() != null && !(pcoaText = ((ResponseBody)response.body()).string()).isEmpty()) {
                return this.createPcoaFromResponse(pcoaText, this.matrix);
            }
        }
        return null;
    }

    private String postSimMatrix() throws Exception {
        File temp = new File(FlapjackUtils.getCacheDir(), Prefs.flapjackID + ".matrix");
        SimMatrixExporter exporter = new SimMatrixExporter(this.matrix, new PrintWriter(new FileWriter(temp)));
        exporter.runJob(0);
        RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)"multipart/format-data"), (File)temp);
        MultipartBody.Part body = MultipartBody.Part.createFormData((String)"matrix", (String)temp.getName(), (RequestBody)requestFile);
        Response response = this.service.postSimMatrix(body, this.noDimensions, Prefs.flapjackID).execute();
        return ((ResponseBody)response.body()).string();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PCoAResult createPcoaFromResponse(String responseText, SimMatrix matrix) {
        NumberFormat nf = NumberFormat.getInstance();
        try (BufferedReader in = new BufferedReader(new StringReader(responseText));){
            String str;
            PCoAResult result = new PCoAResult(matrix.getLineInfos());
            while ((str = in.readLine()) != null && str.length() > 0) {
                String[] tokens = str.split("\t");
                float[] data = new float[tokens.length - 1];
                for (int i = 1; i < tokens.length; ++i) {
                    data[i - 1] = nf.parse(tokens[i]).floatValue();
                }
                result.addDataRow(data);
            }
            PCoAResult pCoAResult = result;
            return pCoAResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void cancelJob() {
        if (this.runnerThread != null) {
            this.runnerThread.interrupt();
        }
        try {
            this.okToRun = false;
            this.service.cancelJob(this.taskId).execute();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

