/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringJoiner;
import jhi.flapjack.data.ChromosomeMap;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.Marker;
import jhi.flapjack.data.StateTable;
import jhi.flapjack.io.DataFormatException;
import jhi.flapjack.io.IGenotypeImporter;
import jhi.flapjack.io.MarkerIndex;
import scri.commons.gui.RB;
import scri.commons.io.ProgressInputStream;

public class GenotypeDataImporter
implements IGenotypeImporter {
    private ProgressInputStream is;
    private File file;
    private DataSet dataSet;
    private StateTable stateTable;
    private HashMap<String, MarkerIndex> markers;
    private HashMap<String, ArrayList<Line>> linesByName;
    private HashMap<String, Integer> states = new HashMap();
    private String ioMissingData;
    private String ioHeteroSeparator;
    private long lineCount = 0L;
    private long markerCount;
    private boolean useByteStorage = true;
    private boolean isOK = true;
    private boolean isTransposed;
    private boolean allowDuplicates;
    private NumberFormat nf = NumberFormat.getInstance();
    private boolean mapWasProvided;
    private boolean fakeMapCreated;
    private ArrayList<String> pedigrees = new ArrayList();

    public GenotypeDataImporter(File file, DataSet dataSet, HashMap<String, MarkerIndex> markers, String ioMissingData, String ioHeteroSeparator, boolean isTransposed, boolean allowDuplicates) {
        this.file = file;
        this.dataSet = dataSet;
        this.markers = markers;
        this.ioMissingData = ioMissingData;
        this.ioHeteroSeparator = ioHeteroSeparator;
        this.isTransposed = isTransposed;
        this.allowDuplicates = allowDuplicates;
        this.stateTable = dataSet.getStateTable();
        this.mapWasProvided = markers.size() > 0;
    }

    @Override
    public void cleanUp() {
        this.markers.clear();
        this.linesByName.clear();
    }

    @Override
    public void cancelImport() {
        this.isOK = false;
    }

    @Override
    public long getLineCount() {
        return this.dataSet.getLines().size();
    }

    @Override
    public long getMarkerCount() {
        return this.markerCount;
    }

    @Override
    public void importGenotypeData() throws IOException, DataFormatException {
        if (!this.readData(this.isTransposed)) {
            this.dataSet.getLines().clear();
            this.stateTable.resetTable();
            this.states.clear();
            this.useByteStorage = false;
            this.lineCount = 0L;
            this.readData(this.isTransposed);
        }
    }

    private boolean readData(boolean isTransposed) throws IOException, DataFormatException {
        boolean completed = isTransposed ? this.readTransposedData() : this.readNonTransposedData();
        if (this.pedigrees.size() > 0) {
            this.dataSet.getPedManager().create(this.pedigrees, this.linesByName);
        }
        return completed;
    }

    private MarkerIndex queryMarker(String name) {
        if (this.mapWasProvided || this.fakeMapCreated) {
            return this.markers.get(name);
        }
        if (this.markers.get(name) != null) {
            return null;
        }
        int position = this.markers.size();
        Marker marker = new Marker(name, (double)position);
        ChromosomeMap map = this.dataSet.getChromosomeMaps().get(0);
        map.addMarker(marker);
        map.setLength(position);
        MarkerIndex mi = new MarkerIndex(0, this.markers.size());
        this.markers.put(marker.getName(), mi);
        return mi;
    }

    private boolean readNonTransposedData() throws IOException, DataFormatException {
        long s = System.currentTimeMillis();
        this.linesByName = new HashMap();
        this.is = new ProgressInputStream((InputStream)new FileInputStream(this.file));
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)this.is, "UTF-8"));
        String str = in.readLine();
        while (str.length() == 0 || str.startsWith("#")) {
            this.processHeader(str);
            str = in.readLine();
            ++this.lineCount;
        }
        String[] markerNames = str.split("\t");
        int[] mapIndex = new int[markerNames.length];
        int[] mkrIndex = new int[markerNames.length];
        for (int i = 1; i < markerNames.length && this.isOK; ++i) {
            MarkerIndex index = this.queryMarker(markerNames[i].trim());
            if (index != null) {
                mapIndex[i] = index.mapIndex;
                mkrIndex[i] = index.mkrIndex;
                continue;
            }
            mkrIndex[i] = -1;
            mapIndex[i] = -1;
        }
        System.out.println("Map/marker cache created in " + (System.currentTimeMillis() - s) + "ms");
        s = System.currentTimeMillis();
        while ((str = in.readLine()) != null && this.isOK) {
            String[] values;
            if (str.length() == 0) continue;
            if (str.startsWith("#")) {
                this.processHeader(str);
                continue;
            }
            if (++this.lineCount % 100L == 0L) {
                System.out.println("Reading line " + this.lineCount + " (" + (System.currentTimeMillis() - s) + "ms)");
                s = System.currentTimeMillis();
            }
            if ((values = str.split("\t")).length == 0) continue;
            String name = values[0].trim();
            if (this.linesByName.get(name) != null) {
                if (!this.allowDuplicates) {
                    throw new DataFormatException(RB.format((String)"io.DataFormatException.duplicateLineError", (Object[])new Object[]{name, this.lineCount + 1L}));
                }
            } else {
                this.linesByName.put(name, new ArrayList());
            }
            Line line = this.dataSet.createLine(name, this.useByteStorage);
            this.linesByName.get(name).add(line);
            for (int i = 1; i < values.length; ++i) {
                if (mapIndex[i] == -1) continue;
                String rawAlleles = values[i].trim();
                Integer stateCode = this.states.get(rawAlleles);
                if (stateCode == null) {
                    stateCode = this.stateTable.getStateCode(rawAlleles, true, this.ioMissingData, this.ioHeteroSeparator);
                    this.states.put(rawAlleles, stateCode);
                }
                line.setLoci(mapIndex[i], mkrIndex[i], stateCode);
                ++this.markerCount;
            }
            if (!this.useByteStorage || this.stateTable.size() <= 127) continue;
            return false;
        }
        in.close();
        this.markers.clear();
        return true;
    }

    private void processHeader(String str) {
        if (str.indexOf(61) != -1) {
            try {
                String key = str.substring(1, str.indexOf(61)).trim();
                String value = str.substring(str.indexOf(61) + 1).trim();
                if (key.equals("fjDatabaseLineSearch")) {
                    this.dataSet.getDbAssociation().setLineSearch(value);
                }
                if (key.equals("fjDatabaseMarkerSearch")) {
                    this.dataSet.getDbAssociation().setMarkerSearch(value);
                }
                if (key.equals("fjDatabaseGroupPreview")) {
                    this.dataSet.getDbAssociation().setGroupPreview(value);
                }
                if (key.equals("fjDatabaseGroupUpload")) {
                    this.dataSet.getDbAssociation().setGroupUpload(value);
                }
            }
            catch (Exception e) {
                System.out.println("Invalid header: " + str);
            }
        } else if (str.startsWith("# bin")) {
            String[] tokens = str.split("\t");
            int index = Integer.parseInt(tokens[1]);
            try {
                float min = this.nf.parse(tokens[2]).floatValue();
                float max = this.nf.parse(tokens[3]).floatValue();
                this.dataSet.getBinnedData().addBin(index, min, max);
            }
            catch (Exception min) {}
        } else if (str.toLowerCase().startsWith("# fjpedigree")) {
            String[] tokens = str.split("\t");
            if (tokens.length >= 4) {
                for (int i = 3; i < tokens.length; ++i) {
                    StringJoiner ped = new StringJoiner("\t");
                    ped.add(tokens[1]).add(tokens[i]).add(tokens[2]);
                    this.pedigrees.add(ped.toString());
                }
            }
        } else if (str.toLowerCase().startsWith("# fjaltmarkername")) {
            String[] tokens = str.split("\t");
            String orgName = tokens[1];
            String altName = tokens[2];
            this.queryMarker(orgName);
            MarkerIndex mi = this.markers.get(orgName);
            Marker marker = this.dataSet.getChromosomeMaps().get(mi.mapIndex).getMarkerByIndex(mi.mkrIndex);
            this.dataSet.getFavAlleleManager().getAltNames().put(orgName, altName);
        } else if (str.toLowerCase().startsWith("# fjfavallele")) {
            String[] tokens = str.split("\t");
            String markerName = tokens[1];
            this.queryMarker(markerName);
            MarkerIndex mi = this.markers.get(markerName);
            Marker marker = this.dataSet.getChromosomeMaps().get(mi.mapIndex).getMarkerByIndex(mi.mkrIndex);
            int arraySize = tokens.length - 2;
            ArrayList<Integer> alleleIndices = new ArrayList<Integer>();
            for (int i = 2; i < tokens.length; ++i) {
                String rawAlleles = tokens[i].trim();
                Integer stateCode = this.states.get(rawAlleles);
                if (stateCode == null) {
                    stateCode = this.stateTable.getStateCode(rawAlleles, true, this.ioMissingData, this.ioHeteroSeparator);
                    this.states.put(rawAlleles, stateCode);
                }
                alleleIndices.add(stateCode);
            }
            this.dataSet.getFavAlleleManager().addFavAllelesForMarker(marker.getName(), alleleIndices);
        } else if (str.toLowerCase().startsWith("# fjunfavallele")) {
            String[] tokens = str.split("\t");
            String markerName = tokens[1];
            this.queryMarker(markerName);
            MarkerIndex mi = this.markers.get(markerName);
            Marker marker = this.dataSet.getChromosomeMaps().get(mi.mapIndex).getMarkerByIndex(mi.mkrIndex);
            int arraySize = tokens.length - 2;
            ArrayList<Integer> alleleIndices = new ArrayList<Integer>();
            for (int i = 2; i < tokens.length; ++i) {
                String rawAlleles = tokens[i].trim();
                Integer stateCode = this.states.get(rawAlleles);
                if (stateCode == null) {
                    stateCode = this.stateTable.getStateCode(rawAlleles, true, this.ioMissingData, this.ioHeteroSeparator);
                    this.states.put(rawAlleles, stateCode);
                }
                alleleIndices.add(stateCode);
            }
            this.dataSet.getFavAlleleManager().addUnfavAllelesForMarker(marker.getName(), alleleIndices);
        }
    }

    @Override
    public long getBytesRead() {
        return this.is == null ? 0L : this.is.getBytesRead();
    }

    private boolean readTransposedData() throws IOException, DataFormatException {
        long s = System.currentTimeMillis();
        if (!this.mapWasProvided) {
            this.createFakeMapForTransposedData();
        }
        this.linesByName = new HashMap();
        this.is = new ProgressInputStream((InputStream)new FileInputStream(this.file));
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)this.is, "UTF-8"));
        String str = in.readLine();
        while (str.length() == 0 || str.startsWith("#")) {
            this.processHeader(str);
            str = in.readLine();
            ++this.lineCount;
        }
        String[] lineNames = str.split("\t");
        for (int i = 1; i < lineNames.length && this.isOK; ++i) {
            lineNames[i] = lineNames[i].trim();
            if (this.linesByName.get(lineNames[i]) != null) {
                if (!this.allowDuplicates) {
                    throw new DataFormatException(RB.format((String)"io.DataFormatException.duplicateLineError", (Object[])new Object[]{lineNames[i], this.lineCount + 1L}));
                }
            } else {
                this.linesByName.put(lineNames[i], new ArrayList());
            }
            Line line = this.dataSet.createLine(lineNames[i], this.useByteStorage);
            this.linesByName.get(lineNames[i]).add(line);
        }
        while ((str = in.readLine()) != null && this.isOK) {
            String[] values;
            if (str.length() == 0 || str.startsWith("#")) continue;
            if (++this.lineCount % 100L == 0L) {
                System.out.println("Reading line " + this.lineCount + " (" + (System.currentTimeMillis() - s) + "ms)");
                s = System.currentTimeMillis();
            }
            if ((values = str.split("\t")).length == 0) continue;
            for (int i = 1; i < values.length; ++i) {
                MarkerIndex index = this.queryMarker(values[0].trim());
                if (index == null || index.mapIndex == -1) continue;
                String rawAlleles = values[i].trim();
                Integer stateCode = this.states.get(rawAlleles);
                if (stateCode == null) {
                    stateCode = this.stateTable.getStateCode(rawAlleles, true, this.ioMissingData, this.ioHeteroSeparator);
                    this.states.put(rawAlleles, stateCode);
                }
                this.dataSet.getLines().get(i - 1).setLoci(index.mapIndex, index.mkrIndex, stateCode);
                ++this.markerCount;
            }
            if (!this.useByteStorage || this.stateTable.size() <= 127) continue;
            return false;
        }
        in.close();
        this.markers.clear();
        return true;
    }

    private void createFakeMapForTransposedData() throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), "UTF-8"));
        String str = null;
        while ((str = in.readLine()) != null && (str.isEmpty() || str.startsWith("#"))) {
        }
        while ((str = in.readLine()) != null) {
            String[] values;
            if (str.isEmpty() || (values = str.split("\t")).length == 0) continue;
            this.queryMarker(values[0].trim());
        }
        this.fakeMapCreated = true;
        in.close();
    }
}

