/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import jhi.flapjack.data.ChromosomeMap;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.Marker;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.io.DataFormatException;
import jhi.flapjack.io.IMapImporter;
import jhi.flapjack.io.MarkerIndex;
import scri.commons.gui.RB;
import scri.commons.io.ProgressInputStream;

public class ChromosomeMapImporter
implements IMapImporter {
    private ProgressInputStream is;
    private File file;
    private DataSet dataSet;
    private HashMap<String, MarkerIndex> markers = new HashMap();
    private long markerCount = 0L;
    private LinkedList<String> duplicates = new LinkedList();
    private boolean isOK = true;

    public ChromosomeMapImporter(File file, DataSet dataSet) {
        this.file = file;
        this.dataSet = dataSet;
    }

    @Override
    public HashMap<String, MarkerIndex> getMarkersHashMap() {
        return this.markers;
    }

    @Override
    public void cancelImport() {
        this.isOK = false;
    }

    @Override
    public void importMap() throws Exception {
        if (this.file == null) {
            this.dataSet.getMapByName("1", true);
            return;
        }
        this.is = new ProgressInputStream((InputStream)new FileInputStream(this.file));
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)this.is, "UTF-8"));
        NumberFormat nf = NumberFormat.getInstance();
        String str = null;
        int linesRead = 0;
        while ((str = in.readLine()) != null && this.isOK) {
            ++linesRead;
            if (str.isEmpty() || str.startsWith("#")) continue;
            String[] tokens = str.split("\t");
            if (tokens.length < 2 || tokens.length > 3) {
                throw new DataFormatException(RB.format((String)"io.DataFormatException.mapTokenError", (Object[])new Object[]{this.file}));
            }
            if (tokens.length == 2) {
                String name = tokens[0].trim();
                double length = 0.0;
                try {
                    length = nf.parse(tokens[1]).doubleValue();
                }
                catch (Exception e) {
                    throw new DataFormatException(RB.format((String)"io.DataFormatException.parseLengthError", (Object[])new Object[]{this.file, tokens[1], linesRead}));
                }
                ChromosomeMap.Wrapper w = this.dataSet.getMapByName(name, true);
                w.map.setLength(length);
                continue;
            }
            if (tokens.length != 3) continue;
            double position = 0.0;
            try {
                position = nf.parse(tokens[2]).doubleValue();
            }
            catch (Exception e) {
                throw new DataFormatException(RB.format((String)"io.DataFormatException.parseDistanceError", (Object[])new Object[]{this.file, tokens[2], linesRead}));
            }
            Marker marker = new Marker(tokens[0].trim(), position);
            MarkerIndex index = this.markers.get(marker.getName());
            if (index != null) {
                if (!Prefs.warnDuplicateMarkers) continue;
                this.duplicates.add(marker.getName() + "\t" + tokens[1] + "\t" + this.dataSet.getMapByIndex(index.mapIndex).getName());
                continue;
            }
            ChromosomeMap.Wrapper w = this.dataSet.getMapByName(tokens[1], true);
            w.map.addMarker(marker);
            this.markers.put(marker.getName(), new MarkerIndex(w.index, 0));
            ++this.markerCount;
        }
        in.close();
        if (this.isOK) {
            this.dataSet.orderMarkersWithinMaps();
        }
        Collections.sort(this.dataSet.getChromosomeMaps());
        System.out.println("markers.size() = " + this.markers.size());
        int mapIndex = 0;
        for (ChromosomeMap map : this.dataSet.getChromosomeMaps()) {
            int mkrIndex = 0;
            for (Marker marker : map) {
                MarkerIndex mi = this.markers.get(marker.getName());
                mi.mkrIndex = mkrIndex++;
                mi.mapIndex = (short)mapIndex;
            }
            mapIndex = (short)(mapIndex + 1);
        }
        System.out.println("assigned marker indexes");
    }

    @Override
    public LinkedList<String> getDuplicates() {
        return this.duplicates;
    }

    @Override
    public long getBytesRead() {
        return this.is == null ? 0L : this.is.getBytesRead();
    }

    @Override
    public long getMarkerCount() {
        return this.markerCount;
    }
}

