/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization.undo;

import jhi.flapjack.data.GTView;
import jhi.flapjack.data.IUndoState;

public class SelectedLinesState
implements IUndoState {
    private GTView view;
    private String menuStr;
    private boolean[] undoLines;
    private boolean[] redoLines;

    public SelectedLinesState(GTView view) {
        this.view = view;
    }

    public SelectedLinesState(GTView view, String menuStr) {
        this.view = view;
        this.menuStr = menuStr;
    }

    @Override
    public String getMenuString() {
        return this.menuStr;
    }

    public void setMenuString(String menuStr) {
        this.menuStr = menuStr;
    }

    @Override
    public GTView getView() {
        return null;
    }

    @Override
    public void createUndoState() {
        this.undoLines = new boolean[this.view.lineCount()];
        for (int i = 0; i < this.undoLines.length; ++i) {
            this.undoLines[i] = this.view.isLineSelected(i);
        }
    }

    @Override
    public void applyUndoState() {
        for (int i = 0; i < this.undoLines.length; ++i) {
            this.view.setLineState(i, this.undoLines[i]);
        }
    }

    @Override
    public void createRedoState() {
        this.redoLines = new boolean[this.view.lineCount()];
        for (int i = 0; i < this.redoLines.length; ++i) {
            this.redoLines[i] = this.view.isLineSelected(i);
        }
    }

    @Override
    public void applyRedoState() {
        for (int i = 0; i < this.redoLines.length; ++i) {
            this.view.setLineState(i, this.redoLines[i]);
        }
    }
}

