/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization.undo;

import java.util.ArrayList;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.IUndoState;
import jhi.flapjack.data.MarkerInfo;

public class HidMarkersState
implements IUndoState {
    private GTViewSet viewSet;
    private GTView view;
    private String menuStr;
    private ArrayList<MarkerInfo[]> undoVisible;
    private ArrayList<MarkerInfo[]> undoHidden;
    private ArrayList<MarkerInfo[]> redoVisible;
    private ArrayList<MarkerInfo[]> redoHidden;

    public HidMarkersState(GTView view, String menuStr) {
        this.view = view;
        this.viewSet = view.getViewSet();
        this.menuStr = menuStr;
    }

    @Override
    public String getMenuString() {
        return this.menuStr;
    }

    public void setMenuString(String menuStr) {
        this.menuStr = menuStr;
    }

    @Override
    public GTView getView() {
        return this.view;
    }

    @Override
    public void createUndoState() {
        this.undoVisible = new ArrayList(this.viewSet.chromosomeCount());
        this.undoHidden = new ArrayList(this.viewSet.chromosomeCount());
        for (GTView view : this.viewSet.getViews()) {
            this.undoVisible.add(view.getMarkersAsArray(true));
            this.undoHidden.add(view.getMarkersAsArray(false));
        }
    }

    @Override
    public void applyUndoState() {
        for (int i = 0; i < this.viewSet.chromosomeCount(); ++i) {
            GTView view = this.viewSet.getViews().get(i);
            view.setMarkersFromArray(this.undoVisible.get(i), true);
            view.setMarkersFromArray(this.undoHidden.get(i), false);
        }
    }

    @Override
    public void createRedoState() {
        this.redoVisible = new ArrayList(this.viewSet.chromosomeCount());
        this.redoHidden = new ArrayList(this.viewSet.chromosomeCount());
        for (GTView view : this.viewSet.getViews()) {
            this.redoVisible.add(view.getMarkersAsArray(true));
            this.redoHidden.add(view.getMarkersAsArray(false));
        }
    }

    @Override
    public void applyRedoState() {
        for (int i = 0; i < this.viewSet.chromosomeCount(); ++i) {
            GTView view = this.viewSet.getViews().get(i);
            view.setMarkersFromArray(this.redoVisible.get(i), true);
            view.setMarkersFromArray(this.redoHidden.get(i), false);
        }
    }
}

