/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization.colors;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import jhi.flapjack.data.AlleleState;
import jhi.flapjack.data.FavAlleleManager;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.Marker;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.colors.ColorScheme;
import jhi.flapjack.gui.visualization.colors.ColorState;
import jhi.flapjack.gui.visualization.colors.HeterozygeousColorState;
import jhi.flapjack.gui.visualization.colors.SimilarityColorScheme;
import jhi.flapjack.gui.visualization.colors.SimpleColorState;
import scri.commons.gui.RB;

public class FavAlleleColorScheme
extends SimilarityColorScheme {
    private FavAlleleManager fm;

    public FavAlleleColorScheme() {
    }

    public FavAlleleColorScheme(GTView view, int w, int h) {
        super(view, w, h);
        this.het1States.clear();
        Color sHz = Prefs.visColorNucleotideHZ;
        Color s1 = Prefs.visColorHetsAsH;
        for (int i = 0; i < this.stateTable.size(); ++i) {
            AlleleState state = this.stateTable.getAlleleState(i);
            ColorState het1 = state.isUnknown() ? new SimpleColorState(state, Prefs.visColorBackground, w, h) : (state.isHomozygous() ? null : new HeterozygeousColorState(state, sHz, s1, s1, w, h));
            this.het1States.add(het1);
        }
        this.fm = view.getViewSet().getDataSet().getFavAlleleManager();
    }

    protected ColorState getState(int line, int marker) {
        ArrayList<Integer> unfavAlleles;
        int state = this.view.getState(line, marker);
        Marker mkr = this.view.getMarker(marker);
        ArrayList<Integer> favAlleles = this.fm.getFavAlleles().get(mkr.getName());
        if (favAlleles != null) {
            for (int favAllele : favAlleles) {
                if (state != favAllele) continue;
                return (ColorState)this.mtchStatesY.get(state);
            }
        }
        if ((unfavAlleles = this.fm.getUnfavAlleles().get(mkr.getName())) != null) {
            for (int unfavAllele : unfavAlleles) {
                if (state != unfavAllele) continue;
                return (ColorState)this.mtchStatesN.get(state);
            }
        }
        if (favAlleles != null && unfavAlleles != null && this.stateTable.isHet(state)) {
            return (ColorState)this.het1States.get(state);
        }
        return (ColorState)this.gsStates.get(state);
    }

    @Override
    public BufferedImage getSelectedImage(int line, int marker, boolean underQTL) {
        return this.getState(line, marker).getImage(underQTL);
    }

    @Override
    public BufferedImage getUnselectedImage(int line, int marker, boolean underQTL) {
        return this.getState(line, marker).getUnselectedImage(underQTL);
    }

    @Override
    public Color getColor(int line, int marker) {
        return this.getState(line, marker).getColor();
    }

    @Override
    public int getModel() {
        return 16;
    }

    public String toString() {
        return RB.getString((String)"gui.Actions.vizColorFavAllele");
    }

    @Override
    public String getDescription() {
        return RB.getString((String)"gui.visualization.colors.FavAlleleColorScheme");
    }

    @Override
    public ArrayList<ColorScheme.ColorSummary> getColorSummaries() {
        ArrayList<ColorScheme.ColorSummary> colors = new ArrayList<ColorScheme.ColorSummary>();
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorSimStateMatch, "MatchFavAllele"));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorSimStateNoMatch, "MatchUnFavAllele"));
        colors.add(new ColorScheme.ColorSummary(Prefs.visColorSimStateMissing, "NoMatch"));
        return colors;
    }
}

