/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.Trait;
import jhi.flapjack.gui.Prefs;
import scri.commons.gui.RB;
import scri.commons.gui.matisse.HyperLinkLabel;

class SelectTraitsPanelNB
extends JPanel
implements ActionListener {
    private GTViewSet viewSet;
    private int mode;
    private JCheckBox checkTruncate;
    private JScrollPane jScrollPane1;
    private JLabel label;
    private JLabel label2;
    private HyperLinkLabel selectAllLabel;
    private HyperLinkLabel selectNoneLabel;
    private JTable table;

    public SelectTraitsPanelNB(GTViewSet viewSet, int mode) {
        this.initComponents();
        this.setBackground((Color)UIManager.get("fjDialogBG"));
        this.viewSet = viewSet;
        this.mode = mode;
        if (mode == 0) {
            RB.setText((JLabel)this.label, (String)"gui.dialog.NBSelectTraitsPanel.label1");
        } else {
            RB.setText((JLabel)this.label, (String)"gui.dialog.NBSelectTraitsPanel.label2");
        }
        RB.setText((JLabel)this.selectAllLabel, (String)"gui.dialog.NBSelectTraitsPanel.selectAllLabel");
        RB.setText((JLabel)this.selectNoneLabel, (String)"gui.dialog.NBSelectTraitsPanel.selectNoneLabel");
        this.checkTruncate.setVisible(mode == 1);
        this.checkTruncate.setSelected(Prefs.guiTruncateTraits);
        this.createLinkLabels();
        this.createTable(viewSet);
    }

    private void createLinkLabels() {
        this.selectAllLabel.addActionListener((ActionListener)this);
        this.selectNoneLabel.addActionListener((ActionListener)this);
    }

    private void createTable(GTViewSet viewSet) {
        Object[] columnNames = new String[]{RB.getString((String)"gui.dialog.NBSelectTraitsPanel.traitsColumn"), RB.getString((String)"gui.dialog.NBSelectTraitsPanel.experimentColumn"), RB.getString((String)"gui.dialog.NBSelectTraitsPanel.showColumn")};
        ArrayList<Trait> traits = viewSet.getDataSet().getTraits();
        int[] selected = null;
        selected = this.mode == 0 ? viewSet.getTraits() : viewSet.getTxtTraits();
        Object[][] data = new Object[traits.size()][3];
        for (int i = 0; i < data.length; ++i) {
            data[i][0] = traits.get(i).getName();
            data[i][1] = traits.get(i).getExperiment();
            boolean show = false;
            for (int j = 0; j < selected.length; ++j) {
                if (selected[j] != i) continue;
                show = true;
            }
            data[i][2] = show;
        }
        this.table.setModel(new DefaultTableModel(data, columnNames){

            public Class getColumnClass(int c) {
                return this.getValueAt(0, c).getClass();
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 2;
            }
        });
        this.table.getColumnModel().getColumn(2).setPreferredWidth(10);
        TableRowSorter<DefaultTableModel> sorter = new TableRowSorter<DefaultTableModel>((DefaultTableModel)this.table.getModel());
        this.table.setRowSorter(sorter);
    }

    void isOK() {
        boolean[] array = new boolean[this.table.getRowCount()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (Boolean)this.table.getValueAt(i, 2);
        }
        int active = 0;
        for (boolean b : array) {
            if (!b) continue;
            ++active;
        }
        int[] traits = new int[active];
        int j = 0;
        for (int i = 0; i < array.length; ++i) {
            if (!array[i]) continue;
            traits[j++] = i;
        }
        Prefs.guiTruncateTraits = this.checkTruncate.isSelected();
        if (this.mode == 0) {
            this.viewSet.setTraits(traits);
        } else {
            this.viewSet.setTxtTraits(traits);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i;
        if (e.getSource() == this.selectAllLabel) {
            for (i = 0; i < this.table.getRowCount(); ++i) {
                this.table.setValueAt(true, i, 2);
            }
        }
        if (e.getSource() == this.selectNoneLabel) {
            for (i = 0; i < this.table.getRowCount(); ++i) {
                this.table.setValueAt(false, i, 2);
            }
        }
    }

    private void initComponents() {
        this.label = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.label2 = new JLabel();
        this.selectAllLabel = new HyperLinkLabel();
        this.selectNoneLabel = new HyperLinkLabel();
        this.checkTruncate = new JCheckBox();
        this.label.setLabelFor(this.table);
        this.label.setText("The traits heatmap will display any of the following selected traits:");
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.table.setRowSelectionAllowed(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.table);
        this.label2.setText("|");
        this.selectAllLabel.setText("Select all");
        this.selectNoneLabel.setText("Select none");
        this.checkTruncate.setText("Truncate long values, allowing more traits to be displayed on screen at once");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 454, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkTruncate).addComponent(this.label).addGroup(layout.createSequentialGroup().addComponent((Component)this.selectAllLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.label2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.selectNoneLabel, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 153, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label2).addComponent((Component)this.selectAllLabel, -2, -1, -2).addComponent((Component)this.selectNoneLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.checkTruncate).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

