/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class TitlePanel
extends JPanel {
    private String title;
    private static Color labelForeground = (Color)UIManager.get("Label.foreground");
    private static Color panelBackground = (Color)UIManager.get("Panel.background");

    public TitlePanel(String title) {
        this.title = title;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(50, 20);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D g = (Graphics2D)graphics;
        g.setPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, this.getHeight(), panelBackground));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(panelBackground);
        g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setColor(labelForeground);
        int w = this.getWidth();
        int h = this.getHeight();
        Rectangle2D.Float r = (Rectangle2D.Float)g.getFontMetrics().getStringBounds(this.title, g);
        g.drawString(this.title, (int)((float)(w / 2) - r.width / 2.0f), (int)((float)(h / 2) + r.height / 3.0f));
    }
}

