/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.analysis;

import java.util.ArrayList;
import jhi.flapjack.analysis.AnalysisSet;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.data.results.PedVerLinesParentScore;
import jhi.flapjack.data.results.PedVerLinesResult;
import scri.commons.gui.SimpleJob;

public class PedVerLinesAnalysis
extends SimpleJob {
    private GTViewSet viewSet;
    private boolean[] selectedChromosomes;
    private int p1Index;
    private int p2Index;
    private ArrayList<Integer> parentIndices;
    private AnalysisSet as;
    private String name;

    public PedVerLinesAnalysis(GTViewSet viewSet, boolean[] selectedChromosomes, int p1Index, int p2Index, String name) {
        this(viewSet, selectedChromosomes, p1Index, p2Index);
        this.name = name;
    }

    public PedVerLinesAnalysis(GTViewSet viewSet, boolean[] selectedChromosomes, int p1Index, int p2Index) {
        this.viewSet = viewSet.createClone("", true);
        this.p1Index = p1Index;
        this.p2Index = p2Index;
        this.selectedChromosomes = selectedChromosomes;
        this.parentIndices = new ArrayList();
        this.parentIndices.add(p1Index);
        this.parentIndices.add(p2Index);
        this.moveParentsToTop();
    }

    public void runJob(int index) throws Exception {
        this.as = new AnalysisSet(this.viewSet).withViews(this.selectedChromosomes).withSelectedLines().withSelectedMarkers();
        for (int lineIndex = 0; lineIndex < this.as.lineCount(); ++lineIndex) {
            LineInfo lineInfo = this.as.getLine(lineIndex);
            PedVerLinesResult lineStat = new PedVerLinesResult();
            lineInfo.getResults().setPedVerLinesResult(lineStat);
            lineInfo.getResults().setName(this.name);
            int totalCount = 0;
            for (int view = 0; view < this.as.viewCount(); ++view) {
                totalCount += this.as.markerCount(view);
            }
            int missingMarkerCount = this.as.missingMarkerCount(lineIndex);
            int markerCount = totalCount - missingMarkerCount;
            int hetCount = this.as.hetCount(lineIndex);
            ArrayList<PedVerLinesParentScore> parentScores = this.getParentScoresForLine(lineIndex);
            int dataTotalMatch = this.dataTotalMatch(lineIndex);
            int totalMatch = this.totalMatch(lineIndex);
            lineStat.setDataCount(totalCount);
            lineStat.setMissingCount(missingMarkerCount);
            lineStat.setMarkerCount(markerCount);
            lineStat.setPercentMissing((double)missingMarkerCount / (double)totalCount * 100.0);
            lineStat.setHetCount(hetCount);
            lineStat.setPercentHet((double)hetCount / (double)markerCount * 100.0);
            lineStat.setParentScores(parentScores);
            lineStat.setDataTotalMatch(dataTotalMatch);
            lineStat.setTotalMatch(totalMatch);
            lineStat.setPercentTotalMatch((double)totalMatch / (double)dataTotalMatch * 100.0);
        }
        this.prepareForVisualization();
    }

    private void moveParentsToTop() {
        ArrayList<LineInfo> parentLines = new ArrayList<LineInfo>();
        for (Integer parentIndex : this.parentIndices) {
            parentLines.add(this.viewSet.getLines().get(parentIndex));
        }
        parentLines.forEach(line -> line.getResults().setSortToTop(true));
        this.viewSet.getLines().removeAll(parentLines);
        for (int i = 0; i < parentLines.size(); ++i) {
            this.viewSet.getLines().add(i, (LineInfo)parentLines.get(i));
            this.parentIndices.set(i, i);
        }
    }

    private ArrayList<PedVerLinesParentScore> getParentScoresForLine(int lineIndex) {
        ArrayList<PedVerLinesParentScore> parentScores = new ArrayList<PedVerLinesParentScore>();
        for (Integer parent : this.parentIndices) {
            parentScores.add(new PedVerLinesParentScore());
        }
        for (int i = 0; i < parentScores.size(); ++i) {
            PedVerLinesParentScore parentScore = parentScores.get(i);
            int dataCount = 0;
            int matchCount = 0;
            for (int c = 0; c < this.as.viewCount(); ++c) {
                for (int m = 0; m < this.as.markerCount(c); ++m) {
                    int lineState = this.as.getState(c, lineIndex, m);
                    int parentState = this.as.getState(c, this.parentIndices.get(i), m);
                    if (lineState != 0 && parentState != 0) {
                        ++dataCount;
                    }
                    if (lineState != parentState || lineState == 0) continue;
                    ++matchCount;
                }
            }
            parentScore.setDataParentMatch(dataCount);
            parentScore.setMatchParentCount(matchCount);
            parentScore.setMatchParentPercent((double)matchCount / (double)dataCount * 100.0);
        }
        return parentScores;
    }

    private int dataTotalMatch(int lineIndex) {
        int dataTotalMatch = 0;
        for (int c = 0; c < this.as.viewCount(); ++c) {
            for (int m = 0; m < this.as.markerCount(c); ++m) {
                int lineState = this.as.getState(c, lineIndex, m);
                if (lineState == 0 || this.anyParentMissing(c, m)) continue;
                ++dataTotalMatch;
            }
        }
        return dataTotalMatch;
    }

    private int totalMatch(int lineIndex) {
        int totalMatch = 0;
        for (int c = 0; c < this.as.viewCount(); ++c) {
            for (int m = 0; m < this.as.markerCount(c); ++m) {
                int lineState = this.as.getState(c, lineIndex, m);
                if (this.anyParentMissing(c, m) || !this.anyParentMatches(c, m, lineState)) continue;
                ++totalMatch;
            }
        }
        return totalMatch;
    }

    private boolean anyParentMissing(int view, int marker) {
        boolean missing = false;
        for (int i = 0; i < this.parentIndices.size(); ++i) {
            if (this.as.getState(view, i, marker) != 0) continue;
            missing = true;
        }
        return missing;
    }

    private boolean anyParentMatches(int view, int marker, int lineState) {
        boolean matches = false;
        for (Integer parentIndex : this.parentIndices) {
            if (lineState != this.as.getState(view, parentIndex, marker)) continue;
            matches = true;
        }
        return matches;
    }

    private void prepareForVisualization() {
        this.changeColourScheme();
        this.addViewSetToDataSet();
    }

    private void changeColourScheme() {
        this.viewSet.setColorScheme(13);
        this.viewSet.setComparisonLineIndex(this.parentIndices.get(0));
        this.viewSet.setComparisonLine(this.viewSet.getLines().get(0).getLine());
        this.viewSet.setComparisonLineIndex2(this.parentIndices.get(1));
        this.viewSet.setComparisonLine2(this.viewSet.getLines().get(1).getLine());
    }

    private void addViewSetToDataSet() {
        DataSet dataSet = this.viewSet.getDataSet();
        this.viewSet.setName("PedVerLines View");
        dataSet.getViewSets().add(this.viewSet);
    }

    public GTViewSet getViewSet() {
        return this.viewSet;
    }
}

