/*
 * Decompiled with CFR 0.152.
 */
package scri.commons.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import scri.commons.gui.SystemUtils;

public class SwingUtils {
    private static boolean isOSX = SystemUtils.isMacOS();

    public static void addCloseHandler(final Window window, JComponent component) {
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                window.setVisible(false);
            }
        };
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        component.getInputMap(2).put(ks, "close");
        component.getActionMap().put("close", closeAction);
    }

    public static Dimension getVirtualScreenDimension() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle virtualBounds = new Rectangle();
        for (GraphicsDevice gd : ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            virtualBounds = virtualBounds.union(gc.getBounds());
        }
        return new Dimension(virtualBounds.width, virtualBounds.height);
    }

    public static void positionWindow(Window window, Component parent, int x, int y) {
        int scrnW = SwingUtils.getVirtualScreenDimension().width;
        int scrnH = SwingUtils.getVirtualScreenDimension().height;
        if (x == Integer.MIN_VALUE || y == Integer.MIN_VALUE || x > scrnW - 50 || y > scrnH - 50) {
            window.setLocationRelativeTo(parent);
        } else {
            window.setLocation(x, y);
        }
    }

    public static boolean isMetaClick(MouseEvent e) {
        return isOSX && e.isMetaDown() || !isOSX && e.isControlDown();
    }
}

