/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.DecimalFormat;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.io.ImageExporter;
import scri.commons.gui.ITrackableJob;
import scri.commons.gui.ProgressDialog;
import scri.commons.gui.RB;
import scri.commons.gui.TaskDialog;
import scri.commons.gui.matisse.DialogPanel;

public class ExportImageDialog
extends JDialog
implements ActionListener,
ChangeListener {
    private File file = null;
    private DecimalFormat d = new DecimalFormat("0.00");
    private DblClickListener dcl;
    private GenotypePanel gPanel;
    private int lines;
    private int markers;
    private float lineMarkerRatio;
    private SpinnerNumberModel widthModel;
    private SpinnerNumberModel heightModel;
    private JButton bCancel;
    private JButton bExport;
    private JButton bHelp;
    private DialogPanel dialogPanel1;
    private JCheckBox equalCheck;
    private JLabel heightLabel;
    private JSpinner heightSpin;
    private JLabel memLabel1;
    private JLabel memLabel2;
    private JPanel panel;
    private JRadioButton rOverview;
    private JLabel rOverviewLabel;
    private JRadioButton rView;
    private JLabel rViewLabel;
    private JRadioButton rWindow;
    private JLabel rWindowLabel;
    private JSlider slider;
    private JLabel widthLabel;
    private JSpinner widthSpin;

    public ExportImageDialog(GenotypePanel gPanel) {
        super(Flapjack.winMain, RB.getString((String)"gui.dialog.ExportImageDialog.title"), true);
        this.gPanel = gPanel;
        this.dcl = new DblClickListener();
        this.initComponents();
        this.initComponents2();
        FlapjackUtils.initDialog(this, this.bExport, this.bCancel, true, this.getContentPane(), this.panel);
    }

    private void initComponents2() {
        RB.setText((AbstractButton)this.bExport, (String)"gui.dialog.ExportImageDialog.bExport");
        this.bExport.addActionListener(this);
        RB.setText((AbstractButton)this.bCancel, (String)"gui.text.cancel");
        this.bCancel.addActionListener(this);
        RB.setText((AbstractButton)this.bHelp, (String)"gui.text.help");
        FlapjackUtils.setHelp(this.bHelp, "_-_Export_Image");
        this.panel.setBorder(BorderFactory.createTitledBorder(RB.getString((String)"gui.dialog.NBExportImagePanel.title")));
        RB.setText((AbstractButton)this.rWindow, (String)"gui.dialog.NBExportImagePanel.rWindow");
        RB.setText((JLabel)this.rWindowLabel, (String)"gui.dialog.NBExportImagePanel.rWindowLabel");
        RB.setText((AbstractButton)this.rView, (String)"gui.dialog.NBExportImagePanel.rView");
        RB.setText((JLabel)this.rViewLabel, (String)"gui.dialog.NBExportImagePanel.rViewLabel");
        RB.setText((AbstractButton)this.rOverview, (String)"gui.dialog.NBExportImagePanel.rOverview");
        RB.setText((JLabel)this.rOverviewLabel, (String)"gui.dialog.NBExportImagePanel.rOverviewLabel");
        RB.setText((JLabel)this.widthLabel, (String)"gui.dialog.NBExportImagePanel.widthLabel");
        RB.setText((JLabel)this.heightLabel, (String)"gui.dialog.NBExportImagePanel.heightLabel");
        RB.setText((AbstractButton)this.equalCheck, (String)"gui.dialog.NBExportImagePanel.equalCheck");
        RB.setText((JLabel)this.memLabel1, (String)"gui.dialog.NBExportImagePanel.memLabel1");
        this.lines = this.gPanel.getView().lineCount();
        this.markers = this.gPanel.getView().markerCount();
        this.lineMarkerRatio = (float)this.lines / (float)this.markers;
        this.rWindow.addActionListener(this);
        this.rWindow.addMouseListener(this.dcl);
        this.rWindow.setSelected(Prefs.guiExportImageMethod == 0);
        this.rView.addActionListener(this);
        this.rView.addMouseListener(this.dcl);
        this.rView.setSelected(Prefs.guiExportImageMethod == 1);
        this.rOverview.addActionListener(this);
        this.rOverview.addMouseListener(this.dcl);
        this.rOverview.setSelected(Prefs.guiExportImageMethod == 2);
        this.equalCheck.addActionListener(this);
        ButtonGroup bGroup = new ButtonGroup();
        bGroup.add(this.rWindow);
        bGroup.add(this.rView);
        bGroup.add(this.rOverview);
        this.widthModel = new SpinnerNumberModel(this.markers, 1, 5 * this.markers, 1);
        this.widthSpin.setModel(this.widthModel);
        this.widthSpin.addChangeListener(this);
        this.heightModel = new SpinnerNumberModel(this.lines, 1, 5 * this.lines, 1);
        this.heightSpin.setModel(this.heightModel);
        this.heightSpin.addChangeListener(this);
        this.slider.setMinimum(1);
        this.slider.setMaximum(5 * this.markers);
        this.slider.setValue(this.markers);
        this.slider.addChangeListener(this);
        this.setMemoryText();
        this.setCheckBoxState();
        this.setEnabledStates();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bExport && this.isOK() && this.promptForFilename()) {
            this.export();
        } else if (e.getSource() == this.bCancel) {
            this.setVisible(false);
        } else if (e.getSource() == this.equalCheck && this.equalCheck.isSelected()) {
            this.widthModel.setValue(this.markers);
        } else if (e.getSource() instanceof JRadioButton) {
            this.setEnabledStates();
            this.setMemoryText();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.widthSpin.removeChangeListener(this);
        this.heightSpin.removeChangeListener(this);
        this.slider.removeChangeListener(this);
        if (e.getSource() instanceof JSpinner) {
            int w = this.widthModel.getNumber().intValue();
            int h = this.heightModel.getNumber().intValue();
            if (e.getSource() == this.widthSpin) {
                this.heightModel.setValue(Math.round((float)w * this.lineMarkerRatio));
            } else {
                this.widthModel.setValue(Math.round((float)h / this.lineMarkerRatio));
            }
            this.slider.setValue(w);
        } else if (e.getSource() instanceof JSlider) {
            int w = this.slider.getValue();
            this.widthModel.setValue(w);
            this.heightModel.setValue(Math.round((float)w * this.lineMarkerRatio));
        }
        this.widthSpin.addChangeListener(this);
        this.heightSpin.addChangeListener(this);
        this.slider.addChangeListener(this);
        this.setMemoryText();
        this.setCheckBoxState();
    }

    private void export() {
        ImageExporter exporter = new ImageExporter(this.gPanel, this.file);
        ProgressDialog dialog = new ProgressDialog((ITrackableJob)exporter, RB.format((String)"gui.dialog.ExportImageDialog.title", (Object[])new Object[0]), RB.format((String)"gui.dialog.ExportImageDialog.label", (Object[])new Object[0]), (Frame)Flapjack.winMain);
        if (dialog.failed("gui.error")) {
            return;
        }
        TaskDialog.info((String)RB.format((String)"gui.dialog.ExportImageDialog.success", (Object[])new Object[]{this.file}), (String)RB.getString((String)"gui.text.close"));
    }

    private boolean promptForFilename() {
        File basename = new File(Prefs.guiCurrentDir, "Image.png");
        FileNameExtensionFilter filter = new FileNameExtensionFilter(RB.getString((String)"other.Filters.png"), "png");
        String filename = FlapjackUtils.getSaveFilename(RB.getString((String)"gui.dialog.ExportImageDialog.saveDialog"), basename, filter);
        if (filename != null) {
            this.file = new File(filename);
        }
        return this.file != null;
    }

    private void setMemoryText() {
        long memory = 0L;
        if (this.rWindow.isSelected()) {
            memory = this.gPanel.getController().computeCanvasViewPortBufferInBytes();
        } else if (this.rView.isSelected()) {
            memory = this.gPanel.computeCanvasBufferInBytes();
        } else {
            long w = this.widthModel.getNumber().longValue();
            long h = this.heightModel.getNumber().longValue();
            memory = w * h * 3L;
        }
        if ((double)memory < Math.pow(1024.0, 2.0)) {
            this.memLabel2.setText((long)((float)memory / 1024.0f) + " kB");
        } else if ((double)memory < Math.pow(1024.0, 3.0)) {
            this.memLabel2.setText(this.d.format((float)memory / 1024.0f / 1024.0f) + " MB");
        } else {
            this.memLabel2.setText(this.d.format((float)memory / 1024.0f / 1024.0f / 1024.0f) + " GB");
        }
    }

    private void setCheckBoxState() {
        long w = this.slider.getValue();
        this.equalCheck.setSelected(w == (long)this.markers);
    }

    private void setEnabledStates() {
        boolean state = true;
        if (this.rWindow.isSelected() || this.rView.isSelected()) {
            state = false;
        }
        this.widthLabel.setEnabled(state);
        this.widthSpin.setEnabled(state);
        this.heightLabel.setEnabled(state);
        this.heightSpin.setEnabled(state);
        this.slider.setEnabled(state);
        this.equalCheck.setEnabled(state);
    }

    boolean isOK() {
        Prefs.guiExportImageMethod = this.rWindow.isSelected() ? 0 : (this.rView.isSelected() ? 1 : 2);
        Prefs.guiExportImageX = this.widthModel.getNumber().intValue();
        Prefs.guiExportImageY = this.heightModel.getNumber().intValue();
        return true;
    }

    private void initComponents() {
        this.dialogPanel1 = new DialogPanel();
        this.bExport = new JButton();
        this.bCancel = new JButton();
        this.bHelp = new JButton();
        this.panel = new JPanel();
        this.rWindow = new JRadioButton();
        this.rWindowLabel = new JLabel();
        this.rView = new JRadioButton();
        this.rViewLabel = new JLabel();
        this.rOverview = new JRadioButton();
        this.rOverviewLabel = new JLabel();
        this.widthLabel = new JLabel();
        this.widthSpin = new JSpinner();
        this.heightLabel = new JLabel();
        this.heightSpin = new JSpinner();
        this.slider = new JSlider();
        this.equalCheck = new JCheckBox();
        this.memLabel1 = new JLabel();
        this.memLabel2 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.bExport.setText("Export...");
        this.dialogPanel1.add((Component)this.bExport);
        this.bCancel.setText("Cancel");
        this.dialogPanel1.add((Component)this.bCancel);
        this.bHelp.setText("Help");
        this.dialogPanel1.add((Component)this.bHelp);
        this.panel.setBorder(BorderFactory.createTitledBorder("Select a method of exporting:"));
        this.rWindow.setText("Export only what can currently be seen");
        this.rWindowLabel.setText("(creates a high-quality image showing exactly what you currently see)");
        this.rView.setText("Export all of the current view");
        this.rViewLabel.setText("(creates a high-quality image showing everything Flapjack is currently rendering)");
        this.rOverview.setText("Export a scaled-to-fit image of all of the data:");
        this.rOverviewLabel.setText("(creates an overview image using the dimensions specified below)");
        this.widthLabel.setText("Width (pixels):");
        this.heightLabel.setText("Height (pixels):");
        this.equalCheck.setMnemonic('p');
        this.equalCheck.setText("set dimension equal to no. of markers by no. of lines");
        this.memLabel1.setText("Estimated memory required for exporting:");
        this.memLabel2.setText("<memory>");
        GroupLayout panelLayout = new GroupLayout(this.panel);
        this.panel.setLayout(panelLayout);
        panelLayout.setHorizontalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLayout.createSequentialGroup().addContainerGap().addGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rOverview).addComponent(this.rView).addComponent(this.rWindow).addGroup(panelLayout.createSequentialGroup().addComponent(this.memLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.memLabel2)).addGroup(panelLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rViewLabel).addComponent(this.rWindowLabel).addGroup(panelLayout.createSequentialGroup().addComponent(this.widthLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.widthSpin, -2, -1, -2).addGap(18, 18, 18).addComponent(this.heightLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.heightSpin, -2, -1, -2).addGap(18, 18, 18).addComponent(this.slider, -2, 119, -2)).addComponent(this.equalCheck).addComponent(this.rOverviewLabel)))).addContainerGap(-1, Short.MAX_VALUE)));
        panelLayout.setVerticalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLayout.createSequentialGroup().addContainerGap().addComponent(this.rWindow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rWindowLabel).addGap(18, 18, 18).addComponent(this.rView).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rViewLabel).addGap(18, 18, 18).addComponent(this.rOverview).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rOverviewLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.widthLabel).addComponent(this.widthSpin, -2, -1, -2).addComponent(this.heightSpin, -2, -1, -2).addComponent(this.heightLabel).addComponent(this.slider, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.equalCheck).addGap(18, 18, 18).addGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.memLabel2).addComponent(this.memLabel1)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.dialogPanel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.panel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.panel, -1, -1, Short.MAX_VALUE).addGap(4, 4, 4).addComponent((Component)this.dialogPanel1, -2, 44, -2)));
        this.pack();
    }

    private class DblClickListener
    extends MouseAdapter {
        private DblClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() != 2) {
                return;
            }
            ExportImageDialog.this.bExport.doClick();
        }
    }
}

