/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.h5ar;

import ch.systemsx.cisd.hdf5.HDF5GenericStorageFeatures;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class ArchivingStrategy {
    private List<Pattern> fileWhiteListOrNull;
    private List<Pattern> fileBlackListOrNull;
    private List<Pattern> dirWhiteListOrNull;
    private List<Pattern> dirBlackListOrNull;
    private List<Pattern> compressionWhiteListOrNull;
    private List<Pattern> compressionBlackListOrNull;
    private CompressionStrategy compressionStrategy;
    private boolean sealed;
    public static final ArchivingStrategy DEFAULT;
    public static final ArchivingStrategy DEFAULT_WITH_COMPRESSION;
    public static final ArchivingStrategy DEFAULT_NO_COMPRESSION;

    static {
        DEFAULT_WITH_COMPRESSION = DEFAULT = new ArchivingStrategy().addToCompressionBlackList(".*\\.zip").addToCompressionBlackList(".*\\.gz").addToCompressionBlackList(".*\\.bz2").seal();
        DEFAULT_NO_COMPRESSION = new ArchivingStrategy().seal();
    }

    public ArchivingStrategy() {
        this.compressionStrategy = CompressionStrategy.COMPRESS_NOTHING;
    }

    public ArchivingStrategy(ArchivingStrategy template) {
        this.fileWhiteListOrNull = template.fileWhiteListOrNull;
        this.fileBlackListOrNull = template.fileBlackListOrNull;
        this.dirWhiteListOrNull = template.dirWhiteListOrNull;
        this.dirBlackListOrNull = template.dirBlackListOrNull;
        this.compressionStrategy = template.compressionStrategy;
        this.compressionWhiteListOrNull = template.compressionWhiteListOrNull;
        this.compressionBlackListOrNull = template.compressionBlackListOrNull;
    }

    private List<Pattern> getOrCreateFileWhiteList() {
        if (this.fileWhiteListOrNull == null) {
            this.fileWhiteListOrNull = new ArrayList<Pattern>();
        }
        return this.fileWhiteListOrNull;
    }

    private List<Pattern> getOrCreateFileBlackList() {
        if (this.fileBlackListOrNull == null) {
            this.fileBlackListOrNull = new ArrayList<Pattern>();
        }
        return this.fileBlackListOrNull;
    }

    private List<Pattern> getOrCreateDirWhiteList() {
        if (this.dirWhiteListOrNull == null) {
            this.dirWhiteListOrNull = new ArrayList<Pattern>();
        }
        return this.dirWhiteListOrNull;
    }

    private List<Pattern> getOrCreateDirBlackList() {
        if (this.dirBlackListOrNull == null) {
            this.dirBlackListOrNull = new ArrayList<Pattern>();
        }
        return this.dirBlackListOrNull;
    }

    private List<Pattern> getOrCreateCompressionWhiteList() {
        if (this.compressionWhiteListOrNull == null) {
            this.compressionWhiteListOrNull = new ArrayList<Pattern>();
        }
        return this.compressionWhiteListOrNull;
    }

    private List<Pattern> getOrCreateCompressionBlackList() {
        if (this.compressionBlackListOrNull == null) {
            this.compressionBlackListOrNull = new ArrayList<Pattern>();
        }
        return this.compressionBlackListOrNull;
    }

    private void checkSealed() {
        if (this.sealed) {
            throw new IllegalStateException("ArchivingStrategy is sealed.");
        }
    }

    public ArchivingStrategy addToFileWhiteList(Pattern pattern) {
        this.checkSealed();
        this.getOrCreateFileWhiteList().add(pattern);
        return this;
    }

    public ArchivingStrategy addToFileWhiteList(String pattern) {
        this.checkSealed();
        this.getOrCreateFileWhiteList().add(Pattern.compile(pattern));
        return this;
    }

    public ArchivingStrategy addToFileBlackList(Pattern pattern) {
        this.checkSealed();
        this.getOrCreateFileBlackList().add(pattern);
        return this;
    }

    public ArchivingStrategy addToFileBlackList(String pattern) {
        this.checkSealed();
        this.getOrCreateFileBlackList().add(Pattern.compile(pattern));
        return this;
    }

    public ArchivingStrategy addToDirWhiteList(Pattern pattern) {
        this.checkSealed();
        this.getOrCreateDirWhiteList().add(pattern);
        return this;
    }

    public ArchivingStrategy addToDirWhiteList(String pattern) {
        this.checkSealed();
        this.getOrCreateDirWhiteList().add(Pattern.compile(pattern));
        return this;
    }

    public ArchivingStrategy addToDirBlackList(Pattern pattern) {
        this.checkSealed();
        this.getOrCreateDirBlackList().add(pattern);
        return this;
    }

    public ArchivingStrategy addToDirBlackList(String pattern) {
        this.checkSealed();
        this.getOrCreateDirBlackList().add(Pattern.compile(pattern));
        return this;
    }

    public ArchivingStrategy addToCompressionWhiteList(Pattern pattern) {
        this.checkSealed();
        this.getOrCreateCompressionWhiteList().add(pattern);
        this.compressionStrategy = CompressionStrategy.USE_BLACK_WHITE_LISTS;
        return this;
    }

    public ArchivingStrategy addToCompressionWhiteList(String pattern) {
        this.checkSealed();
        this.getOrCreateCompressionWhiteList().add(Pattern.compile(pattern));
        this.compressionStrategy = CompressionStrategy.USE_BLACK_WHITE_LISTS;
        return this;
    }

    public ArchivingStrategy addToCompressionBlackList(Pattern pattern) {
        this.checkSealed();
        this.getOrCreateCompressionBlackList().add(pattern);
        this.compressionStrategy = CompressionStrategy.USE_BLACK_WHITE_LISTS;
        return this;
    }

    public ArchivingStrategy addToCompressionBlackList(String pattern) {
        this.checkSealed();
        this.getOrCreateCompressionBlackList().add(Pattern.compile(pattern));
        this.compressionStrategy = CompressionStrategy.USE_BLACK_WHITE_LISTS;
        return this;
    }

    public ArchivingStrategy seal() {
        this.sealed = true;
        return this;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public ArchivingStrategy compressAll() {
        this.checkSealed();
        this.compressionStrategy = CompressionStrategy.COMPRESS_ALL;
        return this;
    }

    public ArchivingStrategy compressAll(boolean compress) {
        this.checkSealed();
        this.compressionStrategy = compress ? CompressionStrategy.COMPRESS_ALL : CompressionStrategy.COMPRESS_NOTHING;
        return this;
    }

    @Deprecated
    public final void setCompress(boolean compress) {
        this.checkSealed();
        this.compressionStrategy = compress ? CompressionStrategy.COMPRESS_ALL : CompressionStrategy.COMPRESS_NOTHING;
    }

    boolean doExclude(String path, boolean isDirectory) {
        if (isDirectory) {
            return !ArchivingStrategy.match(this.dirBlackListOrNull, this.dirWhiteListOrNull, path);
        }
        return !ArchivingStrategy.match(this.fileBlackListOrNull, this.fileWhiteListOrNull, path);
    }

    HDF5GenericStorageFeatures getStorageFeatureForPath(String path) {
        return this.doCompress(path) ? HDF5GenericStorageFeatures.GENERIC_DEFLATE : HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION;
    }

    public boolean doCompress(String path) {
        switch (this.compressionStrategy) {
            case COMPRESS_NOTHING: {
                return false;
            }
            case COMPRESS_ALL: {
                return true;
            }
        }
        return ArchivingStrategy.match(this.compressionBlackListOrNull, this.compressionWhiteListOrNull, path);
    }

    public CompressionStrategy getCompressionStrategy() {
        return this.compressionStrategy;
    }

    private static boolean match(Iterable<Pattern> blackListOrNull, Iterable<Pattern> whiteListOrNull, String path) {
        if (blackListOrNull != null) {
            for (Pattern p : blackListOrNull) {
                if (!p.matcher(path).matches()) continue;
                return false;
            }
        }
        if (whiteListOrNull == null) {
            return true;
        }
        for (Pattern p : whiteListOrNull) {
            if (!p.matcher(path).matches()) continue;
            return true;
        }
        return false;
    }

    public static enum CompressionStrategy {
        COMPRESS_NOTHING,
        COMPRESS_ALL,
        USE_BLACK_WHITE_LISTS;

    }
}

