/*
 * Decompiled with CFR 0.152.
 */
package scri.commons.gui;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JLabel;

public class RB {
    private static ResourceBundle bundle = null;

    public static void initialize(String locale, String resourcePath) {
        if (!locale.equals("auto")) {
            String language = locale.substring(0, 2);
            try {
                String country = locale.substring(3);
                Locale.setDefault(new Locale(language, country));
            }
            catch (Exception e) {
                Locale.setDefault(new Locale(language));
            }
        }
        bundle = ResourceBundle.getBundle(resourcePath);
    }

    public static String getString(String key) {
        try {
            return bundle.getString(key).replaceAll("&", "");
        }
        catch (Exception e) {
            e.printStackTrace();
            return key;
        }
    }

    public static boolean exists(String key) {
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            if (!keys.nextElement().equals(key)) continue;
            return true;
        }
        return false;
    }

    public static String format(String key, Object ... args) {
        try {
            String str = bundle.getString(key).replaceAll("&", "");
            str = str.replaceAll("'", "''");
            MessageFormat msg = new MessageFormat(str);
            return msg.format(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            return key;
        }
    }

    public static void setMnemonic(JLabel label, String key) {
        try {
            String str = bundle.getString(key);
            int i = str.indexOf("&");
            char m = str.replaceAll("&", "").charAt(i);
            label.setDisplayedMnemonic(m);
            label.setDisplayedMnemonicIndex(i);
        }
        catch (IndexOutOfBoundsException str) {
        }
        catch (Exception e) {
            System.out.println(e.getMessage() + " " + key);
        }
    }

    public static void setMnemonic(AbstractButton button, String key) {
        try {
            String str = bundle.getString(key);
            int i = str.indexOf("&");
            char m = str.replaceAll("&", "").charAt(i);
            button.setMnemonic(m);
            button.setDisplayedMnemonicIndex(i);
        }
        catch (IndexOutOfBoundsException str) {
        }
        catch (Exception e) {
            System.out.println(e.getMessage() + " " + key);
        }
    }

    public static void setText(JLabel label, String key) {
        label.setText(RB.getString(key));
        RB.setMnemonic(label, key);
    }

    public static void setText(AbstractButton button, String key) {
        button.setText(RB.getString(key));
        RB.setMnemonic(button, key);
    }
}

