/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.servlet.dendrogram;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jhi.flapjack.servlet.RunR;

public class DendrogramTask {
    private int lineCount;
    private String rPath;
    private String wrkDir;

    public static void main(String[] args) throws Exception {
        DendrogramTask task = new DendrogramTask();
        task.rPath = args[0];
        task.wrkDir = args[1];
        task.lineCount = Integer.parseInt(args[2]);
        task.run();
    }

    private void run() throws Exception {
        File rScript = new File(this.wrkDir, "script.R");
        File matrix = new File(this.wrkDir, "matrix.txt");
        this.writeScript(rScript, this.lineCount);
        RunR runner = new RunR(this.rPath, matrix.getParentFile(), rScript);
        runner.runR();
        this.zipResults();
    }

    private void writeScript(File rScript, int lineCount) throws IOException {
        String str;
        BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/src/arrr/Dendrogram.R")));
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(rScript)));
        int pngWidth = 12 * lineCount;
        pngWidth = pngWidth < 500 ? 500 : pngWidth;
        int pdfWidth = (int)Math.ceil(lineCount / 4);
        while ((str = in.readLine()) != null) {
            str = str.replace("$MATRIX", "matrix.txt");
            str = str.replace("$ORDER", "order.txt");
            str = str.replace("$PNG_FILE", "dendrogram.png");
            str = str.replace("$PDF_FILE", "dendrogram.pdf");
            str = str.replace("$PNG_WIDTH", "" + pngWidth);
            str = str.replace("$PDF_WIDTH", "" + pdfWidth);
            out.println(str);
        }
        in.close();
        out.close();
    }

    private void zipResults() {
        File order = new File(this.wrkDir, "order.txt");
        File png = new File(this.wrkDir, "dendrogram.png");
        File pdf = new File(this.wrkDir, "dendrogram.pdf");
        File zipFile = new File(this.wrkDir, "results.zip");
        try (ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(zipFile));
             BufferedInputStream pngIn = new BufferedInputStream(new FileInputStream(png));
             BufferedInputStream pdfIn = new BufferedInputStream(new FileInputStream(pdf));
             BufferedInputStream orderIn = new BufferedInputStream(new FileInputStream(order));){
            this.createZipEntry(zout, "dendrogram.png", pngIn);
            this.createZipEntry(zout, "dendrogram.pdf", pdfIn);
            this.createZipEntry(zout, "order.txt", orderIn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createZipEntry(ZipOutputStream zout, String name, BufferedInputStream inStream) throws IOException {
        int length;
        zout.putNextEntry(new ZipEntry(name));
        byte[] buffer = new byte[1024];
        while ((length = inStream.read(buffer)) > 0) {
            zout.write(buffer, 0, length);
        }
        inStream.close();
    }
}

