/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.cmd;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.Project;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.io.ChromosomeMapImporter;
import jhi.flapjack.io.FlapjackFile;
import jhi.flapjack.io.GenotypeDataImporter;
import jhi.flapjack.io.PostImportOperations;
import jhi.flapjack.io.ProjectSerializer;
import jhi.flapjack.io.ProjectSerializerDB;
import jhi.flapjack.io.QTLImporter;
import jhi.flapjack.io.TraitImporter;
import scri.commons.gui.RB;
import scri.commons.gui.TaskDialog;

public class CreateProject {
    private Project project = new Project();
    private DataSet dataSet = new DataSet();
    private File mapFile;
    private File genotypesFile;
    private File traitsFile;
    private File qtlsFile;
    private FlapjackFile prjFile;
    private File htmlFile;
    private String name;
    private boolean decimalEnglish = false;
    private List<String> output = new ArrayList<String>();

    public static void main(String[] args) {
        File mapFile = null;
        File genotypesFile = null;
        File traitsFile = null;
        File qtlsFile = null;
        FlapjackFile prjFile = null;
        File htmlFile = null;
        boolean decimalEnglish = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-map=")) {
                mapFile = new File(args[i].substring(5));
            }
            if (args[i].startsWith("-genotypes=")) {
                genotypesFile = new File(args[i].substring(11));
            }
            if (args[i].startsWith("-traits=")) {
                traitsFile = new File(args[i].substring(8));
            }
            if (args[i].startsWith("-qtls=")) {
                qtlsFile = new File(args[i].substring(6));
            }
            if (args[i].startsWith("-project=")) {
                prjFile = new FlapjackFile(args[i].substring(9));
            }
            if (args[i].startsWith("-decimalEnglish")) {
                decimalEnglish = true;
            }
            if (!args[i].startsWith("-galaxyHTML=")) continue;
            htmlFile = new File(args[i].substring(12));
        }
        if (genotypesFile == null || prjFile == null) {
            System.out.println("Usage: createproject <options>\n where valid options are:\n   -map=<map_file>                (optional input file)\n   -genotypes=<genotypes_file>    (required input file)\n   -traits=<traits_file>          (optional input file)\n   -qtls=<qtl_file>               (optional input file)\n   -decimalEnglish                (optional input parameter)\n   -project=<project_file>        (required output file)\n");
            System.exit(1);
        }
        CreateProject cProj = new CreateProject(mapFile, genotypesFile, traitsFile, qtlsFile, prjFile, htmlFile, decimalEnglish);
        cProj.doProjectCreation();
    }

    public CreateProject(File mapFile, File genotypesFile, File traitsFile, File qtlsFile, FlapjackFile prjFile, File htmlFile, boolean decimalEnglish) {
        this.mapFile = mapFile;
        this.genotypesFile = genotypesFile;
        this.traitsFile = traitsFile;
        this.qtlsFile = qtlsFile;
        this.htmlFile = htmlFile;
        this.decimalEnglish = decimalEnglish;
        this.prjFile = prjFile;
    }

    public List<String> doProjectCreation() {
        RB.initialize((String)"auto", (String)"res.text.flapjack");
        TaskDialog.setIsHeadless();
        FlapjackUtils.initialiseSqlite();
        if (this.decimalEnglish) {
            Locale.setDefault(Locale.UK);
        }
        try {
            this.openProject();
            this.createProject();
            this.importTraits();
            this.importQTLs();
            if (this.saveProject()) {
                this.logMessage("\nProject Created");
            }
            ProjectSerializerDB.close();
            if (this.htmlFile != null) {
                this.writeHTMLFile();
            }
        }
        catch (Exception e) {
            this.logMessage(e.getMessage());
        }
        return this.output;
    }

    void createProject() throws Exception {
        ChromosomeMapImporter mapImporter = new ChromosomeMapImporter(this.mapFile, this.dataSet);
        mapImporter.importMap();
        GenotypeDataImporter genoImporter = new GenotypeDataImporter(this.genotypesFile, this.dataSet, mapImporter.getMarkersHashMap(), "-", true, "/", false);
        genoImporter.importGenotypeData();
        PostImportOperations pio = new PostImportOperations(this.dataSet);
        pio.collapseHomzEncodedAsHet();
        pio.optimizeStateTable();
        pio.createDefaultView();
        if (this.name != null) {
            pio.setName(this.name);
        } else {
            pio.setName(this.prjFile.getFile());
        }
        this.project.addDataSet(this.dataSet);
    }

    private void importTraits() throws Exception {
        if (this.traitsFile == null) {
            return;
        }
        this.logMessage("Importing traits from " + this.traitsFile);
        TraitImporter importer = new TraitImporter(this.traitsFile, this.dataSet);
        importer.runJob(0);
        this.dataSet.getViewSets().get(0).assignTraits();
    }

    private void importQTLs() throws Exception {
        if (this.qtlsFile == null) {
            return;
        }
        this.logMessage("Importing QTLs from " + this.qtlsFile);
        QTLImporter importer = new QTLImporter(this.qtlsFile, this.dataSet);
        importer.runJob(0);
    }

    private void openProject() throws Exception {
        if (this.prjFile.exists() && this.prjFile.getFile().length() > 0L) {
            this.project = ProjectSerializer.open(this.prjFile);
        }
    }

    private boolean saveProject() throws Exception {
        this.project.fjFile = this.prjFile;
        return ProjectSerializer.save(this.project);
    }

    private void logMessage(String message) {
        System.out.println(message);
        this.output.add(message);
    }

    DataSet dataSet() {
        return this.dataSet;
    }

    private void writeHTMLFile() throws Exception {
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.htmlFile)));
        out.println("<html>");
        out.println("<head><title>Flapjack Output</title></body>");
        out.println("<body>");
        out.println("<p>Flapjack output: " + this.prjFile.getPath() + "</p>");
        out.println("</body>");
        out.println("</html>");
        out.close();
    }
}

