/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.cmd;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.Project;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.io.ChromosomeMapExporter;
import jhi.flapjack.io.FlapjackFile;
import jhi.flapjack.io.GenotypeDataExporter;
import jhi.flapjack.io.ProjectSerializer;
import jhi.flapjack.io.QTLExporter;
import jhi.flapjack.io.TraitExporter;
import scri.commons.gui.Install4j;
import scri.commons.gui.RB;
import scri.commons.gui.SimpleJob;
import scri.commons.gui.TaskDialog;

public class SplitProject
extends SimpleJob {
    private Project project = new Project();
    private FlapjackFile prjFile;
    private String outputDir;
    private boolean decimalEnglish = false;
    private boolean isCommandLine = false;
    private HashMap<String, String> datasets = new HashMap();
    private static List<String> output = new ArrayList<String>();

    public SplitProject(Project project, String outputDir) {
        this.project = project;
        this.outputDir = outputDir;
        this.maximum = 4;
    }

    public SplitProject(String prjFilePath, String outputDir, HashMap<String, String> datasets, boolean decimalEnglish) {
        this.prjFile = new FlapjackFile(prjFilePath);
        this.outputDir = outputDir;
        this.datasets = datasets;
        this.decimalEnglish = decimalEnglish;
    }

    public static void main(String[] args) {
        String prjFilePath = null;
        String outputDir = null;
        boolean decimalEnglish = false;
        HashMap<String, String> datasets = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].toUpperCase().startsWith("-PROJECT=")) {
                prjFilePath = args[i].substring(9);
            }
            if (args[i].toUpperCase().startsWith("-DIR=")) {
                outputDir = args[i].substring(5);
            }
            if (args[i].toUpperCase().startsWith("-DECIMALENGLISH")) {
                decimalEnglish = true;
            }
            if (!args[i].toUpperCase().startsWith("-DATASETIN=")) continue;
            String name = args[i].substring(11);
            datasets.put(name, name);
            if (i + 1 >= args.length || !args[i + 1].toUpperCase().startsWith("-DATASETOUT=")) continue;
            String newname = args[i + 1].substring(12);
            datasets.put(name, newname);
            ++i;
        }
        if (prjFilePath == null || outputDir == null) {
            System.out.println("Flapjack " + Install4j.VERSION + "\n\nSplits a Flapjack project into multiple raw data text files.\n\nSPLITPROJECT -PROJECT=project -DIR=dir\n             [-DATASETIN=datasetin [-DATASETOUT=datasetout]]\n             [-DECIMALENGLISH]\n\n  project           The location of the project to process.\n  dir               The location to write the output files to.\n  datasetin         Specifies the name of a dataset within the project file\n                    to process. If no names are specified, then all datasets\n                    will be extracted.\n  datasetout        Overrides the given datasetin name with a new name to use\n                    when outputting that dataset's files.\n  decimalEnglish    Specifies that all numbers will be processed using the\n                    English decimal mark separator (dot rather than a comma).\n\nNote that dataset names in Flapjack are case sensitive.\nYou can process multiple datasets at once, eg:\n  -DATASETIN dsin1 -DATASETOUT dsout1 -DATASETIN dsin2 -DATASETOUT dsout2\n");
            System.exit(1);
        }
        SplitProject splitProject = new SplitProject(prjFilePath, outputDir, datasets, decimalEnglish);
        splitProject.doSplit();
    }

    public List<String> doSplit() {
        this.isCommandLine = true;
        RB.initialize((String)"auto", (String)"res.text.flapjack");
        TaskDialog.setIsHeadless();
        FlapjackUtils.initialiseSqlite();
        if (this.decimalEnglish) {
            Locale.setDefault(Locale.UK);
        }
        try {
            this.runJob(0);
        }
        catch (Exception e) {
            SplitProject.logMessage(e.getMessage());
        }
        return output;
    }

    public void runJob(int index) throws Exception {
        if (this.isCommandLine) {
            this.openProject();
        }
        this.exportMap();
        this.progress = 1;
        this.exportGenotypes();
        this.progress = 2;
        this.exportTraits();
        this.progress = 3;
        this.exportQTL();
        this.progress = 4;
    }

    private void openProject() throws Exception {
        this.project = ProjectSerializer.open(this.prjFile);
    }

    private String getName(DataSet dataSet) {
        if (this.datasets.containsKey(dataSet.getName())) {
            return this.datasets.get(dataSet.getName());
        }
        return dataSet.getName();
    }

    private boolean processDataSet(DataSet dataSet) {
        if (this.datasets.size() == 0) {
            return true;
        }
        return this.datasets.containsKey(dataSet.getName());
    }

    private void exportMap() throws Exception {
        for (DataSet dataSet : this.project.getDataSets()) {
            if (!this.processDataSet(dataSet)) continue;
            for (GTViewSet viewSet : dataSet.getViewSets()) {
                String name = this.getName(dataSet) + "_" + viewSet.getName() + ".map";
                ChromosomeMapExporter exporter = new ChromosomeMapExporter(new File(this.outputDir, name), viewSet, true, null, 0);
                SplitProject.logMessage("Exporting map:       " + name);
                exporter.runJob(0);
            }
        }
    }

    private void exportGenotypes() throws Exception {
        for (DataSet dataSet : this.project.getDataSets()) {
            if (!this.processDataSet(dataSet)) continue;
            for (GTViewSet viewSet : dataSet.getViewSets()) {
                String name = this.getName(dataSet) + "_" + viewSet.getName() + ".dat";
                GenotypeDataExporter exporter = new GenotypeDataExporter(new File(this.outputDir, name), viewSet, true, null, 0);
                SplitProject.logMessage("Exporting genotypes: " + name);
                exporter.runJob(0);
            }
        }
    }

    private void exportTraits() throws Exception {
        for (DataSet dataSet : this.project.getDataSets()) {
            if (!this.processDataSet(dataSet)) continue;
            String name = this.getName(dataSet) + ".traits";
            TraitExporter exporter = new TraitExporter(dataSet, new File(this.outputDir, name));
            SplitProject.logMessage("Exporting traits:    " + name);
            exporter.runJob(0);
        }
    }

    private void exportQTL() throws Exception {
        for (DataSet dataSet : this.project.getDataSets()) {
            if (!this.processDataSet(dataSet)) continue;
            String name = this.getName(dataSet) + ".qtl";
            QTLExporter exporter = new QTLExporter(dataSet, new File(this.outputDir, name));
            SplitProject.logMessage("Exporting QTL:       " + name);
            exporter.runJob(0);
        }
    }

    private static void logMessage(String message) {
        System.out.println(message);
        output.add(message);
    }
}

