/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import jhi.flapjack.data.ChromosomeMap;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.QTL;
import jhi.flapjack.data.QTLInfo;
import jhi.flapjack.io.DataFormatException;
import scri.commons.gui.RB;
import scri.commons.gui.SimpleJob;
import scri.commons.io.ProgressInputStream;

public class QTLImporter
extends SimpleJob {
    private NumberFormat nf = NumberFormat.getInstance();
    private ProgressInputStream is;
    private File file;
    private DataSet dataSet;
    private static final int HEADERCOUNT = 7;
    HashMap<String, ArrayList<QTL>> chromosomes = new HashMap();
    LinkedList<QTL> qtls = new LinkedList();
    HashMap<String, Color> traits = new HashMap();
    private int featuresRead;
    private int featuresAdded;
    private ChromosomeMap allMap = null;

    public QTLImporter(File file, DataSet dataSet) {
        this.file = file;
        this.dataSet = dataSet;
        this.maximum = 5555;
        for (ChromosomeMap c : dataSet.getChromosomeMaps()) {
            this.chromosomes.put(c.getName(), new ArrayList());
            if (!c.isSpecialChromosome()) continue;
            this.allMap = c;
        }
    }

    public void runJob(int index) throws Exception {
        this.is = new ProgressInputStream((InputStream)new FileInputStream(this.file));
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)this.is, "UTF-8"));
        String str = in.readLine();
        while (str != null && str.startsWith("#")) {
            str = in.readLine();
        }
        String[] tokens = str.trim().split("\t", -1);
        String[] scoreHeaders = new String[tokens.length - 7];
        for (int i = 7; i < tokens.length; ++i) {
            scoreHeaders[i - 7] = new String(tokens[i]);
        }
        int line = 1;
        while ((str = in.readLine()) != null && this.okToRun) {
            if (str.length() != 0 && !str.startsWith("#")) {
                tokens = str.trim().split("\t", -1);
                if (tokens.length != 7 + scoreHeaders.length) {
                    throw new DataFormatException(RB.format((String)"io.DataFormatException.traitColumnError", (Object[])new Object[]{line}));
                }
                QTL qTL = new QTL(new String(tokens[0]));
                String cName = tokens[1];
                qTL.setPosition(this.nf.parse(tokens[2]).doubleValue());
                qTL.setMin(this.nf.parse(tokens[3]).doubleValue());
                qTL.setMax(this.nf.parse(tokens[4]).doubleValue());
                qTL.setTrait(tokens[5]);
                qTL.setExperiment(tokens[6]);
                this.traits.put(tokens[5], Color.white);
                String[] vNames = new String[scoreHeaders.length];
                String[] values = new String[scoreHeaders.length];
                for (int i = 0; i < values.length; ++i) {
                    vNames[i] = scoreHeaders[i];
                    values[i] = new String(tokens[i + 7]);
                }
                qTL.setVNames(vNames);
                qTL.setValues(values);
                ++this.featuresRead;
                ArrayList<QTL> track = this.chromosomes.get(cName);
                if (track != null) {
                    track.add(qTL);
                    this.checkChromosome(qTL, cName);
                    ++this.featuresAdded;
                }
                this.qtls.add(qTL);
            }
            ++line;
        }
        in.close();
        if (!this.okToRun) {
            return;
        }
        this.calculateTraitColors();
        for (ChromosomeMap chromosomeMap : this.dataSet.getChromosomeMaps()) {
            ArrayList<QTL> track = this.chromosomes.get(chromosomeMap.getName());
            Collections.sort(track);
            chromosomeMap.setQtls(track);
        }
        if (this.allMap != null) {
            ArrayList<QTL> track = new ArrayList<QTL>();
            for (ChromosomeMap map : this.dataSet.getChromosomeMaps()) {
                if (map.isSpecialChromosome()) continue;
                for (QTL qtl : map.getQtls()) {
                    QTL clone = qtl.createClone();
                    track.add(clone);
                }
            }
            this.allMap.setQtls(track);
        }
        for (GTViewSet gTViewSet : this.dataSet.getViewSets()) {
            for (GTView view : gTViewSet.getViews()) {
                boolean isSuper = view.getChromosomeMap().isSpecialChromosome();
                ArrayList<QTLInfo> qtls = new ArrayList<QTLInfo>();
                ArrayList<QTL> track = view.getChromosomeMap().getQtls();
                for (int i = 0; i < track.size(); ++i) {
                    QTL qtl = track.get(i);
                    if (!isSuper) {
                        qtls.add(new QTLInfo(qtl, i, 0.0));
                        continue;
                    }
                    ChromosomeMap map = qtl.getChromosomeMap();
                    double mapOffset = this.getMapOffset(map, gTViewSet);
                    qtls.add(new QTLInfo(qtl, i, mapOffset));
                    qtl.setChromosomeMap(view.getChromosomeMap());
                }
                view.setQTLs(qtls);
            }
        }
    }

    private double getMapOffset(ChromosomeMap map, GTViewSet viewSet) {
        double mapOffset = 0.0;
        for (GTView view : viewSet.getViews()) {
            if (view.getChromosomeMap() == map) {
                return mapOffset;
            }
            mapOffset += view.getChromosomeMap().getLength();
        }
        return mapOffset;
    }

    private void calculateTraitColors() {
        float colorCount = this.traits.size();
        float hue = 0.0f;
        Set<String> keys = this.traits.keySet();
        for (String key : keys) {
            Color color = Color.getHSBColor(hue, 0.4f, 1.0f);
            hue += 1.0f / colorCount;
            this.traits.put(key, color);
        }
        for (QTL qtl : this.qtls) {
            String traitName = qtl.getTrait();
            Color color = this.traits.get(traitName);
            qtl.setDisplayColor(color);
        }
    }

    private void checkChromosome(QTL qtl, String cName) {
        ChromosomeMap.Wrapper cw = this.dataSet.getMapByName(cName, false);
        if (cw == null) {
            return;
        }
        if (qtl.getMin() < 0.0 || qtl.getMax() > cw.map.getLength() || qtl.getMax() < 0.0 || qtl.getMin() > cw.map.getLength() || qtl.getPosition() < 0.0 || qtl.getPosition() > cw.map.getLength()) {
            qtl.setAllowed(false);
            qtl.setVisible(false);
        }
        qtl.setChromosomeMap(cw.map);
    }

    public int getValue() {
        if (this.is == null) {
            return 0;
        }
        return Math.round((float)this.is.getBytesRead() / (float)this.file.length() * 5555.0f);
    }

    public int getFeaturesRead() {
        return this.featuresRead;
    }

    public int getFeaturesAdded() {
        return this.featuresAdded;
    }
}

