/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import jhi.flapjack.data.GraphData;
import jhi.flapjack.data.MarkerInfo;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.GenotypeCanvas;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.GraphCanvasAAThread;
import jhi.flapjack.gui.visualization.GraphCanvasML;

class GraphCanvas
extends JPanel {
    private static final int h = 45;
    private static final int BORDER = 5;
    private GenotypePanel gPanel;
    private GenotypeCanvas canvas;
    private Canvas2D graphCanvas;
    private int index;
    GraphData graphData;
    private BufferedImage buffer;
    private BufferedImage aaBuffer;
    boolean updateBuffer = true;
    private BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{5.0f, 2.0f}, 0.0f);
    private int pX2 = 0;
    private int w;
    int xOffset;
    boolean full = false;

    GraphCanvas(GenotypePanel gPanel, GenotypeCanvas canvas, int index) {
        this.gPanel = gPanel;
        this.canvas = canvas;
        this.index = index;
        this.setLayout(new BorderLayout());
        this.graphCanvas = new Canvas2D();
        this.add(this.graphCanvas);
        new GraphCanvasML(gPanel, this);
    }

    private void paintBuffer() {
        this.w = this.canvas.pX2 - this.canvas.pX1 + 1;
        if (this.buffer == null || this.buffer.getWidth() != this.w || this.buffer.getHeight() != 45) {
            this.buffer = (BufferedImage)this.createImage(this.w > 0 ? this.w : 1, 45);
            this.aaBuffer = (BufferedImage)this.createImage(this.w > 0 ? this.w : 1, 45);
        }
        Graphics2D g = this.buffer.createGraphics();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.w, 45);
        int xS = this.canvas.pX1 / this.canvas.boxW;
        int xE = this.canvas.pX2 / this.canvas.boxW;
        this.render(g, xS, xE);
        g.dispose();
        this.updateBuffer = false;
        new GraphCanvasAAThread(this, xS, xE, this.index);
    }

    void render(Graphics2D g, int xS, int xE) {
        if (this.canvas.view.getChromosomeMap().getGraphs().size() == 0) {
            return;
        }
        int idx = this.canvas.viewSet.getGraphs()[this.index];
        if (idx == -1) {
            return;
        }
        g.translate(-this.canvas.pX1, 0);
        if (xS > this.canvas.view.markerCount() || xE > this.canvas.view.markerCount()) {
            return;
        }
        if (Prefs.guiGraphStyle == 1) {
            g.translate(this.canvas.boxW / 2, 0);
        }
        if (xS > 0) {
            --xS;
        }
        if (xE < this.canvas.view.markerCount() - 1) {
            ++xE;
        }
        this.graphData = this.canvas.view.getChromosomeMap().getGraphs().get(idx);
        float[] data = this.graphData.data();
        Float prev = null;
        for (int i = xS; i <= xE; ++i) {
            MarkerInfo mi = this.canvas.view.getMarkerInfo(i);
            float value = data[mi.getIndex()];
            if (mi.dummyMarker()) continue;
            int y = (int)(value * 44.0f);
            int x = i * this.canvas.boxW;
            if (Prefs.guiGraphStyle == 0) {
                int alpha = 25 + (int)(230.0f * (255.0f * value) / 255.0f);
                g.setColor(new Color(70, 116, 162, alpha));
                g.fillRect(x, 0, this.canvas.boxW, y);
                continue;
            }
            g.setColor(new Color(70, 116, 162));
            g.fillRect(x - 2, y - 2, 4, 4);
            if (prev != null) {
                g.drawLine(x - this.canvas.boxW, (int)(prev.floatValue() * 45.0f), x, y);
            } else {
                g.drawLine(x, y, x, y);
            }
            prev = Float.valueOf(value);
        }
        if (this.graphData.getHasThreshold()) {
            int y = (int)(this.graphData.getThreshold() * 44.0f);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setColor(new Color(70, 116, 162));
            g.setStroke(this.dashed);
            g.drawLine(this.canvas.pX1, y, this.canvas.pX2, y);
        }
    }

    Graphics2D getAntiAliasedBufferGraphics() {
        return this.aaBuffer.createGraphics();
    }

    BufferedImage createSavableImage(boolean full) throws Exception {
        if (!this.isVisible()) {
            return null;
        }
        this.w = this.canvas.pX2 - this.canvas.pX1 + 1;
        int xS = this.canvas.pX1 / this.canvas.boxW;
        int xE = this.canvas.pX2 / this.canvas.boxW;
        if (full) {
            this.w = this.canvas.canvasW;
            xS = 0;
            xE = this.canvas.view.markerCount() - 1;
        }
        BufferedImage image = (BufferedImage)this.createImage(this.w > 0 ? this.w : 1, 45);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.white);
        g.fillRect(0, 0, this.w, 45);
        this.render(g, xS, xE);
        g.dispose();
        return image;
    }

    void determineVisibility() {
        if (this.canvas.view == null || this.canvas.view.getChromosomeMap().getGraphs().size() == 0 || this.canvas.viewSet.getGraphs()[this.index] == -1) {
            this.setVisible(false);
        } else {
            this.setVisible(Prefs.visShowGraphCanvas);
        }
    }

    private class Canvas2D
    extends JPanel {
        Canvas2D() {
            this.setPreferredSize(new Dimension(0, 45));
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D g = (Graphics2D)graphics;
            if (((GraphCanvas)GraphCanvas.this).canvas.view.getChromosomeMap().getGraphs().size() == 0) {
                return;
            }
            if (GraphCanvas.this.pX2 != ((GraphCanvas)GraphCanvas.this).canvas.pX2) {
                GraphCanvas.this.updateBuffer = true;
                GraphCanvas.this.pX2 = ((GraphCanvas)GraphCanvas.this).canvas.pX2;
            }
            GraphCanvas.this.xOffset = ((GraphCanvas)GraphCanvas.this).gPanel.traitCanvas.getPanelWidth() + ((GraphCanvas)GraphCanvas.this).gPanel.listPanel.getPanelWidth() + 1;
            g.translate(GraphCanvas.this.xOffset, 0);
            if (GraphCanvas.this.updateBuffer) {
                GraphCanvas.this.paintBuffer();
            }
            if (GraphCanvasAAThread.bufferAvailable) {
                g.drawImage((Image)GraphCanvas.this.aaBuffer, 0, 0, null);
            } else {
                g.drawImage((Image)GraphCanvas.this.buffer, 0, 0, null);
            }
        }
    }
}

