/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.Color;
import java.awt.Graphics2D;
import jhi.flapjack.data.GTView;
import jhi.flapjack.gui.visualization.GenotypeCanvas;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.IOverlayRenderer;

public class BookmarkHighlighter
extends Thread
implements IOverlayRenderer {
    public static boolean enable = true;
    private GenotypePanel gPanel;
    private GenotypeCanvas canvas;
    private GTView view;
    private int lineIndex = -1;
    private int markerIndex = -1;
    private int alphaEffect = 0;

    public BookmarkHighlighter(GenotypePanel gPanel, GTView view, int lineIndex, int markerIndex) {
        this.gPanel = gPanel;
        this.view = view;
        this.lineIndex = lineIndex;
        this.markerIndex = markerIndex;
        this.canvas = gPanel.canvas;
        if (!enable) {
            enable = true;
            return;
        }
        this.start();
    }

    @Override
    public void run() {
        for (IOverlayRenderer r : this.canvas.overlays) {
            if (!(r instanceof BookmarkHighlighter)) continue;
            ((BookmarkHighlighter)r).interrupt();
            this.canvas.overlays.remove(r);
            break;
        }
        while (this.canvas.view != this.view) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.canvas.resetBufferedState(false);
        this.canvas.overlays.add(this);
        this.moveTo();
        this.alphaEffect = 200;
        this.canvas.repaint();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        for (int i = 1; i <= 40 && !this.isInterrupted(); ++i) {
            this.alphaEffect = 200 - i * 5;
            this.canvas.repaint();
            try {
                Thread.sleep(25L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.canvas.overlays.remove(this);
    }

    private void moveTo() {
        this.gPanel.moveToPosition(this.lineIndex, this.markerIndex, true);
    }

    @Override
    public void render(Graphics2D g) {
        g.setPaint(new Color(20, 20, 20, this.alphaEffect));
        int y1 = this.lineIndex * this.canvas.boxH;
        int y2 = y1 + this.canvas.boxH;
        int x1 = this.markerIndex * this.canvas.boxW;
        int x2 = x1 + this.canvas.boxW;
        g.fillRect(0, 0, x1, y1);
        g.fillRect(x2, 0, this.canvas.canvasW - x2, y1);
        g.fillRect(0, y2, x1, this.canvas.canvasH - y2);
        g.fillRect(x2, y2, this.canvas.canvasW - x2, this.canvas.canvasH - y2);
    }
}

