/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.io.ChromosomeMapExporter;
import jhi.flapjack.io.GenotypeDataExporter;
import scri.commons.gui.ITrackableJob;
import scri.commons.gui.ProgressDialog;
import scri.commons.gui.RB;
import scri.commons.gui.TaskDialog;
import scri.commons.gui.matisse.DialogPanel;
import scri.commons.gui.matisse.HyperLinkLabel;

public class ExportDataDialog
extends JDialog
implements ActionListener {
    private GTViewSet viewSet;
    private String baseName;
    private JButton bCancel;
    private JButton bExport;
    private JButton bHelp;
    JComboBox<String> combo;
    private DialogPanel dialogPanel1;
    private JScrollPane jScrollPane1;
    private JLabel label;
    private JLabel label2;
    private JPanel mapPanel;
    JRadioButton rAll;
    private JRadioButton rSelected;
    private JLabel radioLabel;
    private HyperLinkLabel selectAllLabel;
    private HyperLinkLabel selectNoneLabel;
    private JTable table;
    private JLabel tableLabel;

    public ExportDataDialog(GTViewSet viewSet) {
        super(Flapjack.winMain, RB.getString((String)"gui.dialog.ExportDataDialog.title"), true);
        this.viewSet = viewSet;
        this.baseName = viewSet.getDataSet().getName();
        this.baseName = this.baseName.substring(0, this.baseName.lastIndexOf(" "));
        this.initComponents();
        this.initComponents2();
        FlapjackUtils.initDialog(this, this.bExport, this.bCancel, true, this.getContentPane(), this.mapPanel);
    }

    private void initComponents2() {
        RB.setText((AbstractButton)this.bExport, (String)"gui.dialog.ExportDataDialog.bExport");
        this.bExport.addActionListener(this);
        RB.setText((AbstractButton)this.bCancel, (String)"gui.text.cancel");
        this.bCancel.addActionListener(this);
        RB.setText((AbstractButton)this.bHelp, (String)"gui.text.help");
        FlapjackUtils.setHelp(this.bHelp, "_-_Export_Data");
        this.mapPanel.setBorder(BorderFactory.createTitledBorder(RB.getString((String)"gui.dialog.NBExportDataPanel.panel.title")));
        RB.setText((JLabel)this.label, (String)"gui.dialog.NBExportDataPanel.label");
        RB.setText((JLabel)this.radioLabel, (String)"gui.dialog.NBExportDataPanel.radioLabel");
        RB.setText((AbstractButton)this.rAll, (String)"gui.dialog.NBExportDataPanel.rAll");
        RB.setText((AbstractButton)this.rSelected, (String)"gui.dialog.NBExportDataPanel.rSelected");
        RB.setText((JLabel)this.tableLabel, (String)"gui.dialog.NBExportDataPanel.tableLabel");
        RB.setText((JLabel)this.selectAllLabel, (String)"gui.dialog.NBExportDataPanel.selectAllLabel");
        RB.setText((JLabel)this.selectNoneLabel, (String)"gui.dialog.NBExportDataPanel.selectNoneLabel");
        this.combo.addItem(RB.getString((String)"gui.dialog.NBExportDataPanel.comboMap"));
        this.combo.addItem(RB.getString((String)"gui.dialog.NBExportDataPanel.comboDat"));
        this.selectAllLabel.addActionListener((ActionListener)this);
        this.selectNoneLabel.addActionListener((ActionListener)this);
        this.createTable(this.viewSet);
    }

    private void createTable(GTViewSet viewSet) {
        Object[] columnNames = new String[]{RB.getString((String)"gui.dialog.NBExportDataPanel.column1"), RB.getString((String)"gui.dialog.NBExportDataPanel.column2"), RB.getString((String)"gui.dialog.NBExportDataPanel.column3"), RB.getString((String)"gui.dialog.NBExportDataPanel.column4")};
        Object[][] data = new Object[viewSet.chromosomeCount()][4];
        for (int i = 0; i < viewSet.chromosomeCount(); ++i) {
            GTView view = viewSet.getView(i);
            data[i][0] = true;
            data[i][1] = view.getChromosomeMap().getName();
            data[i][2] = view.countSelectedMarkers() + " / " + view.countGenuineMarkers();
            data[i][3] = view.countSelectedLines() + " / " + view.lineCount();
            if (!view.getChromosomeMap().isSpecialChromosome()) continue;
            data[i][0] = false;
        }
        this.table.setModel(new DefaultTableModel(data, columnNames){

            public Class getColumnClass(int c) {
                return this.getValueAt(0, c).getClass();
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 0;
            }
        });
        DefaultTableCellRenderer cr = new DefaultTableCellRenderer();
        cr.setHorizontalAlignment(0);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.table.setDefaultRenderer(String.class, cr);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (e.getSource() != this.bCancel) break block4;
                        this.setVisible(false);
                        break block5;
                    }
                    if (e.getSource() != this.bExport) break block6;
                    if (this.combo.getSelectedIndex() == 0) {
                        this.exportMap();
                    } else {
                        this.exportDat();
                    }
                    break block5;
                }
                if (e.getSource() != this.selectAllLabel) break block7;
                for (int i = 0; i < this.table.getRowCount(); ++i) {
                    this.table.setValueAt(true, i, 0);
                }
                break block5;
            }
            if (e.getSource() != this.selectNoneLabel) break block5;
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                this.table.setValueAt(false, i, 0);
            }
        }
    }

    private int getMarkerCount(boolean[] chrm) {
        boolean allMarkers = this.rAll.isSelected();
        int count = 0;
        for (int i = 0; i < this.viewSet.chromosomeCount(); ++i) {
            if (!chrm[i]) continue;
            GTView view = this.viewSet.getView(i);
            if (allMarkers) {
                count += view.markerCount();
                continue;
            }
            count += view.countSelectedMarkers();
        }
        return count;
    }

    private int getLineCount() {
        boolean allLines = this.rAll.isSelected();
        if (allLines) {
            return this.viewSet.getView(0).lineCount();
        }
        return this.viewSet.getView(0).countSelectedLines();
    }

    private void exportMap() {
        boolean useAll = this.rAll.isSelected();
        boolean[] chrm = this.getSelectedChromosomes();
        int count = this.getMarkerCount(chrm);
        String name = this.baseName + "_" + count + ".map";
        File filename = this.promptForFilename(new File(name), "map");
        if (filename != null) {
            ChromosomeMapExporter exporter = new ChromosomeMapExporter(filename, this.viewSet, useAll, chrm, count);
            this.displayDialog((ITrackableJob)exporter, filename);
        }
    }

    private void exportDat() {
        boolean useAll = this.rAll.isSelected();
        boolean[] chrm = this.getSelectedChromosomes();
        int mrkrCount = this.getMarkerCount(chrm);
        int lineCount = this.getLineCount();
        String name = this.baseName + "_" + this.viewSet.getName() + "_" + lineCount + "x" + mrkrCount + ".dat";
        File filename = this.promptForFilename(new File(name), "dat");
        if (filename != null) {
            GenotypeDataExporter exporter = new GenotypeDataExporter(filename, this.viewSet, useAll, chrm, lineCount);
            this.displayDialog((ITrackableJob)exporter, filename);
        }
    }

    private void displayDialog(ITrackableJob exporter, File filename) {
        ProgressDialog dialog = new ProgressDialog(exporter, RB.format((String)"gui.dialog.ExportDataDialog.exportTitle", (Object[])new Object[0]), RB.format((String)"gui.dialog.ExportDataDialog.exportLabel", (Object[])new Object[0]), (Frame)Flapjack.winMain);
        if (dialog.failed("gui.error")) {
            return;
        }
        TaskDialog.info((String)RB.format((String)"gui.dialog.ExportDataDialog.exportSuccess", (Object[])new Object[]{filename}), (String)RB.getString((String)"gui.text.close"));
    }

    private File promptForFilename(File name, String extension) {
        FileNameExtensionFilter filter = new FileNameExtensionFilter(RB.getString((String)("other.Filters." + extension)), extension);
        String filename = FlapjackUtils.getSaveFilename(RB.getString((String)"gui.dialog.ExportDataDialog.saveDialog"), name, filter);
        if (filename != null) {
            return new File(filename);
        }
        return null;
    }

    boolean[] getSelectedChromosomes() {
        boolean[] array = new boolean[this.table.getRowCount()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (Boolean)this.table.getValueAt(i, 0);
        }
        return array;
    }

    private void initComponents() {
        this.dialogPanel1 = new DialogPanel();
        this.bExport = new JButton();
        this.bCancel = new JButton();
        this.bHelp = new JButton();
        this.mapPanel = new JPanel();
        this.radioLabel = new JLabel();
        this.rAll = new JRadioButton();
        this.rSelected = new JRadioButton();
        this.label = new JLabel();
        this.combo = new JComboBox();
        this.tableLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.selectAllLabel = new HyperLinkLabel();
        this.label2 = new JLabel();
        this.selectNoneLabel = new HyperLinkLabel();
        this.setDefaultCloseOperation(2);
        this.bExport.setText("Export...");
        this.dialogPanel1.add((Component)this.bExport);
        this.bCancel.setText("Cancel");
        this.dialogPanel1.add((Component)this.bCancel);
        this.bHelp.setText("Help");
        this.dialogPanel1.add((Component)this.bHelp);
        this.mapPanel.setBorder(BorderFactory.createTitledBorder("Export options:"));
        this.radioLabel.setText("Include information for the following markers and lines:");
        this.rAll.setSelected(true);
        this.rAll.setText("All markers and lines");
        this.rSelected.setText("Only markers and lines I have selected");
        this.label.setText("Export file type:");
        this.tableLabel.setText("Only include data from the following selected chromosomes:");
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.table.setRowSelectionAllowed(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.table);
        this.selectAllLabel.setText("Select all");
        this.label2.setText("|");
        this.selectNoneLabel.setText("Select none");
        GroupLayout mapPanelLayout = new GroupLayout(this.mapPanel);
        this.mapPanel.setLayout(mapPanelLayout);
        mapPanelLayout.setHorizontalGroup(mapPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mapPanelLayout.createSequentialGroup().addContainerGap().addGroup(mapPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mapPanelLayout.createSequentialGroup().addComponent(this.label).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.combo, 0, 319, Short.MAX_VALUE)).addComponent(this.rAll).addComponent(this.radioLabel).addComponent(this.rSelected).addComponent(this.jScrollPane1, -1, 407, Short.MAX_VALUE).addGroup(mapPanelLayout.createSequentialGroup().addComponent((Component)this.selectAllLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.label2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.selectNoneLabel, -2, -1, -2)).addComponent(this.tableLabel)).addContainerGap()));
        mapPanelLayout.setVerticalGroup(mapPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mapPanelLayout.createSequentialGroup().addContainerGap().addGroup(mapPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label).addComponent(this.combo, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.radioLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rSelected).addGap(18, 18, 18).addComponent(this.tableLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 153, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mapPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label2).addComponent((Component)this.selectAllLabel, -2, -1, -2).addComponent((Component)this.selectNoneLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.dialogPanel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.mapPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.mapPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.dialogPanel1, -2, 44, -2)));
        this.pack();
    }
}

